game.UI.RegisterForEvents()
engine.SetIncrementalGCTime(250)
local util = require("ui.util")
local fsm = require("ui.fsm")
local LookAtConsts = require("game.lookAtConsts")
LookAtConsts.RegisterDuringUIStartup()
local uiHooks = require("ui.uihooks")
uiHooks.Install()
local scripts = require("ui.scripts")
local ui_states = {}
for _, script in ipairs(scripts) do
  if "table" == type(script) and "UIAIStateMachine" == script.CLASSNAME then
    ui_states[1 + #ui_states] = script
  end
end
function OnUpdate(level)
  engine.PushProfileMarker("CheckEnable")
  if not util.Enabled() then
    engine.PopProfileMarker()
    return
  end
  engine.PopProfileMarker()
  uiHooks.ProcessInCombatEvent()
  if nil ~= game.UI.ResetStateVars then
    engine.ProfileCall("UI.ResetStateVars", game.UI.ResetStateVars)
  end
  engine.ProfileCall("fsm.Update", fsm.Update, level:GetUnitTime())
end
function OnScriptLoaded(level)
  util.OnScriptLoaded(level)
end
function OnLevelShutdown(level)
  if game.Restarting() then
    fsm.HandleRestart()
  end
  if game.Quitting() then
    fsm.HandleGameQuit()
  end
end
function OnSaveCheckpoint(level)
  local tab = {}
  fsm.OnSaveCheckpoint(tab)
  return tab
end
function OnRestoreCheckpoint(level, tab)
  fsm.OnRestoreCheckpoint(tab)
end
