local tablex = require("core.tablex")
local classlib = require("core.class")
local fsm = require("ui.fsm")
local util = require("ui.util")
local UI = game.UI
local pickupConsts = require("ui.pickupConsts")
local pickupUtil = require("ui.pickupUtil")
local AnimationModule_Son = classlib.Class("AnimationModule_Son", fsm.UIState)
local AM_Son_Off = AnimationModule_Son:StateClass("AM_Son_Off", fsm.UIState)
local AM_Son_On = AnimationModule_Son:StateClass("AM_Son_On", fsm.UIState)
local AM_Son_Available = AnimationModule_Son:StateClass("AM_Son_Available", fsm.UIState)
local AM_Son_InTransition = AnimationModule_Son:StateClass("AM_Son_InTransition", fsm.UIState)
local animationModule_Son = AnimationModule_Son.New("animationModule_Son", {
  AM_Son_Off,
  AM_Son_On,
  {AM_Son_Available, AM_Son_InTransition}
})
local poses = {front = 1, back = 2}
local creatureName = "goSon00"
local currAnimTime, _currAnimData, _currMenu, _currSubmenu
local animData = {
  SonEnterFrontPose = {
    Duration = 2,
    Branch = "BRA_UI_EnterFrontPose",
    Pose = poses.front
  },
  SonEnterBackPose = {
    Duration = 2,
    Branch = "BRA_UI_EnterBackPose",
    Pose = poses.back
  },
  SonFrontPose = {
    Duration = 0,
    Branch = "BRA_UI_PauseIdlePose",
    Pose = poses.front
  },
  SonBackPose = {
    Duration = 0,
    Branch = "BRA_UI_PopToBackPose",
    Pose = poses.back
  }
}
function ResetCloth()
  local uiCreature = pickupUtil.GetUICreature(pickupConsts.TAG_PICKUP_SON)
  if uiCreature ~= nil then
    uiCreature:ResetCloth()
  end
end
function AnimationModule_Son:Setup()
end
function AnimationModule_Son:Enter()
  self:Goto("AM_Son_Off")
end
function AnimationModule_Son:Exit()
end
function AnimationModule_Son:EVT_PAUSE_MENU_CLOSED()
  self:Goto("AM_Son_Off")
end
function AnimationModule_Son:EVT_PAUSE_MENU_OPEN()
  self:Goto("AM_Son_On")
end
function AnimationModule_Son:EVT_ResetClothForced()
  ResetCloth()
end
local InitAnims = function()
  _currMenu = "Weapon"
  _currAnimData = animData.SonFrontPose
  util.ForceUICreatureMove(creatureName, animData.SonFrontPose.Branch)
  ResetCloth()
end
function AM_Son_Off:Setup()
  InitAnims()
end
function AM_Son_Off:Enter()
end
function AM_Son_Off:Exit()
end
function AM_Son_On:Setup()
end
function AM_Son_On:Enter()
  if not util.SonUI_ShouldShow() then
    util.ForceUICreatureMove("goSon00", "BRA_UI_PauseIdlePose")
    self:Goto("AM_Son_Off")
  else
    _currMenu = nil
    _currSubmenu = nil
    self:PlayAnim(animData.SonFrontPose)
    self:Goto("AM_Son_Available")
  end
end
function AM_Son_On:PlayAnim(currAnimData)
  if _currAnimData ~= nil and _currAnimData.Pose == currAnimData.Pose then
    return
  end
  currAnimTime = currAnimData.Duration
  _currAnimData = currAnimData
  util.ForceUICreatureMove(creatureName, currAnimData.Branch)
  self:Goto("AM_Son_InTransition")
end
function AM_Son_On:Exit()
  InitAnims()
end
function AM_Son_On:EVT_Submenu_OnTransition(newSubmenu)
  local prevSubmenu = _currSubmenu
  local fsm_Available = self:GetState("AM_Son_Available")
  if fsm_Available:IsActive() then
    fsm_Available:OnTransition(prevSubmenu, newSubmenu)
  end
  _currSubmenu = newSubmenu
end
function AM_Son_On:EVT_InWorldMenu_OnTransition(oldMenu, newMenu)
  _currMenu = newMenu
end
function AM_Son_Available:Setup()
  self._parent = self:GetState("AM_Son_On")
end
function AM_Son_Available:Enter()
  local inSonSubmenu = _currMenu == "Weapon" and _currSubmenu == "SonBow"
  if inSonSubmenu and _currAnimData.Pose ~= poses.back then
    self._parent:PlayAnim(animData.SonEnterBackPose)
  elseif not inSonSubmenu and _currAnimData.Pose ~= poses.front then
    self._parent:PlayAnim(animData.SonEnterFrontPose)
  end
end
function AM_Son_Available:Exit()
end
function AM_Son_Available:OnTransition(oldMenu, newSubmenu)
  if _currMenu == "Weapon" and newSubmenu == "SonBow" then
    self._parent:PlayAnim(animData.SonEnterBackPose)
  else
    self._parent:PlayAnim(animData.SonEnterFrontPose)
  end
end
function AM_Son_InTransition:Setup()
  self._parent = self:GetState("AM_Son_On")
end
function AM_Son_InTransition:Enter()
  self:StartTimer("TransitionTimer", currAnimTime, function()
    self:Goto("AM_Son_Available")
  end)
end
function AM_Son_InTransition:Exit()
  currAnimTime = nil
end
