local frameNode = require("ui.frameNode")
local frameConsts = require("ui.frameConsts")
local Frame = {}
setmetatable(Frame, {
  __index = frameNode.FrameNode
})
function Frame.New(gameObject)
  assert(gameObject, "A nil gameobject was passed into Frame constructor.")
  local newTable = {
    _gameObject = gameObject,
    _initialPosition = game.UI.GetGOLocalPosition(gameObject),
    _bounds = nil,
    _initialHeight = nil,
    _height = nil,
    _active = true,
    _constrainToText = false,
    _textPadding = 0.5,
    _textHeight = 1
  }
  local mt = {__index = Frame}
  setmetatable(newTable, mt)
  return newTable
end
function Frame:Init(args)
  assert(type(args) == "table", "Argument passed to frame initializer was not a table.")
  if args.height ~= nil then
    self._height = args.height
    self._initialHeight = args.height
  end
  self._active = true
end
function Frame:SetInitialHeight(amount)
  self._initialHeight = amount
  if self._height == nil then
    self._height = amount
  end
end
function Frame:GetInitialHeight()
  return self._initialHeight
end
function Frame:GetHeight()
  return self._height
end
function Frame:GetPosition()
  if self._gameObject ~= nil then
    return game.UI.GetGOLocalPosition(self._gameObject)
  else
    return nil
  end
end
function Frame:SetPosition(vPos)
  assert(self._gameObject)
  game.UI.SetGOLocalPosition(self._gameObject, vPos)
end
function Frame:ResetHeight()
  self:SetScaleY(self._initialHeight)
end
function Frame:SetScaleY(amount)
  game.UI.SetGOScale(self._gameObject, engine.Vector.New(1, amount, 1))
end
function Frame:SetTextPadding(amount)
  self._textPadding = amount
end
function Frame:SetTextHeight(height)
  self._textHeight = height
end
function Frame:FitToText()
  local newSize = self._textHeight * self:GetTextLineCount() + 2 * self._textPadding
  self:SetGOHeight(newSize)
end
function GetTextLineCount()
  return 0
end
function Frame:GetGameObject()
  return self._gameObject
end
function Frame:SetHeight(amount)
  self._height = amount
end
function Frame:SetGOHeight(amount)
  local unitsConvertedToScale = 1 / self._initialHeight * amount
  self._height = amount
  self:SetScaleY(unitsConvertedToScale)
end
return {Frame = Frame}
