local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local frame = require("ui.frame")
local frameGroup = require("ui.frameGroup")
local util = require("ui.util")
local UI = game.UI
local SetText = game.UI.SetText
local GetTextHandle = util.GetTextHandle
local Card = {}
function Card.New(gameObjectRefnode)
  assert(gameObjectRefnode ~= nil, "GameObject reference entered into BaseCard constructor was nil.")
  local newTable = {
    _gameObject = gameObjectRefnode,
    _components = {},
    _properties = {},
    _children = {},
    _frameGroupCore = nil
  }
  local mt = {__index = Card}
  setmetatable(newTable, mt)
  return newTable
end
function Card:BaseInit(useFrameGroup)
  if useFrameGroup then
    self._frameGroupCore = frameGroup.FrameGroup.New()
    self._frameGroupCore:SetPadding(0)
    self._frameGroupCore:SetBorderPadding(0)
  end
  self:InitComponents()
end
function Card:Init()
  local children = self.children
  children.goRoot = self._gameObject:FindSingleGOByName("Root")
  local useFrameGroup = false
  self:BaseInit(useFrameGroup)
end
function Card:AddComponent(component)
  component._card = self
  tablex.FastInsert(self._components, component, #self._components + 1)
end
function Card:InitComponents()
  for componentIndex, component in ipairs(self._components) do
    component:BaseInit(componentIndex)
    component:Init()
    local showAll = true
    component:Show(showAll)
    if self:IsUsingFrameGroup() then
      if componentIndex == 1 then
        self._frameGroupCore:AddRoot(component:GetFrame())
      else
        self._frameGroupCore:AddNode(component:GetFrame(), componentIndex - 1)
      end
    end
  end
end
function Card:BaseUpdate()
  self:UpdateComponents()
  if self:IsUsingFrameGroup() then
    self._frameGroupCore:Update()
  end
  self:PostUpdate()
end
function Card:Update()
  self:BaseUpdate()
end
function Card:PostUpdate()
  self:PostUpdateComponents()
end
function Card:UpdateComponents()
  for _, component in ipairs(self._components) do
    component:Update()
  end
end
function Card:PostUpdateComponents()
  for _, component in ipairs(self._components) do
    component:PostUpdate()
  end
end
function Card:ShowCard(showAll)
  self._gameObject:Show()
  if showAll then
    for _, obj in pairs(self.children) do
      if type(obj) == "table" then
        self:ShowCard_Recursive(obj)
      else
        obj:Show()
      end
    end
  end
end
function Card:ShowCard_Recursive(obj)
  if type(obj) == "table" then
    for _, childObj in pairs(obj) do
      self:ShowCard_Recursive(childObj)
    end
  else
    obj:Show()
  end
end
function Card:SetProperty(key, value)
  self._properties[key] = value
end
function Card:GetProperty(key)
  return self._properties[key]
end
function Card:IsUsingFrameGroup()
  return self._frameGroupCore ~= nil
end
function Card:GetCardHeight()
  return self.backFrame:GetHeight()
end
function Card:Empty()
end
function Card:DoDefaultTransitionAnim(offset)
  assert(offset == nil or type(offset) == "table", "Call to Card:DoDefaultTransitionAnim included invalid offset parameter.")
  local cardOffset = offset ~= nil and offset or engine.Vector.New(0, 0, 0)
  animationUtil.DoDefaultTransitionAnim(self._gameObject.Child, cardOffset)
end
function Card:HideCard()
  self._gameObject:Hide()
end
return {Card = Card}
