local frame = require("ui.frame")
local tablex = require("core.tablex")
local util = require("ui.util")
local UI = game.UI
local CardComponent = {}
function CardComponent.New(goParent, name)
  assert(goParent ~= nil, "GameObject card parent reference entered into BaseCard constructor was nil.")
  local newTable = {
    _name = name,
    _isActive = false,
    _card = nil,
    _goParent = goParent,
    _gameObject = nil,
    _children = {},
    _height = nil,
    _componentIndex = -1,
    _frame = nil
  }
  local mt = {__index = CardComponent}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent:BaseInit(componentIndex)
  assert(self._name ~= nil, "Name was not defined in CardComponent:BaseInit")
  local name = tostring(self._name)
  if self._gameObject == nil then
    self._gameObject = self._goParent:FindSingleGOByName("CardComponent_" .. name)
  end
  assert(self._gameObject ~= nil, "GameObject was not found with name " .. name .. " for CardComponent:BaseInit")
  self._children.goRoot = self._gameObject.Child
  assert(self._card ~= nil, "No card set for CardComponent:" .. self._name .. ", with gameObject: " .. tostring(self._gameObject:GetName()))
  assert(componentIndex ~= nil, "No componentIndex assigned to card component.")
  self._componentIndex = componentIndex
  self._frame = frame.Frame.New(self._gameObject)
  self._frame:SetHeight(self._height or 1)
  self._isActive = true
end
function CardComponent:Init()
end
function CardComponent:Update()
end
function CardComponent:PostUpdate()
end
function CardComponent:Show(showAll)
  self._gameObject:Show()
  if showAll then
    for _, obj in pairs(self._children) do
      if type(obj) == "table" then
        self:Show_Recursive(obj)
      else
        obj:Show()
      end
    end
  end
end
function CardComponent:Show_Recursive(obj)
  if type(obj) == "table" then
    for _, childObj in pairs(obj) do
      self:Show_Recursive(childObj)
    end
  else
    obj:Show()
  end
end
function CardComponent:Hide()
  self._gameObject:Hide()
end
function CardComponent:SetCard(card)
  self._card = card
end
function CardComponent:SetActive(value)
  self._isActive = value
  if self._frame ~= nil then
    self._frame:SetActive(value)
  end
  if value then
    self._gameObject:Show()
  else
    self._gameObject:Hide()
  end
end
function CardComponent:IsActive()
  return self._isActive
end
function CardComponent:SetHeight(value)
  self._height = value
  if self._frame ~= nil then
    self._frame:SetHeight(value)
  end
end
function CardComponent:SetProperty(key, value)
  return self._card:SetProperty(key, value)
end
function CardComponent:GetProperty(key)
  return self._card._properties[key]
end
function CardComponent:GetHeight()
  return self._height
end
function CardComponent:GetFrame()
  return self._frame
end
function CardComponent:GetComponentIndex()
  return self._componentIndex
end
return {CardComponent = CardComponent}
