local tablex = require("core.tablex")
local attributeUtil = require("ui.attributeUtil")
local cardComponent = require("ui.cardComponent")
local iconConsts = require("ui.iconConsts")
local lamsConsts = require("ui.lamsConsts")
local util = require("ui.util")
local UI = game.UI
local MAX_ATTRIBUTE_BONUS_ROW_COUNT = 2
local CardComponent_AttributeBonus = {}
setmetatable(CardComponent_AttributeBonus, {
  __index = cardComponent.CardComponent
})
function CardComponent_AttributeBonus.New(goParent)
  assert(goParent ~= nil, "GameObject reference entered into CardComponent_AttributeBonus constructor was nil.")
  local newTable = {
    _name = "AttributeBonus",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_AttributeBonus}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_AttributeBonus:Init()
  for i = 1, MAX_ATTRIBUTE_BONUS_ROW_COUNT do
    local goRowRefnode = self._goParent:FindSingleGOByName("Row" .. tostring(i))
    goRowRefnode:Show()
    goRowRefnode.Child:Show()
  end
  self._children.goText_NoBonus = self._goParent:FindSingleGOByName("Text_NoBonus")
  self.rows = {}
  local GetTextHandle = util.GetTextHandle
  for i = 1, MAX_ATTRIBUTE_BONUS_ROW_COUNT do
    self.rows[i] = {}
    local gameObject = self._goParent:FindSingleGOByName("Row" .. tostring(i)).Child
    self.rows[i].gameObject = gameObject
    self.rows[i].thDescription = GetTextHandle(gameObject, "Text_Description")
    self.rows[i].thRequires = GetTextHandle(gameObject, "Text_Requires")
    self.rows[i].thAmount = GetTextHandle(gameObject, "Text_Amount")
  end
end
function CardComponent_AttributeBonus:Update()
  local Color = util.StyleText
  local SetText = UI.SetText
  local bonusTable = self:GetProperty("BonusTable")
  local character = self:GetProperty("Character")
  local goHeader = self._goParent:FindSingleGOByName("Text_Header")
  if 0 < #bonusTable then
    goHeader:Show()
  end
  for i = 1, MAX_ATTRIBUTE_BONUS_ROW_COUNT do
    local row = self.rows[i]
    if i < #bonusTable + 1 then
      local bonus = bonusTable[i]
      local requiredAttribute = bonus.Info.AttributeCondition
      local attributeString = attributeUtil.GetDisplayName(requiredAttribute)
      local currentAmount = attributeUtil.GetCurrentlyEquippedAttributeOnCharacter(character, requiredAttribute)
      local requiredAmount = bonus.Info.ConditionAmount
      local hasEnough = currentAmount >= requiredAmount
      local color = hasEnough and "Color_White" or "Color_Red"
      local currentAmount_string = Color(tostring(currentAmount), color)
      local requiredAmount_string = tostring(requiredAmount)
      local descriptionString = util.GetLAMSMsg(bonus.Info.Lams)
      local requiresString = util.GetLAMSMsg(lamsConsts.Requires) .. " " .. attributeUtil.GetStatDisplayName(requiredAttribute)
      local amountString = currentAmount_string .. " / " .. requiredAmount_string
      SetText(row.thDescription, descriptionString)
      SetText(row.thRequires, requiresString)
      SetText(row.thAmount, amountString)
      row.gameObject:Show()
    else
      row.gameObject:Hide()
    end
  end
  if 0 < #bonusTable then
    self._children.goText_NoBonus:Hide()
  else
    self._children.goText_NoBonus:Show()
  end
end
return {CardComponent_AttributeBonus = CardComponent_AttributeBonus}
