local tablex = require("core.tablex")
local attributeUtil = require("ui.attributeUtil")
local cardComponent = require("ui.cardComponent")
local mapUtil = require("ui.mapUtil")
local util = require("ui.util")
local UI = game.UI
local CardComponent_Attributes_Weapon = {}
setmetatable(CardComponent_Attributes_Weapon, {
  __index = cardComponent.CardComponent
})
function CardComponent_Attributes_Weapon.New(goParent)
  assert(goParent ~= nil, "GameObject parent reference entered into CardComponent_Attributes_Weapon constructor was nil.")
  local newTable = {
    _name = "Attributes_Weapon",
    _goParent = goParent,
    _gameObject = nil,
    _children = {},
    _height = 8
  }
  local mt = {__index = CardComponent_Attributes_Weapon}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_Attributes_Weapon:Init()
  self._children.goReinforcementUpgradeArrow = self._gameObject:FindSingleGOByName("ReinforcementUpgradeArrow")
  self._children.goReinforcementAttrArrow = self._gameObject:FindSingleGOByName("ReinforcementAttrUpgradeArrow")
  self._children.goReinforcementRightArrow = self._gameObject:FindSingleGOByName("ReinforcementRightArrow")
  self._thPowerLevel = util.GetTextHandle(self._gameObject.Child, "LevelNum")
  self._thAttrShortName = util.GetTextHandle(self._gameObject.Child, "AttributeName")
  self._thAttrNumber = util.GetTextHandle(self._gameObject.Child, "AttributeNumber")
  self._thAttrNumberUpgrade = util.GetTextHandle(self._gameObject.Child, "AttributeNumberUpgrade")
  self._thReinforcementPowerLevel = util.GetTextHandle(self._gameObject.Child, "ReinforcementUpgradeNum")
end
function CardComponent_Attributes_Weapon:Update()
  local powerLevelString = self:GetProperty("PowerLevel")
  local upgradedPowerLevel = self:GetProperty("PowerLevel_Preview")
  local isReinforcementRecipe = self:GetProperty("IsReinforcementRecipe")
  UI.SetText(self._thPowerLevel, tostring(powerLevelString))
  if isReinforcementRecipe then
    self._children.goReinforcementUpgradeArrow:Show()
    UI.SetText(self._thReinforcementPowerLevel, tostring(upgradedPowerLevel))
  else
    self._children.goReinforcementUpgradeArrow:Hide()
    UI.SetText(self._thReinforcementPowerLevel, "")
  end
  local shortName = self:GetProperty("ShortAttr_Name")
  local shortDisplayValue = self:GetProperty("ShortAttr_Value")
  local upgradedAttr = self:GetProperty("ShortAttr_Value_Preview")
  if shortName then
    UI.SetText(self._thAttrShortName, attributeUtil.GetDisplayName(shortName))
    UI.SetText(self._thAttrNumber, tostring(shortDisplayValue))
    if isReinforcementRecipe then
      UI.SetText(self._thAttrNumberUpgrade, tostring(upgradedAttr))
      self._children.goReinforcementAttrArrow:Show()
      self._children.goReinforcementRightArrow:Show()
    else
      UI.SetText(self._thAttrNumberUpgrade, "")
      self._children.goReinforcementAttrArrow:Hide()
      self._children.goReinforcementRightArrow:Hide()
    end
    self:SetActive(true)
  else
    self:SetActive(false)
  end
end
return {CardComponent_Attributes_Weapon = CardComponent_Attributes_Weapon}
