local tablex = require("core.tablex")
local cardComponent = require("ui.cardComponent")
local mapUtil = require("ui.mapUtil")
local util = require("ui.util")
local UI = game.UI
local CardComponent_Description = {}
setmetatable(CardComponent_Description, {
  __index = cardComponent.CardComponent
})
function CardComponent_Description.New(goParent)
  assert(goParent ~= nil, "GameObject parent reference entered into CardComponent_Description constructor was nil.")
  local newTable = {
    _name = "Description",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_Description}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_Description:Init()
  self._customBackings = {}
  self:AddCustomBacking("Axe")
  self:AddCustomBacking("Blades")
  self:AddCustomBacking("SonBow")
end
function CardComponent_Description:AddCustomBacking(name)
  self._customBackings[name] = self._gameObject:FindSingleGOByName("customBacking_" .. tostring(name))
  assert(self._customBackings[name])
end
function CardComponent_Description:EnableCustomBacking(name)
  if self._customBackings[name] == nil then
    return
  end
  local jid_defaultBacking = self._gameObject.Child:GetJointIndex("perk_item_info_backing")
  self._gameObject.Child:HideJoint(jid_defaultBacking)
  for _, goBacking in pairs(self._customBackings) do
    goBacking:Hide()
  end
  self._customBackings[name]:Show()
end
function CardComponent_Description:Update()
  local headerMessage = self:GetProperty("Description")
  local thHeader = util.GetTextHandle(self._children.goRoot, "DescriptionText")
  if headerMessage ~= nil then
    UI.SetText(thHeader, headerMessage)
  else
    UI.SetText(thHeader, "")
  end
  local customBacking = self:GetProperty("CustomDescriptionBacking")
  if customBacking ~= nil then
    self:EnableCustomBacking(customBacking)
  end
end
return {CardComponent_Description = CardComponent_Description}
