local tablex = require("core.tablex")
local cardComponent = require("ui.cardComponent")
local lamsConsts = require("ui.lamsConsts")
local util = require("ui.util")
local UI = game.UI
local CardComponent_MapSummaryFooter = {}
setmetatable(CardComponent_MapSummaryFooter, {
  __index = cardComponent.CardComponent
})
function CardComponent_MapSummaryFooter.New(goParent)
  assert(goParent ~= nil, "GameObject parent reference entered into CardComponent_MapSummaryFooter constructor was nil.")
  local newTable = {
    _name = "Footer",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_MapSummaryFooter}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_MapSummaryFooter:Update()
  local totalRegionProgress = self:GetProperty("TotalRegionProgress")
  local totalRegionGoal = self:GetProperty("TotalRegionGoal")
  assert(totalRegionProgress ~= nil and totalRegionGoal ~= nil, "Missing region information in CardComponent_MapSummaryFooter:Update")
  local percentageString = tostring(math.floor(100 * totalRegionProgress / totalRegionGoal))
  local completionString = util.FormatLAMSString(lamsConsts.COMPLETION, percentageString)
  if totalRegionGoal == 0 then
    completionString = ""
  end
  local textHandle = util.GetTextHandle(self._children.goRoot, "Text")
  UI.SetText(textHandle, completionString)
end
return {CardComponent_MapSummaryFooter = CardComponent_MapSummaryFooter}
