local tablex = require("core.tablex")
local cardComponent = require("ui.cardComponent")
local lamsConsts = require("ui.lamsConsts")
local mapUtil = require("ui.mapUtil")
local util = require("ui.util")
local UI = game.UI
local CardComponent_Header = {}
setmetatable(CardComponent_Header, {
  __index = cardComponent.CardComponent
})
function CardComponent_Header.New(goParent)
  assert(goParent ~= nil, "GameObject parent reference entered into CardComponent_Header constructor was nil.")
  local newTable = {
    _name = "Header",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_Header}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_Header:Init()
  self._children.goHeaderBacking = self._children.goRoot:FindSingleGOByName("mapMenu_Header")
  local summaryType = self:GetProperty("SummaryType")
  if summaryType == "Region" then
    self._updateFunc = self.Update_Region
  elseif summaryType == "Realm" then
    self._updateFunc = self.Update_Realm
  end
end
function CardComponent_Header:Update_Region()
  local regionInfo = self:GetProperty("RegionInfo")
  if regionInfo ~= nil then
    local regionDisplayName = mapUtil.RegionInfo_GetDisplayName(regionInfo)
    local headerMessage = util.GetLAMSMsg(lamsConsts.Region) .. " : " .. regionDisplayName
    local thHeader = util.GetTextHandle(self._children.goRoot, "Text")
    UI.SetText(thHeader, headerMessage)
  end
end
function CardComponent_Header:Update_Realm()
  local realmInfo = self:GetProperty("RealmInfo")
  local nameLams = util.GetLAMSMsg(realmInfo.LamsNameId)
  local textHandle = util.GetTextHandle(self._children.goRoot, "Text")
  UI.SetText(textHandle, nameLams .. " " .. util.GetLAMSMsg(lamsConsts.Summary))
end
function CardComponent_Header:UpdateColor()
  local headerColor = self:GetProperty("HeaderColor")
  if headerColor ~= nil then
    local goHeaderObj = self._children.goHeaderBacking
    local material = "mapHeader"
    local layer = "LayerX"
    local attribute = "cst_EmissiveTint"
    util.SetGameObjectColor(goHeaderObj, headerColor, material, layer, attribute)
  end
end
function CardComponent_Header:Update()
  local headerMessage = self:GetProperty("Header")
  if headerMessage ~= nil then
    local thHeader = util.GetTextHandle(self._children.goRoot, "Text")
    UI.SetText(thHeader, headerMessage)
  else
    self:_updateFunc()
  end
end
return {CardComponent_Header = CardComponent_Header}
