local tablex = require("core.tablex")
local cardComponent = require("ui.cardComponent")
local questConsts = require("ui.questConsts")
local util = require("ui.util")
local UI = game.UI
local CardComponent_QuestSummary = {}
setmetatable(CardComponent_QuestSummary, {
  __index = cardComponent.CardComponent
})
function CardComponent_QuestSummary.New(goParent)
  assert(goParent ~= nil, "GameObject reference entered into CardComponent_QuestSummary constructor was nil.")
  local newTable = {
    _name = "QuestSummary",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_QuestSummary}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_QuestSummary:Init()
  self._children.goQuestIcon = self._children.goRoot:FindSingleGOByName("QuestIcon")
end
function CardComponent_QuestSummary:Update()
  local headerMessage = self:GetProperty("QuestHeader")
  local descriptionMessage = self:GetProperty("QuestDescription")
  local questType = self:GetProperty("Type")
  if headerMessage ~= nil then
    local thHeader = util.GetTextHandle(self._children.goRoot, "QuestHeader")
    UI.SetText(thHeader, headerMessage)
  end
  if descriptionMessage ~= nil then
    local thDescription = util.GetTextHandle(self._children.goRoot, "QuestDescription")
    UI.SetText(thDescription, descriptionMessage)
  end
  self._children.goQuestIcon:SetMaterialSwap(questType == questConsts.QUEST_CATEGORY_MAIN and "MainQuest" or "SideQuest")
end
return {CardComponent_QuestSummary = CardComponent_QuestSummary}
