local tablex = require("core.tablex")
local cardComponent = require("ui.cardComponent")
local util = require("ui.util")
local UI = game.UI
local CardComponent_Separator = {}
setmetatable(CardComponent_Separator, {
  __index = cardComponent.CardComponent
})
function CardComponent_Separator.New(goParent, gameObject)
  assert(goParent ~= nil, "GameObject reference entered into CardComponent_Separator constructor was nil.")
  local newTable = {
    _name = "Separator",
    _goParent = goParent,
    _gameObject = gameObject,
    _children = {},
    _height = 0
  }
  local mt = {__index = CardComponent_Separator}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_Separator:SetAssociatedComponent(associatedComponent)
  self._associatedComponent = associatedComponent
end
function CardComponent_Separator:PostUpdate()
  if self._associatedComponent ~= nil then
    self:SetActive(self._associatedComponent:IsActive())
  end
end
return {CardComponent_Separator = CardComponent_Separator}
