local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local cardComponent = require("ui.cardComponent")
local util = require("ui.util")
local UI = game.UI
local CardComponent_Video = {}
setmetatable(CardComponent_Video, {
  __index = cardComponent.CardComponent
})
function CardComponent_Video.New(goParent)
  assert(goParent ~= nil, "GameObject reference entered into CardComponent_Video constructor was nil.")
  local newTable = {
    _name = "Video",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_Video}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_Video:Init()
end
function CardComponent_Video:PlayVideo()
  local currentSkill = self:GetProperty("VideoNameToPlay")
  animationUtil.PlayVideo(currentSkill)
end
function CardComponent_Video:Update()
  self:PlayVideo()
end
return {CardComponent_Video = CardComponent_Video}
