local tablex = require("core.tablex")
local consts = require("ui.consts")
local cardComponent = require("ui.cardComponent")
local gemUtil = require("ui.gemUtil")
local iconConsts = require("ui.iconConsts")
local lamsConsts = require("ui.lamsConsts")
local mapUtil = require("ui.mapUtil")
local skillTreeConsts = require("ui.skillTreeConsts")
local util = require("ui.util")
local UI = game.UI
local Pickup = game.Pickup
local MAX_GEM_ATTRIBUTES = 6
local CardComponent_WeaponPreviewAttributes = {}
setmetatable(CardComponent_WeaponPreviewAttributes, {
  __index = cardComponent.CardComponent
})
function CardComponent_WeaponPreviewAttributes.New(goParent)
  assert(goParent ~= nil, "GameObject parent reference entered into CardComponent_WeaponPreviewAttributes constructor was nil.")
  local newTable = {
    _name = "Attributes",
    _goParent = goParent,
    _gameObject = nil,
    _children = {}
  }
  local mt = {__index = CardComponent_WeaponPreviewAttributes}
  setmetatable(newTable, mt)
  return newTable
end
function CardComponent_WeaponPreviewAttributes:Init(showBacking)
  self._attributeMeters = {}
  self._children.goAnimatedBacking_Axe = self._goParent:FindSingleGOByName("perk_item_info_backing_axe")
  self._children.goAnimatedBacking_Blades = self._goParent:FindSingleGOByName("perk_item_info_backing_blades")
  self._children.goAnimatedBacking_Bow = self._goParent:FindSingleGOByName("perk_item_info_backing_bow")
  if showBacking then
    self._children.goAnimatedBacking_Axe:Show()
  end
  for i = 1, MAX_GEM_ATTRIBUTES do
    local currentAttr = {}
    currentAttr.goRoot = self._children.goRoot:FindSingleGOByName("Stat" .. tostring(i))
    currentAttr.goRoot:Show()
    currentAttr.goRoot.Child:Show()
    currentAttr.thName = util.GetTextHandle(currentAttr.goRoot.Child, "AttributeName")
    currentAttr.thNumber = util.GetTextHandle(currentAttr.goRoot.Child, "AttributeNumber")
    self._attributeMeters[i] = currentAttr
  end
  local goRoot = self._gameObject.Child
  local jid_PowerLevelHousing = goRoot:GetJointIndex("PowerLevelHousing")
  local jid_WeaponSpecialIconHousing = goRoot:GetJointIndex("WeaponSpecialIconHousing")
  goRoot:HideJoint(jid_PowerLevelHousing)
  self._thIconText = util.GetTextHandle(goRoot, "IconText")
end
function CardComponent_WeaponPreviewAttributes:Update()
  local powerLevel = self:GetProperty("PowerLevel")
  local thPowerLevel = self._thIconText
  local weaponSpecial = self:GetProperty("Item")
  if powerLevel ~= nil then
    UI.SetText(thPowerLevel, iconConsts[weaponSpecial])
  else
    UI.SetText(thPowerLevel, "")
  end
  local gemName = self:GetProperty("Item")
  local stageNum = Pickup.GetProfileStage(gemName)
  local includeLevel = true
  local statsTable = gemUtil.GetStatsTable(gemName, includeLevel)
  assert(#statsTable <= MAX_GEM_ATTRIBUTES, "More attributes defined for weapon special than is currently supported in the gem card.")
  self._attributeMeters[1].goRoot:Hide()
  for i = 1, MAX_GEM_ATTRIBUTES - 1 do
    local attrExists = i <= #statsTable
    local currAttrUI = self._attributeMeters[i + 1]
    if attrExists then
      local attributeTable = statsTable[i]
      UI.SetText(currAttrUI.thName, tostring(gemUtil.GetStatDisplayName(attributeTable.Name)))
      local displayValue = "--"
      displayValue = tostring(attributeTable.GetValue(gemName))
      if attributeTable.Name == "Cooldown" then
        displayValue = displayValue .. " " .. util.StyleText(util.GetLAMSMsg(lamsConsts.Sec), "ClearCaseTransform")
      end
      UI.SetText(currAttrUI.thNumber, displayValue)
      currAttrUI.goRoot:Show()
    else
      currAttrUI.goRoot:Hide()
    end
  end
  local posStart = 0
  local posEnd = 1
  local animRate = 1
  self._children.goAnimatedBacking_Axe:Hide()
  self._children.goAnimatedBacking_Blades:Hide()
  self._children.goAnimatedBacking_Bow:Hide()
  if gemUtil.IsAxeWeaponSpecial(gemName) then
    UI.Anim(self._children.goAnimatedBacking_Axe, consts.AS_Forward, "", animRate, posStart, posEnd)
    self._children.goAnimatedBacking_Axe:Show()
  elseif gemUtil.IsBladesWeaponSpecial(gemName) then
    UI.Anim(self._children.goAnimatedBacking_Blades, consts.AS_Forward, "", animRate, posStart, posEnd)
    self._children.goAnimatedBacking_Blades:Show()
  else
    UI.Anim(self._children.goAnimatedBacking_Bow, consts.AS_Forward, "", animRate, posStart, posEnd)
    self._children.goAnimatedBacking_Bow:Show()
  end
end
return {CardComponent_WeaponPreviewAttributes = CardComponent_WeaponPreviewAttributes}
