local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local card = require("ui.card")
local cardComponent_Header = require("ui.cardComponent_Header")
local cardComponent_Description = require("ui.cardComponent_Description")
local lamsConsts = require("ui.lamsConsts")
local pickupUtil = require("ui.pickupUtil")
local runeUtil = require("ui.runeUtil")
local util = require("ui.util")
local UI = game.UI
local SetText = game.UI.SetText
local GetTextHandle = util.GetTextHandle
local EmptyCard = {}
setmetatable(EmptyCard, {
  __index = card.Card
})
function EmptyCard.New(gameObjectReference)
  assert(gameObjectReference ~= nil, "GameObject reference entered into EmptyCard constructor was nil.")
  local newTable = {
    _gameObject = gameObjectReference,
    _components = {},
    _textHandles = {},
    _properties = {}
  }
  local mt = {__index = EmptyCard}
  setmetatable(newTable, mt)
  return newTable
end
function EmptyCard:Init(isRuneCard)
  local goRefnode = self._gameObject
  local goRoot = goRefnode.Child
  goRoot:Show()
  self._isRuneCard = isRuneCard
  self._children = {}
  self:AddComponent(cardComponent_Header.CardComponent_Header.New(goRefnode))
  self:AddComponent(cardComponent_Description.CardComponent_Description.New(goRefnode))
  self:HideCard()
  local useFrameGroup = false
  self:BaseInit(useFrameGroup)
end
function EmptyCard:Update(pickupSlot, animateDefaultTransition)
  self:SetHeader(pickupSlot)
  self:SetDescription(pickupSlot)
  self:BaseUpdate()
  if self._prevItem ~= pickupSlot or animateDefaultTransition then
    self:DoDefaultTransitionAnim()
  end
  self._prevItem = pickupSlot
end
function EmptyCard:SetHeader(pickupSlot)
  if self._isRuneCard then
    self:SetProperty("Header", runeUtil.GetSocketDisplayName(pickupSlot))
  else
    self:SetProperty("Header", pickupUtil.GetSlotDisplayName(pickupSlot))
  end
end
function EmptyCard:SetDescription(pickupSlot)
  if self._isRuneCard then
    self:SetProperty("Description", util.GetLAMSMsg(lamsConsts.EmptyMessage_RuneUpgrade))
  else
    self:SetProperty("Description", pickupUtil.GetEmptySlotDescription(pickupSlot))
  end
end
return {EmptyCard = EmptyCard}
