local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local card = require("ui.card")
local cardComponent_Header = require("ui.cardComponent_Header")
local cardComponent_MapSummaryList = require("ui.cardComponent_MapSummaryList")
local cardComponent_MapSummaryFooter = require("ui.cardComponent_MapSummaryFooter")
local util = require("ui.util")
local UI = game.UI
local SetText = game.UI.SetText
local GetTextHandle = util.GetTextHandle
local MapSummaryCard = {}
setmetatable(MapSummaryCard, {
  __index = card.Card
})
function MapSummaryCard.New(gameObjectReference)
  assert(gameObjectReference ~= nil, "GameObject reference entered into MapSummaryCard constructor was nil.")
  local newTable = {
    _gameObject = gameObjectReference,
    _components = {},
    _textHandles = {},
    _properties = {}
  }
  local mt = {__index = MapSummaryCard}
  setmetatable(newTable, mt)
  return newTable
end
function MapSummaryCard:Init(summaryType)
  self:SetProperty("SummaryType", summaryType)
  local goRefnode = self._gameObject
  local goRoot = goRefnode.Child
  goRoot:Show()
  self._children = {}
  self._children.goBlur = self._gameObject:FindSingleGOByName("MapSummary_Blur")
  self:AddComponent(cardComponent_Header.CardComponent_Header.New(goRefnode))
  self:AddComponent(cardComponent_MapSummaryList.CardComponent_MapSummaryList.New(goRefnode))
  self:AddComponent(cardComponent_MapSummaryFooter.CardComponent_MapSummaryFooter.New(goRefnode))
  self:HideCard()
  local useFrameGroup = true
  self:BaseInit(useFrameGroup)
end
function MapSummaryCard:UpdateAccessibilityScaling()
  if UI.GetAccessibilityScaling == nil then
    return
  end
  local summaryType = self:GetProperty("SummaryType")
  if summaryType == "Region" then
    self._gameObject:SetLocalPosition(engine.Vector.New(7.65 - UI.GetAccessibilityScaling(0, 1.24), 5.182, 0))
    self._gameObject:SetScale(UI.GetAccessibilityScaling(1, 1.15))
  elseif summaryType == "Realm" then
    self._gameObject:SetScale(UI.GetAccessibilityScaling(1, 1.15))
  else
    assert(false, "No proper summary type was assigned to MapSummaryCard. Value was: " .. tostring(summaryType))
  end
end
function MapSummaryCard:Update(doTransitionAnim)
  if doTransitionAnim then
    self:DoDefaultTransitionAnim()
  end
  self:BaseUpdate()
end
function MapSummaryCard:ShowCard(showAll)
  self._gameObject:Show()
  if showAll then
    for _, obj in pairs(self.children) do
      if type(obj) == "table" then
        self:ShowCard_Recursive(obj)
      else
        obj:Show()
      end
    end
  end
  self:DoDefaultTransitionAnim()
end
function MapSummaryCard:SetOnScreen(onScreen, instant)
  local time = instant and 0 or 0.2
  local fadeAlpha = onScreen and 1 or 0
  UI.AlphaFade(self._gameObject, fadeAlpha, time)
  UI.AlphaFade(self._children.goBlur, fadeAlpha, time)
end
return {MapSummaryCard = MapSummaryCard}
