local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local card = require("ui.card")
local cardComponent_Header = require("ui.cardComponent_Header")
local cardComponent_QuestSummary = require("ui.cardComponent_QuestSummary")
local lamsConsts = require("ui.lamsConsts")
local questConsts = require("ui.questConsts")
local questUtil = require("ui.questUtil")
local util = require("ui.util")
local UI = game.UI
local SetText = game.UI.SetText
local GetTextHandle = util.GetTextHandle
local QuestSummaryCard = {}
setmetatable(QuestSummaryCard, {
  __index = card.Card
})
function QuestSummaryCard.New(gameObjectReference)
  assert(gameObjectReference ~= nil, "GameObject reference entered into QuestSummaryCard constructor was nil.")
  local newTable = {
    _gameObject = gameObjectReference,
    _components = {},
    _textHandles = {},
    _properties = {}
  }
  local mt = {__index = QuestSummaryCard}
  setmetatable(newTable, mt)
  return newTable
end
function QuestSummaryCard:Init(type)
  self:SetProperty("Type", type)
  local goRefnode = self._gameObject
  local goRoot = goRefnode.Child
  goRoot:Show()
  self:AddComponent(cardComponent_Header.CardComponent_Header.New(goRefnode))
  self:AddComponent(cardComponent_QuestSummary.CardComponent_QuestSummary.New(goRefnode))
  self:InitComponents()
  local headerMessage = self:GetProperty("Type") == questConsts.QUEST_CATEGORY_MAIN and util.GetLAMSMsg(lamsConsts.TheJourney) or util.GetLAMSMsg(lamsConsts.TrackedFavor)
  self:SetProperty("Header", headerMessage)
  self:SetProperty("QuestHeader", util.GetLAMSMsg(lamsConsts.NoActiveGoal))
  self:HideCard()
end
function QuestSummaryCard:SetQuest(questID)
  self:SetProperty("HeaderColor", self:GetProperty("Type") == questConsts.QUEST_CATEGORY_MAIN and {
    1,
    0,
    0
  } or {
    0,
    1,
    0
  })
  if questID == nil then
    self:Empty()
  else
    local rootQuestID = questUtil.GetRootQuestID(questID)
    self:SetProperty("QuestHeader", questUtil.GetQuestTitleFromID(rootQuestID))
    self:SetProperty("QuestDescription", "[Bulletpoint]" .. tostring(questUtil.GetQuestTitleFromID(questID)))
    self:Update()
  end
end
function QuestSummaryCard:Empty()
  self:SetProperty("QuestHeader", util.GetLAMSMsg(lamsConsts.NoActiveGoal))
  self:SetProperty("QuestDescription", "")
  self:Update()
end
function QuestSummaryCard:ShowCard(showAll)
  self._gameObject:Show()
  if showAll then
    for _, obj in pairs(self.children) do
      if type(obj) == "table" then
        self:ShowCard_Recursive(obj)
      else
        obj:Show()
      end
    end
  end
  self:DoDefaultTransitionAnim()
end
function QuestSummaryCard:SetOnScreen(onScreen, instant)
  local time = instant and 0 or 0.2
  local fadeAlpha = onScreen and 1 or 0
  UI.AlphaFade(self._gameObject, fadeAlpha, time)
end
return {QuestSummaryCard = QuestSummaryCard}
