local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local card = require("ui.card")
local cardComponent_Header = require("ui.cardComponent_Header")
local cardComponent_Description = require("ui.cardComponent_Description")
local cardComponent_WeaponPreviewAttributes = require("ui.cardComponent_WeaponPreviewAttributes")
local gemUtil = require("ui.gemUtil")
local pickupUtil = require("ui.pickupUtil")
local util = require("ui.util")
local UI = game.UI
local SetText = game.UI.SetText
local GetTextHandle = util.GetTextHandle
local WeaponSpecialPreviewCard = {}
setmetatable(WeaponSpecialPreviewCard, {
  __index = card.Card
})
function WeaponSpecialPreviewCard.New(gameObjectReference)
  assert(gameObjectReference ~= nil, "GameObject reference entered into WeaponSpecialPreviewCard constructor was nil.")
  local newTable = {
    _gameObject = gameObjectReference,
    _components = {},
    _textHandles = {},
    _properties = {}
  }
  local mt = {__index = WeaponSpecialPreviewCard}
  setmetatable(newTable, mt)
  return newTable
end
function WeaponSpecialPreviewCard:Init(summaryType)
  self:SetProperty("SummaryType", summaryType)
  local goRefnode = self._gameObject
  local goRoot = goRefnode.Child
  goRoot:Show()
  self:AddComponent(cardComponent_Header.CardComponent_Header.New(goRefnode))
  self:AddComponent(cardComponent_Description.CardComponent_Description.New(goRefnode))
  self:AddComponent(cardComponent_WeaponPreviewAttributes.CardComponent_WeaponPreviewAttributes.New(goRefnode))
  self:HideCard()
  local useFrameGroup = false
  self:BaseInit(useFrameGroup)
end
function WeaponSpecialPreviewCard:Update(doTransitionAnim)
  if doTransitionAnim then
    self:DoDefaultTransitionAnim()
  end
  local gemName = self:GetProperty("Item")
  self:SetHeader(gemName)
  self:SetDescription(gemName)
  self:SetLevel(gemName)
  self:BaseUpdate()
end
function WeaponSpecialPreviewCard:SetHeader(gemName)
  self:SetProperty("Header", pickupUtil.GetDisplayName(gemName))
end
function WeaponSpecialPreviewCard:SetDescription(gemName)
  self:SetProperty("Description", pickupUtil.GetDescription(gemName))
  local weapon = "SonBow"
  if gemUtil.IsAxeWeaponSpecial(gemName) then
    weapon = "Axe"
  elseif gemUtil.IsBladesWeaponSpecial(gemName) then
    weapon = "Blades"
  end
  self:SetProperty("CustomDescriptionBacking", weapon)
end
function WeaponSpecialPreviewCard:SetLevel(gemName)
  local currentGemLevel = tostring(gemUtil.GetCurrentLevel(gemName))
  self:SetProperty("PowerLevel", currentGemLevel)
end
function WeaponSpecialPreviewCard:ShowCard(showAll)
  self._gameObject:Show()
  if showAll then
    for _, obj in pairs(self.children) do
      if type(obj) == "table" then
        self:ShowCard_Recursive(obj)
      else
        obj:Show()
      end
    end
  end
  self:DoDefaultTransitionAnim()
end
function WeaponSpecialPreviewCard:SetOnScreen(onScreen, instant)
  local time = instant and 0 or 0.2
  local fadeAlpha = onScreen and 1 or 0
  UI.AlphaFade(self._gameObject, fadeAlpha, time)
end
return {WeaponSpecialPreviewCard = WeaponSpecialPreviewCard}
