local classlib = require("core.class")
local consts = require("ui.consts")
local colors = require("ui.colors")
local messageRow = require("ui.messageRow")
local pickupUtil = require("ui.pickupUtil")
local pickupConsts = require("ui.pickupConsts")
local resourceConsts = require("ui.resourceConsts")
local util = require("ui.util")
local UI = game.UI
local MessageRowTimer = classlib.Class("MessageRowTimer", messageRow.MessageRow)
function MessageRowTimer:init(state, args)
  self._state = state
  self._formatChangePoint = util.GetValueWithDefault(args.FormatChangePoint, 10)
end
function MessageRowTimer:DisplayRowCount(rowIndex)
  assert(rowIndex ~= nil, "MessageRowTimer attempted to call DisplayRowCount without a row index!")
  local countText
  if self._resourceType == resourceConsts.RESOURCE_FLAG_PICKUP and pickupUtil.HasTag(self._resourceName, pickupConsts.TAG_PICKUP_BUFF_NOTIMER) then
    countText = ""
  else
    local count = self:get_count()
    if count < 0 then
      count = 0
    end
    if count > self._formatChangePoint then
      countText = string.format("%01d", count)
    else
      countText = string.format("%0.1f", count)
    end
    countText = util.InternationalizeTime(countText)
  end
  self:SetOneItemVariable(self._textIndexNames.RowCount, rowIndex, countText)
end
function MessageRowTimer:Start(currMessage, displayRowIndex)
  local goRow = currMessage:GetRowGOByIndex(displayRowIndex)
  local bodyColor = self:GetResourceNameColor()
  self:AnimateIn(goRow, nil)
  self:DisplayRowIcon(goRow)
  self:DisplayRowText(goRow, self:GetDisplayName(), displayRowIndex, bodyColor, nil)
  self:DisplayRowCount(displayRowIndex)
  if displayRowIndex > currMessage:GetDisplayRowIndex() then
    currMessage:SetDisplayRowIndex(displayRowIndex)
  end
end
return {MessageRowTimer = MessageRowTimer}
