local classlib = require("core.class")
local tablex = require("core.tablex")
local buttonUtil = require("ui.buttonUtil")
local consts = require("ui.consts")
local list = require("ui.list")
local util = require("ui.util")
local lamsIDs = require("ui.lamsConsts")
local colors = require("ui.colors")
local UI = game.UI
local Toggle = classlib.Class("Toggle", list.List)
local GetToggleSettingValue = function(toggleItem)
  return toggleItem.Value
end
local GetToggleSettingText = function(toggleItem)
  return toggleItem.Text
end
local GetToggleSettingDesc = function(toggleItem)
  return toggleItem.Desc
end
local GetToggleSettingTip = function(toggleItem)
  return toggleItem.ToolTip
end
function Toggle:init(state, args)
  self._active = false
  self._maxFocusableObjectCount = 1
  self._button_onGainFocus_sound = args.Button_OnGainFocus_Sound
  self._thSettingDesc = args.SettingDescTextHandle
  self._onToggleFunc = args.OnToggleFunc
  self._wrap = util.GetValueWithDefault(args.Wrap, false)
  self._selectionChangeSound = util.GetValueWithDefault(args.SelectionChangeSound, "SND_UX_Menu_Tick_Horizontal")
  self._listObjectName = util.GetValueWithDefault(args.ToggleObjectName, args.ListObjectName)
  self._dummyButton = nil
  self._allButtonGOs = {}
  self._previousReleaseEvents = {}
  self._nextReleaseEvents = {}
  if args.Settings ~= nil then
    self._settings = args.Settings
  else
    self._settings = {
      {
        Text = util.GetLAMSMsg(lamsIDs.Off),
        Value = false
      },
      {
        Text = util.GetLAMSMsg(lamsIDs.On),
        Value = true
      }
    }
  end
  if args.PreviousEvents ~= nil then
    self._previousEvents = args.PreviousEvents
  else
    local dpadEvent = self._padRepeatRate == 0 and "EVT_Left_Release" or "EVT_Left_Press"
    self._previousEvents = {
      dpadEvent,
      "EVT_LeftStick_Left"
    }
  end
  for _, eventName in ipairs(self._previousEvents) do
    if consts.RELEASE_EVENTS[eventName] ~= nil then
      tablex.FastInsert(self._previousReleaseEvents, consts.RELEASE_EVENTS[eventName], #self._previousReleaseEvents + 1)
    end
  end
  if args.NextEvents ~= nil then
    self._nextEvents = args.NextEvents
  else
    local dpadEvent = self._padRepeatRate == 0 and "EVT_Right_Release" or "EVT_Right_Press"
    self._nextEvents = {
      dpadEvent,
      "EVT_LeftStick_Right"
    }
  end
  for _, eventName in ipairs(self._nextEvents) do
    if consts.RELEASE_EVENTS[eventName] ~= nil then
      tablex.FastInsert(self._nextReleaseEvents, consts.RELEASE_EVENTS[eventName], #self._nextReleaseEvents + 1)
    end
  end
  function self._Button_OnGainFocus(button)
    self:Button_OnGainFocus(button)
  end
  self._default = args.Default
  self._Get = args.Get
  self._Set = args.Set
  if not util.IsStringNilOrEmpty(self._listObjectName) then
    local goList = util.GetUiObjByName(self._listObjectName)
    assert(goList ~= nil, "Toggle " .. self._listObjectName .. " game object not found!")
    self:SetGameObject(goList)
    self:SetupDummyButton()
    self:Setup()
  end
end
function Toggle:get_settings()
  local settings = self._settings
  if type(self._settings) == "function" then
    settings = self._settings()
  end
  for _, item in ipairs(settings) do
    item.Toggle = true
  end
  return settings
end
function Toggle:Setup()
  local settings = self:get_settings()
  local currValue = self._Get()
  local currValueIndex = 1
  self:CreateButtonArray(settings, nil, function(setting)
    return GetToggleSettingText(setting)
  end)
  for buttonIndex, button in ipairs(self._buttonArray) do
    local setting = button:get_item()
    local settingValue = GetToggleSettingValue(setting)
    if settingValue == currValue then
      currValueIndex = buttonIndex
      break
    end
  end
  self:SetSelectedButton(currValueIndex, false)
  self:Update()
end
function Toggle:Button_OnGainFocus(button)
  if self._Set ~= nil then
    local currentSetting = button:get_item()
    local currentValue = GetToggleSettingValue(currentSetting)
    self._Set(currentValue)
  end
  self:Update()
end
function Toggle:Update()
  local currentButton = self:GetSelectedButton()
  local currentSetting = currentButton:get_item()
  local currentText = GetToggleSettingText(currentSetting)
  local currentDesc = GetToggleSettingDesc(currentSetting)
  local currentToolTip = GetToggleSettingTip(currentSetting)
  self:UpdateButtons()
  if self._active then
    self:SetDescText(currentDesc)
    self:OnToggleFunction()
    self:ToggleToolTip(currentToolTip)
  end
  self:UpdateScrollDirectionIndicators()
end
function Toggle:ToggleToolTip(tip)
  if tip ~= nil then
    self._state:SendEventToUIFsm("globalMenu", "EVT_SET_FOOTER_TOOL_TIP_TOP", tip)
  end
end
function Toggle:OnToggleFunction()
  if self._onToggleFunc ~= nil then
    local currentButton = self:GetSelectedButton()
    local currentSetting = currentButton:get_item()
    local currentValue = GetToggleSettingValue(currentSetting)
    self._onToggleFunc(currentValue)
  end
end
function Toggle:SetGameObject(goList)
  assert(goList ~= nil, "Toggle:SetGameObject called with no game object!")
  self._goList = goList
  self._buttonObjectBaseName = "Button"
  self._goListChild = self._goList:FindSingleGOByName("toggle")
  self:SetupAllButtonGameObjects()
  self:SetupHeader()
  self:SetupBacking()
  self:SetupScrollDirectionIndicators()
  self:SetupScrollbar()
end
function Toggle:SetDescText(currentDesc)
  if self._thSettingDesc ~= nil then
    UI.SetText(self._thSettingDesc, "")
    if not util.IsStringNilOrEmpty(currentDesc) then
      UI.SetText(self._thSettingDesc, currentDesc)
    end
  end
end
function Toggle:SetDefault(toggleIsFocused)
  if self._default ~= nil then
    local default_value = self._default()
    if default_value ~= nil then
      self:ForceSetValue(default_value)
    end
  end
end
function Toggle:ForceSetValue(value)
  if self._Set ~= nil then
    self._Set(value)
    local currValueIndex = 1
    for buttonIndex, button in ipairs(self._buttonArray) do
      local setting = button:get_item()
      local settingValue = GetToggleSettingValue(setting)
      if settingValue == value then
        currValueIndex = buttonIndex
        break
      end
    end
    self:SetSelectedButton(currValueIndex, false)
  end
end
function Toggle:DisableText()
  local currentButton = self:GetSelectedButton()
  currentButton:SetTextColor(colors.Text_Settings_Disabled, "medium_text_settings1")
end
function Toggle:EnableText()
  local currentButton = self:GetSelectedButton()
  currentButton:SetTextColor(colors.Text_Settings1, "medium_text_settings1")
end
function Toggle:OverrideSettings(newSettingsList)
  if newSettingsList then
    self._settings = newSettingsList
  else
    self._settings = {
      {
        Text = util.GetLAMSMsg(lamsIDs.Off),
        Value = false
      },
      {
        Text = util.GetLAMSMsg(lamsIDs.On),
        Value = true
      }
    }
  end
  self:Setup()
end
function Toggle:SetScrollBarVisibility()
end
function Toggle:SetScrollBarPosition()
end
return {Toggle = Toggle}
