local tablex = require("core.tablex")
local consts = require("ui.consts")
local frame = require("ui.frame")
local frameConsts = require("ui.frameConsts")
local frameGroup = require("ui.frameGroup")
local util = require("ui.util")
local UI = game.UI
local TopNavBar = {}
function TopNavBar.New(list)
  assert(list ~= nil, "Cannot create a TopNavBar without a list!")
  local newTable = {
    list = list,
    textHandles = {}
  }
  local mt = {__index = TopNavBar}
  setmetatable(newTable, mt)
  return newTable
end
function CreateFrame(goButton)
  local frame = frame.Frame.New(goButton)
  local goText = goButton:FindSingleGOByName("text")
  local thButton = util.GetTextHandle(goText)
  frame:SetHeight(1)
  return frame, thButton
end
function TopNavBar:Init(maxMainMenuButtonCount)
  self._frameGroup = frameGroup.FrameGroup.New()
  local goButtonParent = util.GetUiObjByName("globalMenu_MainMenuList")
  self._frameGroup:SetPadding(0)
  self._frameGroup:SetBorderPadding(0)
  self._frameGroup:SetOrientation(frameConsts.ORIENTATION.Horizontal)
  self._frameGroup:SetDirection(frameConsts.DIRECTION.Right)
  local goPrevIndicator = self.list:GetDirectionIndicator(consts.STEP_PREV)
  local prevIndicatorFrame = frame.Frame.New(goPrevIndicator)
  prevIndicatorFrame:SetHeight(1)
  self._frameGroup:AddRoot(prevIndicatorFrame)
  local buttons = self.list:GetButtons()
  for iButton = 1, maxMainMenuButtonCount do
    local goButton = goButtonParent:FindSingleGOByName("Button" .. tostring(iButton))
    local frame, textHandle = CreateFrame(goButton)
    local goBlur = goButton:FindSingleGOByName("button_Blur")
    goBlur:Show()
    self._frameGroup:AddNode(frame, iButton)
    tablex.FastInsert(self.textHandles, textHandle, iButton)
  end
  local goNextIndicator = self.list:GetDirectionIndicator(consts.STEP_NEXT)
  local nextIndicatorFrame = frame.Frame.New(goNextIndicator)
  nextIndicatorFrame:SetHeight(1)
  self._frameGroup:AddNode(nextIndicatorFrame)
  self._frameGroup:Update()
end
function TopNavBar:SetFrameActive(iFrame, active)
  assert(type(iFrame) == "number")
  assert(type(active) == "boolean")
  self._frameGroup:GetNode(iFrame):SetActive(active)
end
function GetTextHandleWidth(handle, gameObject)
  local vVert1, vVert2 = UI.GetQuad(handle, 2)
  local quadWidth = math.abs(vVert2.x - vVert1.x)
  local scale = 1
  if UI.GetGOScale ~= nil then
    scale = UI.GetGOScale(gameObject).x
  end
  local vTextExtent = UI.GetTextExtent(handle)
  return quadWidth * scale * vTextExtent.x
end
function TopNavBar:ClearSelection()
  for _, handle in ipairs(self.textHandles) do
    UI.SetTextStyle(handle, "PauseTopNav", 0)
  end
end
function TopNavBar:UpdatePositions()
  for index, _ in ipairs(self.textHandles) do
    local node = self._frameGroup:GetNode(index)
    local width = 3.1
    node:SetHeight(width)
  end
  self._frameGroup:Update()
end
return {TopNavBar = TopNavBar}
