local util = require("ui.util")
local iconChars = {
  Stats = "A",
  Journal = "B",
  Focus = "C",
  Defense = "D",
  Quests = "E",
  Luck = "F",
  Map = "G",
  Resources = "H",
  Runic = "I",
  SkillTree = "J",
  Strength = "K",
  Resistance = "L",
  Weapon = "M",
  Axe_Tier01_Throw_Node01_SubNode02 = "N",
  Axe_Tier01_Throw_Node01 = "O",
  Axe_Tier01_Throw_Node01_SubNode01 = "P",
  Axe_Tier01_Throw_PaintTargetUpgrade = "Q",
  Axe_Tier01_Throw_PaintTargetUpgrade_02 = "R",
  Axe_Tier01_Throw_Node01_SubNode03 = "S",
  Axe_Tier01_Throw_CriticalThrowUpgrade = "\199\144",
  Axe_Tier01_Throw_Node01_SubNode04 = "T",
  Axe_Tier01_Throw_Node01_SubNode05 = "U",
  Axe_Tier01_Melee_Node01_SubNode01 = "V",
  Axe_Tier01_Melee_Node01_SubNode02 = "W",
  Axe_Tier01_Melee_Node01 = "X",
  Axe_Tier01_Momentum_Unlock_01 = "Y",
  Axe_Tier01_Melee_Node01_SubNode03 = "Z",
  Axe_Tier01_AxeEvadeAttack_Light = "a",
  Axe_Tier01_Momentum_Unlock_02 = "b",
  Axe_Tier01_Melee_Node01_SubNode04 = "c",
  Axe_Tier01_AxeEvadeAttack_Light_Back = "d",
  Axe_Tier02_Melee_Node01 = "e",
  Axe_Tier02_AxeDelayComboUpgrade = "f",
  Axe_Tier02_Melee_Node01_SubNode01 = "g",
  Axe_Tier02_AxeDelayComboUpgrade_02 = "h",
  Axe_Tier02_AxeDelayComboUpgrade_Heavy = "i",
  Axe_Tier01_BlockBreak = "k",
  Axe_Tier01_Bare_Node01 = "l",
  Axe_Tier01_BareEvadeAttack_Light = "m",
  Axe_Tier01_ParryAttack_Light = "n",
  Axe_Tier01_Bare_Node01_SubNode01 = "\200\143",
  Axe_Tier01_Bare_Node01_SubNode02 = "p",
  Axe_Tier01_ParryAttack_Heavy = "q",
  Axe_Tier01_BareHeavyHold_Upgrade = "\200\142",
  Axe_Tier01_Bare_Node01_SubNode03 = "s",
  Axe_Tier01_ParryProjectile = "t",
  Axe_Tier02_Bare_Node01 = "u",
  Axe_Tier02_Bare_Node01_SubNode01 = "v",
  Axe_RageMode_Upgrade_R1_Base = "r",
  Axe_RageMode_Upgrade_L1_Base = "\200\136",
  Axe_RageMode_Upgrade_R1Hold = "\200\146",
  Blades_RageMode_Upgrade_R1Mash = "\200\141",
  Axe_RageMode_Upgrade_R2 = "y",
  Axe_RageMode_Upgrade_R2Hold = "\200\139",
  Blades_RageMode_Upgrade_L1 = "\200\137",
  Blades_RageMode_Upgrade_L2 = "\199\148",
  Blades_Tier01_Melee_Node01_SubNode03 = "\193",
  Blades_Tier01_Melee_Node01_SubNode02 = "\194",
  Blades_Tier01_Melee_Node01 = "\192",
  Blades_Tier01_Melee_Node01_SubNode01 = "\197",
  Blades_Tier01_Melee_Node01_SubNode04 = "\195",
  Blades_Tier01_Melee_Evade_Forward = "\198",
  Blades_Tier01_Melee_Evade_Back = "\208",
  Blades_Tier02_Melee_Node01 = "\202",
  Blades_Tier02_Melee_Delay_Light_Upgrade_01 = "\200",
  Blades_Tier02_Melee_Node01_SubNode01 = "\206",
  Blades_Tier02_Melee_Delay_HeavyBomb = "\204",
  Blades_Toss_Light_Unlock = "\209",
  Blades_Momentum_01 = "\212",
  Blades_Tier01_Bare_Node01 = "\210",
  Blades_Tier01_Toss_Light_Upgrade = "\199\145",
  Blades_Momentum_02 = "\199\146",
  Blades_Tier01_Bare_Node01_SubNode01 = "\199\147",
  Blades_TossSurge_Lvl02 = "\216",
  Blades_Blade_Toss_Upgrade = "\213",
  Blades_ElementalPrecision_Level03 = "\222",
  Blades_StatUpgrade_Strength = "\218",
  Blades_StatUpgrade_Luck = "\219",
  Blades_StatUpgrade_Runic = "\220",
  Recipe_SonPerk_LightArrow_Potency_Tier01 = "\205",
  Recipe_SonPerk_LightArrow_Potency_Tier02 = "\211",
  Recipe_SonPerk_LightArrow_Potency_Tier03 = "\214",
  Recipe_SonPerk_LightArrow_WeakenDefense = "\199",
  Recipe_SonPerk_LightArrow_ExplosionRadius = "\201",
  Recipe_SonPerk_LightArrow_ExplosionSpread = "\203",
  Recipe_SonPerk_ShockArrow_Potency_Tier01 = "\217",
  Recipe_SonPerk_ShockArrow_Potency_Tier02 = "\221",
  Recipe_SonPerk_ShockArrow_Potency_Tier03 = "\225",
  Recipe_SonPerk_ShockArrow_OnHitSpark = "\226",
  Recipe_SonPerk_ShockArrow_DetonationConduit = "\228",
  Recipe_SonPerk_ShockArrow_SparkRate = "\224",
  Recipe_SonPerk_FollowUp = "\229",
  Recipe_SonPerk_LockDownTarget = "\227",
  Recipe_SonPerk_CloseCombat = "\230",
  Recipe_Bow_Skill_ArrowDamage_Tier01 = "\240",
  Recipe_Bow_Skill_ArrowDamage_Tier02 = "\233",
  Recipe_Bow_Skill_ArrowDamage_Tier03 = "\234",
  Recipe_Bow_Skill_Deftness_Tier01 = "\235",
  Recipe_Bow_Skill_Deftness_Tier02 = "\232",
  Recipe_Bow_Skill_Deftness_Tier03 = "\237",
  HiddenSkill = "?",
  FrostSpecialAxeSweep = "\238",
  FrostSpecialAxeSpin = "\239",
  FrostSpecialAxeSwipeCharge = "\236",
  FrostSpecialAxeDashCombo = "j",
  FrostSpecialAxeQuickClear = "\241",
  FrostSpecialAxeTossRail = "o",
  FrostSpecialAxeTossGrind = "\243",
  FrostSpecialAxeBeam = "\244",
  FrostSpecialAxeUpwardSlice = "\199\155",
  FrostSpecialAxeLeap = "\199\156",
  FrostSpecialAxeFlurryChop = "\199\157",
  FrostSpecialAxeTossThrowdown = "\199\158",
  FrostSpecialAxeTossGlaive = "\199\149",
  FrostSpecialAxeWeaponBuff = "\199\150",
  FrostSpecialAxeRake = "\199\151",
  FrostSpecialAxeGandalfSlam = "\199\152",
  BladeSpecialTwirlBarrage = "\246",
  BladeSpecialSpin = "\207",
  BladeSpecialFlurryStab = "\242",
  BladeSpecialFlurrySpin = "\248",
  BladeSpecialShieldRush = "\245",
  BladeSpecialCross = "\254",
  BladeSpecialShotgun = "\223",
  BladeSpecialFireClap = "\250",
  BladeSpecialTripleSlam = "\251",
  BladeSpecialSweepSlam = "\231",
  BladeSpecialWeaponBuff = "\252",
  BladeSpecialFireWave = "\249",
  BladeSpecialHopSlam = "w",
  BladeSpecialMine = "\196",
  BladeSpecialGrapple = "\200\138",
  BladeSpecialMeteorSlam = "\201\128",
  SummonFenrir = "x",
  SummonBird = "\253",
  SummonDeer = "\255",
  SummonRatatoskr = "z",
  SummonBoar = "\170",
  SummonSouls = "\186",
  KratosArmorTrinket_LowHealth_Shield = "\196\169",
  KratosArmorTrinket_LowHealth_Offense = "\196\170",
  KratosArmorTrinket_RageMode = "\196\171",
  KratosArmorTrinket_RageGrab = "\199\154",
  KratosArmorTrinket_HealthBurst = "\196\172",
  Perk_Quest_TyrTalisman = "\196\173",
  Perk_Utility_Focus_Mode = "\196\177",
  KratosArmorTrinket_Parry = "\196\174",
  Perk_Defense_OnBlock_ActiveAbsorb = "\196\175",
  Perk_Utility_JustEvade_Slowdown = "\196\169",
  Perk_Talisman_WeaponSpecials_Runic = "\196\178",
  Perk_Talisman_Muspelheim = "\196\180",
  Perk_Talisman_Niflheim = "\196\181",
  KratosArmorTrinket_FrostActivation = "\196\183",
  KratosArmorTrinket_CurseActivation = "\196\184",
  KratosArmorTrinket_Gauntlet = "\196\185",
  KratosArmorTrinket_EmpoweringRift = "\196\179",
  KratosArmorTrinket_Valkyrie = "\196\182",
  KratosArmorTrinket_PreOrder = "\200\165",
  WeaponComponent_Blades_Default = "\225\186\131",
  WeaponComponent_Blades_OnKill_OffenseBuff = "\196\163",
  WeaponComponent_Blades_OnKill_DefenseBuff = "\196\165",
  WeaponComponent_Blades_OnKill_RunicBuff = "\196\182",
  WeaponComponent_Blades_OnKill_HealthBurst = "\196\168",
  WeaponComponent_Blades_OnKill_CooldownBurst = "\196\166",
  WeaponComponent_Blades_OnKill_RageBurst = "\196\164",
  WeaponComponent_Blades_OnDamage_ProcFire = "\196\154",
  WeaponComponent_Blades_OnDamage_ProcBomb = "\196\155",
  WeaponComponent_Blades_OnLaunch_Shield = "\196\157",
  WeaponComponent_Blades_OnLaunch_OffenseBuff = "\196\156",
  WeaponComponent_Blades_OnHeadshot_OffenseBuff = "\196\160",
  WeaponComponent_Blades_OnHeadshot_DefenseBuff = "\196\162",
  WeaponComponent_Blades_OnHeadshot_CooldownBurst = "\196\161",
  WeaponComponent_Blades_Muspelheim01 = "\196\158",
  WeaponComponent_Blades_Nidavellir01 = "\196\159",
  WeaponComponent_Blades_Valkyrie01 = "\196\153",
  WeaponComponent_Axe_Default = "G",
  Perk_Throw_OnHeadshot_Cooldown = "\196\128",
  Perk_Throw_OnHeadshot_HealthDrain = "\196\129",
  Perk_Throw_OnHeadshot_Rage = "\196\130",
  Perk_Throw_OnHeadshot_OffenseBuff = "\196\131",
  Perk_Throw_OnHeadshot_Runic = "\196\132",
  Perk_Offense_AxeHeavyHold_Cooldown = "\196\133",
  Perk_Offense_AxeHeavyHold_HealthBurst = "\196\134",
  Perk_Offense_AxeHeavyHold_RageBurst = "\196\135",
  Perk_Offense_AxeHeavyHold_OffenseBuff = "\196\136",
  Perk_Offense_AxeHeavyHold_RunicBuff = "\196\137",
  Perk_Flat_OnKill_HealthDrain = "\196\138",
  Perk_Flat_OnKill_Rage = "\196\139",
  WeaponComponent_Axe_Cursed = "\196\140",
  Perk_Offense_OnLaunch_Shield = "\196\141",
  Perk_Offense_OnLaunch_OffenseBuff = "\196\142",
  Perk_Offense_OnMeleeDamage_ProcLightning = "\196\143",
  Perk_Offense_OnMeleeDamage_ProcFrost = "\196\144",
  Perk_Offense_OnMeleeDamage_HealthDrain = "\196\145",
  Perk_Offense_OnMeleeDamage_Shield = "\196\146",
  Perk_Weapon_Niflheim = "\196\147",
  WeaponComponent_NifleheimSpecial01 = "\200\145",
  WeaponComponent_NifleheimSpecial02 = "\200\144",
  WeaponComponent_Axe_AllStats = "\200\140",
  WeaponComponent_Axe_Finisher = "\196\148",
  Perk_Weapon_Muspelheim = "\196\149",
  WeaponComponent_Axe_Valkyrie01 = "\196\150",
  WeaponComponent_Axe_Valkyrie02 = "\196\151",
  WeaponComponent_Axe_QueenValkyrie01 = "\196\152",
  Buff_Axe_Musp = "\200\166",
  Buff_Axe_Nid = "\200\169",
  Buff_HealthBurst = "\200\167",
  Buff_HealthBurstSmall = "\200\167",
  Buff_NidCurseHeal = "\200\167",
  Buff_CooldownBurst = "\200\168",
  Buff_TimeBubble = "\200\168",
  Buff_RageBurst = "\200\170",
  Buff_RageBurstSmall = "\200\170",
  Buff_WeaponSpecialRefresh = "\200\171",
  Buff_Talisman_WeaponSpecials_Cooldown = "\200\171",
  DrainEnergy = "\200\172",
  Buff_Shield = "\200\191",
  Buff_DefenseEnhancement = "\200\173",
  Buff_DamageShield = "\200\174",
  Buff_DamageShield_Frost = "\200\175",
  Buff_Muspleheim = "\200\176",
  Buff_ValkyrieProtection = "\200\177",
  Buff_SuperArmor = "\200\178",
  Buff_LightningAxe = "\200\179",
  Buff_ValkyrieAxe = "\200\180",
  Buff_PowerOfTheValkyrie_01 = "\200\181",
  Buff_PowerOfTheValkyrie_02 = "\200\182",
  Buff_PowerOfTheValkyrie_03 = "\200\189",
  Buff_EmpoweringRift_Lvl01 = "\200\184",
  Buff_EmpoweringRift_Lvl02 = "\200\185",
  Buff_EmpoweringRift_Lvl03 = "\200\186",
  Buff_EnhancedBlock = "\200\187",
  Buff_RunicEnhancement = "\200\188",
  Effect_AxeCharged = "\200\188",
  Buff_OffenseEnhancement = "\200\190",
  Buff_JustEvade_Slowdown = "\200\183",
  WeaponBuff_Axe = "\200\188",
  WeaponBuff_Blades = "\200\188",
  Tag_Aura = "\200\155",
  Tag_Attack = "\200\158",
  Tag_Protection = "\200\156",
  Tag_TemporalShift = "\200\157",
  Tag_RestoreRage = "\200\154",
  Tag_RestoreBlight = "\200\154",
  Tag_RestoreHealth = "\200\154",
  Tag_RestoreCooldown = "\200\154",
  Tag_BuffRunic = "\200\155",
  Tag_BuffStrength = "\200\155",
  Tag_BuffDefense = "\200\155",
  Tag_BuffRandom = "\200\155",
  Tag_ResistFrost = "\200\160",
  Tag_ResistFire = "\200\160",
  Tag_ResistBlind = "\200\160",
  Tag_ResistPoison = "\200\160",
  Tag_ResistDarkOne = "\200\160",
  Tag_ResistValkyrie = "\200\160",
  Tag_ResistNiflheim = "\200\160",
  Tag_EnhanceTrait = "\200\159",
  Tag_EnhanceAxeRunic = "\200\159",
  Tag_EnhanceAxeBladeRunic = "\200\159",
  Eir = "\198\154",
  Olrun = "\198\153",
  Kara = "\198\151",
  Hildr = "\198\147",
  Rota = "\198\149",
  Sigrun = "\198\145",
  Geirdriful = "\198\152",
  Gunnr = "\198\150",
  Gondul = "\198\148",
  Magni = "\198\158",
  Modi = "\198\159",
  Baldur = "\198\162",
  Hraezlyr = "\198\164",
  Svartaljqfurr = "\198\155",
  ["Soul Eater"] = "\198\163",
  ["Fire Troll"] = "\198\156",
  ["Ice Troll"] = "\198\157",
  ["Frost Troll"] = "\198\160",
  ["Ash Troll"] = "\198\165",
  ["Guardian Troll"] = "\198\161",
  EconomyXP = "B",
  Hacksilver = "E",
  ResurrectionRuneStoneA = "\197\136",
  ResurrectionRuneStoneB = "\197\136",
  ResurrectionRuneStoneC = "\197\136",
  NorseMask = "\196\190",
  VikingHorn = "\197\140",
  OrnateCup = "\198\167",
  Brooch = "\201\132",
  LostToy = "\197\131",
  ShipHead = "\197\128",
  AlfheimArtifact = "\196\191",
  EnhancedTravelerLoot = "\196\188",
  ReinforcementCommon = "\196\188",
  ReinforcementUncommon = "\196\188",
  ReinforcementRare = "\196\188",
  AsgardianSteel = "\196\188",
  PerfectAsgardianSteel = "\196\188",
  NifTankArmor_Chest_Pattern = "\196\188",
  RecipeInputPickup = "\196\188",
  TalismanReinforcement = "\197\133",
  PureRealmEssence = "\197\133",
  RuneDust = "\197\133",
  PristineRuneDust = "\197\133",
  HiltReinforcement1 = "\197\135",
  HiltReinforcement2 = "\197\135",
  DragonScale = "\197\135",
  PristineScales = "\197\135",
  DragonTooth = "A",
  TravelerLoot = "\197\135",
  UB_Token = "\197\135",
  EternalFrost = "\197\137",
  GlacialCatalyst = "\197\137",
  AxeReinforcement = "\197\137",
  NiflheimAxeReinforcement = "\197\137",
  UnyieldingCinders = "\197\139",
  BladesReinforcement = "\197\139",
  MuspelheimBladesReinforcement = "\197\139",
  CommonMuspelheimLoot01 = "\197\139",
  RareMuspelheimLoot01 = "\197\139",
  RareMuspelheimLoot02 = "\197\139",
  RareMuspelheimLoot03 = "\197\139",
  UnstableOre = "\196\189",
  PristineOre = "\196\189",
  BoatLoot = "\196\189",
  LeiptrAlloy = "\196\189",
  TyrOffering = "\196\189",
  HuldraArmorToken_Chest = "\196\189",
  HuldraArmorToken_Wrist = "\196\189",
  HuldraArmorToken_Legs = "\196\189",
  OblivionStone = "\196\187",
  GolemLoot = "\196\187",
  EnhancedGolemLoot = "\196\187",
  NiflheimCurrency = "\197\141",
  NiflheimRareLootB = "\197\141",
  NiflheimRareLootC = "\197\141",
  NiflheimRareLootD = "\197\141",
  SkapSlag = "\196\189",
  ValkyrieLoot01 = "\198\144",
  ValkyrieLoot02 = "\198\144",
  ValkyrieLoot03 = "\198\144",
  ValkyrieLoot04 = "\198\144",
  ValkyrieLoot05 = "\198\144",
  ValkyrieLoot06 = "\198\144",
  ValkyrieLoot07 = "\198\144",
  ValkyrieLoot08 = "\198\144",
  ValkyrieLootQueen = "\198\144",
  ChiselUnlock = "\197\132",
  MaxHealthUpgradePiece = "\196\186",
  MaxHealthUpgrade = "\196\186",
  MaxHealthUpgradeDisplay_Menu = "\196\186",
  MaxHealthUpgradeDisplay_Card = "\196\186",
  MaxRageUpgradePiece = "\198\166",
  MaxRageUpgrade = "\198\166",
  MaxRageUpgradeDisplay_Menu = "\198\166",
  MaxRageUpgradeDisplay_Card = "\198\166",
  MuspelheimCipherPiece = "\197\134",
  NiflheimCipherPiece = "\197\134",
  EntryStoneVolundr = "\198\143",
  EntryStoneNiflheim = "\198\143",
  EntryStoneForestDungeon = "\198\143",
  EntryStoneHuldra2 = "\198\143",
  EntryStoneHuldra3 = "\198\143",
  EntryStoneVikingFuneral = "\198\143",
  EntryStoneHTTK = "\198\143",
  EntryStoneHTTK_LH = "\198\143",
  KeyStone = "\198\143",
  NiflheimTearKey = "\198\143",
  UB_BrothersScroll = "\197\138",
  UB_FatherSonScroll = "\197\138",
  WitchSkull = "\199\153",
  WitchRightHand = "\199\153",
  WitchLeftHand = "\199\153",
  EnchantersRing = "\197\129",
  AndvarisHammer = "\197\130",
  StrengthBoatLoot = "\197\142",
  RunicBoatLoot = "\197\142",
  DefenseBoatLoot = "\197\142",
  ResistanceBoatLoot = "\197\142",
  FocusBoatLoot = "\197\142",
  LuckBoatLoot = "\197\142",
  HuldraRunicBonus = "I",
  Blades_SkillTree_AttributeNode_Strength = "\197\142",
  Blades_SkillTree_AttributeNode_Luck = "\197\142",
  Blades_SkillTree_AttributeNode_Runic = "\197\142",
  MspArenaKey01 = "H",
  MspArenaKey02 = "H",
  MspArenaKey03 = "H",
  MspArenaKey04 = "H",
  MspArenaKey05 = "H",
  Rune = {
    B_Oval = {
      Pristine = "\198\168",
      Cracked = "\198\173",
      Chipped = "\198\178",
      Rough = "\198\183"
    },
    B_Square = {
      Pristine = "\198\169",
      Cracked = "\198\174",
      Chipped = "\198\179",
      Rough = "\198\184"
    },
    B_Shard = {
      Pristine = "\198\170",
      Cracked = "\198\175",
      Chipped = "\198\180",
      Rough = "\198\185"
    },
    B_Triangle = {
      Pristine = "\198\171",
      Cracked = "\198\176",
      Chipped = "\198\181",
      Rough = "\198\186"
    },
    B_Diamond = {
      Pristine = "\198\172",
      Cracked = "\198\177",
      Chipped = "\198\182",
      Rough = "\198\187"
    },
    C_Oval = {
      Pristine = "\197\143",
      Cracked = "\197\144",
      Chipped = "\197\145",
      Rough = "\197\146"
    },
    C_Square = {
      Pristine = "\197\147",
      Cracked = "\197\148",
      Chipped = "\197\149",
      Rough = "\197\150"
    },
    C_Shard = {
      Pristine = "\197\151",
      Cracked = "\197\152",
      Chipped = "\197\153",
      Rough = "\197\154"
    },
    C_Triangle = {
      Pristine = "\197\155",
      Cracked = "\197\156",
      Chipped = "\197\157",
      Rough = "\197\158"
    },
    C_Diamond = {
      Pristine = "\197\159",
      Cracked = "\197\160",
      Chipped = "\197\161",
      Rough = "\197\162"
    },
    M_Oval = {
      Pristine = "\198\188",
      Cracked = "\199\129",
      Chipped = "\199\134",
      Rough = "\199\139"
    },
    M_Square = {
      Pristine = "\198\189",
      Cracked = "\199\130",
      Chipped = "\199\135",
      Rough = "\199\140"
    },
    M_Shard = {
      Pristine = "\198\190",
      Cracked = "\199\131",
      Chipped = "\199\136",
      Rough = "\199\141"
    },
    M_Triangle = {
      Pristine = "\198\191",
      Cracked = "\199\132",
      Chipped = "\199\137",
      Rough = "\199\142"
    },
    M_Diamond = {
      Pristine = "\199\128",
      Cracked = "\199\133",
      Chipped = "\199\138",
      Rough = "\199\143"
    },
    S_Oval = {
      Pristine = "\199\180",
      Cracked = "\199\185",
      Chipped = "\199\190",
      Rough = "\200\131"
    },
    S_Square = {
      Pristine = "\199\181",
      Cracked = "\199\186",
      Chipped = "\199\191",
      Rough = "\200\132"
    },
    S_Shard = {
      Pristine = "\199\182",
      Cracked = "\199\187",
      Chipped = "\200\128",
      Rough = "\200\133"
    },
    S_Triangle = {
      Pristine = "\199\183",
      Cracked = "\199\188",
      Chipped = "\200\129",
      Rough = "\200\134"
    },
    S_Diamond = {
      Pristine = "\199\184",
      Cracked = "\199\189",
      Chipped = "\200\130",
      Rough = "\200\135"
    },
    X_Oval = {
      Pristine = "\199\159",
      Cracked = "\199\164",
      Chipped = "\199\170",
      Rough = "\199\175"
    },
    X_Square = {
      Pristine = "\199\160",
      Cracked = "\199\165",
      Chipped = "\199\171",
      Rough = "\199\176"
    },
    X_Shard = {
      Pristine = "\199\161",
      Cracked = "\199\167",
      Chipped = "\199\172",
      Rough = "\199\177"
    },
    X_Triangle = {
      Pristine = "\199\162",
      Cracked = "\199\168",
      Chipped = "\199\173",
      Rough = "\199\178"
    },
    X_Diamond = {
      Pristine = "\199\163",
      Cracked = "\199\169",
      Chipped = "\199\174",
      Rough = "\199\179"
    },
    Crystal1 = {
      Pristine = "\197\163",
      Cracked = "\197\164",
      Chipped = "\197\165",
      Rough = "\197\166"
    },
    Crystal2 = {
      Pristine = "\197\167",
      Cracked = "\197\168",
      Chipped = "\197\169",
      Rough = "\197\170"
    },
    Brooch1 = {
      Pristine = "\197\175",
      Cracked = "\197\176",
      Chipped = "",
      Rough = ""
    },
    Brooch2 = {
      Pristine = "\197\177",
      Cracked = "\197\178",
      Chipped = "",
      Rough = ""
    },
    Brooch3 = {
      Pristine = "\197\179",
      Cracked = "\197\180",
      Chipped = "",
      Rough = ""
    },
    Realm1 = {
      Pristine = "\197\171",
      Cracked = "",
      Chipped = "",
      Rough = ""
    },
    Realm2 = {
      Pristine = "\197\172",
      Cracked = "",
      Chipped = "",
      Rough = ""
    },
    Realm3 = {
      Pristine = "\197\173",
      Cracked = "",
      Chipped = "",
      Rough = ""
    },
    Realm4 = {
      Pristine = "\197\174",
      Cracked = "",
      Chipped = "",
      Rough = ""
    },
    Jewelry1 = {
      Pristine = "\197\181",
      Cracked = "\197\182",
      Chipped = "",
      Rough = ""
    },
    Jewelry2 = {
      Pristine = "\197\183",
      Cracked = "\197\184",
      Chipped = "",
      Rough = ""
    },
    Jewelry3 = {
      Pristine = "\197\185",
      Cracked = "\197\186",
      Chipped = "",
      Rough = ""
    },
    Jewelry4 = {
      Pristine = "\197\187",
      Cracked = "\197\188",
      Chipped = "",
      Rough = ""
    },
    Jewelry5 = {
      Pristine = "\197\189",
      Cracked = "\197\190",
      Chipped = "",
      Rough = ""
    },
    Jewelry6 = {
      Pristine = "\197\191",
      Cracked = "\198\128",
      Chipped = "",
      Rough = ""
    },
    Jewelry7 = {
      Pristine = "\198\129",
      Cracked = "\198\130",
      Chipped = "",
      Rough = ""
    },
    Relic1 = {
      Pristine = "\198\141",
      Cracked = "\198\142",
      Chipped = "",
      Rough = ""
    },
    Relic2 = {
      Pristine = "\198\131",
      Cracked = "\198\132",
      Chipped = "",
      Rough = ""
    },
    Relic3 = {
      Pristine = "\198\133",
      Cracked = "\198\134",
      Chipped = "",
      Rough = ""
    },
    Relic4 = {
      Pristine = "\198\135",
      Cracked = "\198\136",
      Chipped = "",
      Rough = ""
    },
    Relic5 = {
      Pristine = "\198\137",
      Cracked = "\198\138",
      Chipped = "",
      Rough = ""
    },
    Relic6 = {
      Pristine = "\198\139",
      Cracked = "\198\140",
      Chipped = "",
      Rough = ""
    }
  }
}
function iconChars.GetIcon(index)
  if util.IsStringNilOrEmpty(index) then
    return nil
  else
    local suffix = string.sub(index, -4)
    if suffix == "_NGP" then
      local beforeSuffix = string.len(index) - 4
      index = string.sub(index, 1, beforeSuffix)
    end
    if iconChars[index] ~= nil then
      return iconChars[index]
    else
      print("WARNING: Icon not found for " .. index)
    end
  end
end
return iconChars
