local questConsts = {}
questConsts.QUEST_STATE_INACTIVE = "Inactive"
questConsts.QUEST_STATE_ACTIVATE = "Activate"
questConsts.QUEST_STATE_ACTIVE = "Active"
questConsts.QUEST_STATE_INCREMENT = "Increment"
questConsts.QUEST_STATE_COMPLETE = "Complete"
questConsts.QUEST_STATE_FAIL = "Fail"
questConsts.TRACKING_STATE_NONE = "None"
questConsts.TRACKING_STATE_NOT_TRACKED = "NotTracked"
questConsts.TRACKING_STATE_TRACKED = "Tracked"
questConsts.TRACKING_STATE_FULLY_COMPLETE = "FullyComplete"
questConsts.QUEST_MESSAGE_TYPE_DEFAULT = 0
questConsts.QUEST_MESSAGE_TYPE_COMPLETE_SPECIAL = 1
questConsts.QUEST_MESSAGE_TYPE_START_SPECIAL = 2
questConsts.QUEST_FLAG_MAIN_QUEST = "MainQuest"
questConsts.QUEST_FLAG_SIDE_QUEST_HULDRA = "SideQuest_BrokSindri"
questConsts.QUEST_FLAG_SIDE_QUEST = "SideQuest"
questConsts.QUEST_FLAG_UNFINISHED_BUSINESS = "UnfinishedBusiness"
questConsts.QUEST_FLAG_ARTIFACTS = "Artifacts"
questConsts.QUEST_FLAG_SON_LANGUAGE = "SonLanguage"
questConsts.QUEST_FLAG_LABOR = "Labor"
questConsts.QUEST_FLAG_TREASURE_MAP = "TreasureMap"
questConsts.QUEST_FLAG_DRAGON = "Dragon"
questConsts.QUEST_FLAG_VALKYRIE = "Valkyrie"
questConsts.QUEST_FLAG_MUSPELHEIM = "Muspelheim"
questConsts.QUEST_FLAG_LABOR_WORLD = "Labor_World"
questConsts.QUEST_FLAG_LABOR_CRAFT = "Labor_Craft"
questConsts.QUEST_FLAG_LABOR_SKILL = "Labor_Skill"
questConsts.QUEST_FLAG_LABOR_KILL = "Labor_Kill"
questConsts.QUEST_CATEGORY_MAIN = 1
questConsts.QUEST_CATEGORY_SIDE = 2
questConsts.QUEST_CATEGORY_COMPLETE = 3
questConsts.QUEST_CATEGORY_ARTIFACTS = 4
questConsts.QUEST_CATEGORY_LABORS = 5
questConsts.QUEST_CATEGORY_TREASURE_MAPS = 6
questConsts.QUEST_CATEGORIES = {
  questConsts.QUEST_CATEGORY_MAIN,
  questConsts.QUEST_CATEGORY_SIDE,
  questConsts.QUEST_CATEGORY_COMPLETE,
  questConsts.QUEST_CATEGORY_ARTIFACTS,
  questConsts.QUEST_CATEGORY_LABORS,
  questConsts.QUEST_CATEGORY_TREASURE_MAPS
}
questConsts.QUEST_CATEGORY_SUB_STATES = {
  [questConsts.QUEST_CATEGORY_MAIN] = "MainQuests",
  [questConsts.QUEST_CATEGORY_SIDE] = "SideQuests",
  [questConsts.QUEST_CATEGORY_ARTIFACTS] = "Artifacts",
  [questConsts.QUEST_CATEGORY_LABORS] = "Labors",
  [questConsts.QUEST_CATEGORY_TREASURE_MAPS] = "TreasureMaps"
}
questConsts.QUEST_FLAGS = {
  questConsts.QUEST_FLAG_MAIN_QUEST,
  questConsts.QUEST_FLAG_VALKYRIE,
  questConsts.QUEST_FLAG_SIDE_QUEST_HULDRA,
  questConsts.QUEST_FLAG_SIDE_QUEST,
  questConsts.QUEST_FLAG_UNFINISHED_BUSINESS,
  questConsts.QUEST_FLAG_MUSPELHEIM,
  questConsts.QUEST_FLAG_ARTIFACTS,
  questConsts.QUEST_FLAG_SON_LANGUAGE,
  questConsts.QUEST_FLAG_LABOR,
  questConsts.QUEST_FLAG_TREASURE_MAP,
  questConsts.QUEST_FLAG_DRAGON
}
questConsts.TRACKABLE_SIDE_QUEST_FLAGS = {
  questConsts.QUEST_FLAG_SIDE_QUEST_HULDRA,
  questConsts.QUEST_FLAG_SIDE_QUEST,
  questConsts.QUEST_FLAG_UNFINISHED_BUSINESS,
  questConsts.QUEST_FLAG_DRAGON
}
questConsts.QUEST_INCLUDE_FLAGS = {
  [questConsts.QUEST_CATEGORY_MAIN] = {
    questConsts.QUEST_FLAG_MAIN_QUEST
  },
  [questConsts.QUEST_CATEGORY_SIDE] = {
    questConsts.QUEST_FLAG_VALKYRIE,
    questConsts.QUEST_FLAG_SIDE_QUEST_HULDRA,
    questConsts.QUEST_FLAG_SIDE_QUEST,
    questConsts.QUEST_FLAG_UNFINISHED_BUSINESS,
    questConsts.QUEST_FLAG_SON_LANGUAGE,
    questConsts.QUEST_FLAG_DRAGON,
    questConsts.QUEST_FLAG_MUSPELHEIM
  },
  [questConsts.QUEST_CATEGORY_ARTIFACTS] = {
    questConsts.QUEST_FLAG_ARTIFACTS
  },
  [questConsts.QUEST_CATEGORY_LABORS] = {
    questConsts.QUEST_FLAG_LABOR_WORLD,
    questConsts.QUEST_FLAG_LABOR_CRAFT,
    questConsts.QUEST_FLAG_LABOR_SKILL,
    questConsts.QUEST_FLAG_LABOR_KILL
  },
  [questConsts.QUEST_CATEGORY_TREASURE_MAPS] = {
    questConsts.QUEST_FLAG_TREASURE_MAP
  },
  [questConsts.QUEST_CATEGORY_COMPLETE] = {
    questConsts.QUEST_FLAG_MAIN_QUEST,
    questConsts.QUEST_FLAG_SIDE_QUEST,
    questConsts.QUEST_FLAG_UNFINISHED_BUSINESS,
    questConsts.QUEST_FLAG_MUSPELHEIM,
    questConsts.QUEST_FLAG_SIDE_QUEST_HULDRA
  }
}
questConsts.QUEST_INCLUDE_STATES = {
  [questConsts.QUEST_CATEGORY_MAIN] = {
    questConsts.QUEST_STATE_ACTIVE
  },
  [questConsts.QUEST_CATEGORY_SIDE] = {
    questConsts.QUEST_STATE_ACTIVE,
    questConsts.QUEST_STATE_COMPLETE
  },
  [questConsts.QUEST_CATEGORY_ARTIFACTS] = {
    questConsts.QUEST_STATE_ACTIVE,
    questConsts.QUEST_STATE_INACTIVE
  },
  [questConsts.QUEST_CATEGORY_LABORS] = {
    questConsts.QUEST_STATE_ACTIVE,
    questConsts.QUEST_STATE_INACTIVE
  },
  [questConsts.QUEST_CATEGORY_TREASURE_MAPS] = {
    questConsts.QUEST_STATE_ACTIVE,
    questConsts.QUEST_STATE_INACTIVE
  },
  [questConsts.QUEST_CATEGORY_COMPLETE] = {
    questConsts.QUEST_STATE_COMPLETE
  }
}
questConsts.QUEST_SKIP_CATEGORY_HEADER = {
  [questConsts.QUEST_FLAG_TREASURE_MAP] = true,
  [questConsts.QUEST_FLAG_ARTIFACTS] = true
}
return questConsts
