local reticleConsts = {}
reticleConsts.RS_INVALID = -1
reticleConsts.RS_OFF = 0
reticleConsts.RS_ON_NO_AIM = 1
reticleConsts.RS_AIMING = 2
reticleConsts.RS_IN_RANGE = 3
reticleConsts.RS_HAS_TARGET = 4
reticleConsts.RS_UNAVAILABLE = 5
reticleConsts.RS_LOCKED_ON = 6
reticleConsts.RS_PRECISION = 7
reticleConsts.RS_LOB_TOSS = 8
reticleConsts.GS_NON_COMBAT = 0
reticleConsts.GS_COMBAT = 1
reticleConsts.GS_RAGE = 2
reticleConsts.GS_MINIGAME = 3
reticleConsts.STATES = {
  NONE = "None",
  CREATURE = "Creature",
  LIGHT_ARROW = "LIGHT_ARROW",
  ELECTRIC_ARROW = "ELECTRIC_ARROW",
  BLADES = "BLADES",
  AXE = "AXE"
}
reticleConsts.RETICLE_OUTER = "ret_outer"
reticleConsts.RETICLE_MIDDLE = "ret_middle"
reticleConsts.RETICLE_INNER = "ret_inner"
reticleConsts.RETICLE_MATERIALS = {
  [reticleConsts.RETICLE_OUTER] = "ret_mechanic_diamond",
  [reticleConsts.RETICLE_MIDDLE] = "ret_mechanic_diamond",
  [reticleConsts.RETICLE_INNER] = "ret_mechanic_diamond"
}
reticleConsts.COLOR_INDICES = {
  [reticleConsts.RETICLE_OUTER] = 1,
  [reticleConsts.RETICLE_MIDDLE] = 2,
  [reticleConsts.RETICLE_INNER] = 1
}
reticleConsts.RETICLE_TINTS = {
  [reticleConsts.STATES.NONE] = {
    {
      1,
      1,
      1
    },
    {
      1,
      1,
      1
    }
  },
  [reticleConsts.STATES.CREATURE] = {
    {
      1,
      0,
      0
    },
    {
      1,
      0,
      0
    }
  },
  [reticleConsts.STATES.LIGHT_ARROW] = {
    {
      0.55,
      0.71,
      1
    },
    {
      0.55,
      0.71,
      1
    }
  },
  [reticleConsts.STATES.ELECTRIC_ARROW] = {
    {
      1,
      0.91,
      0.2
    },
    {
      1,
      0.91,
      0.2
    }
  },
  [reticleConsts.STATES.BLADES] = {
    {
      1,
      0.45,
      0.24
    },
    {
      1,
      0.45,
      0.24
    }
  },
  [reticleConsts.STATES.AXE] = {
    {
      1,
      1,
      1
    },
    {
      1,
      1,
      1
    }
  }
}
reticleConsts.BACKDROP = "ret_backdrop"
reticleConsts.ALL_RETICLES = {
  "ret_on_no_aim",
  "ret_aim",
  "ret_something_in_range",
  "ret_enemy_in_range",
  "ret_notAvailable",
  "ret_lockOn",
  "ret_enemy_in_range_precision",
  "ret_aim_rage",
  "ret_hitValid_rage",
  "ret_aim_minigame_default",
  "ret_hitValid_minigame_default",
  "ret_aim_minigame_hold_breath",
  "ret_hitValid_minigame_hold_breath",
  reticleConsts.RETICLE_OUTER,
  reticleConsts.RETICLE_MIDDLE,
  reticleConsts.RETICLE_INNER,
  reticleConsts.BACKDROP
}
local defaultAimReticles = {
  [reticleConsts.RS_ON_NO_AIM] = {
    "ret_on_no_aim"
  },
  [reticleConsts.RS_AIMING] = {
    reticleConsts.RETICLE_INNER
  },
  [reticleConsts.RS_IN_RANGE] = {
    reticleConsts.RETICLE_INNER,
    reticleConsts.RETICLE_MIDDLE
  },
  [reticleConsts.RS_HAS_TARGET] = {
    reticleConsts.RETICLE_INNER,
    reticleConsts.RETICLE_MIDDLE
  },
  [reticleConsts.RS_UNAVAILABLE] = {
    "ret_notAvailable"
  },
  [reticleConsts.RS_LOCKED_ON] = {"ret_lockOn"},
  [reticleConsts.RS_PRECISION] = {
    "ret_enemy_in_range_precision"
  }
}
local rageAimReticles = {
  [reticleConsts.RS_ON_NO_AIM] = {
    "ret_aim_rage"
  },
  [reticleConsts.RS_AIMING] = {
    "ret_aim_rage"
  },
  [reticleConsts.RS_IN_RANGE] = {
    "ret_aim_rage"
  },
  [reticleConsts.RS_HAS_TARGET] = {
    "ret_hitValid_rage"
  },
  [reticleConsts.RS_UNAVAILABLE] = {
    "ret_aim_rage"
  },
  [reticleConsts.RS_LOCKED_ON] = {
    "ret_aim_rage"
  }
}
local minigameAimReticles = {
  [reticleConsts.RS_ON_NO_AIM] = {
    "ret_aim_minigame_hold_breath"
  },
  [reticleConsts.RS_AIMING] = {
    "ret_aim_minigame_hold_breath"
  },
  [reticleConsts.RS_IN_RANGE] = {
    "ret_aim_minigame_hold_breath"
  },
  [reticleConsts.RS_HAS_TARGET] = {
    "ret_hitValid_minigame_hold_breath"
  },
  [reticleConsts.RS_UNAVAILABLE] = {
    "ret_aim_minigame_hold_breath"
  },
  [reticleConsts.RS_LOCKED_ON] = {
    "ret_aim_minigame_hold_breath"
  }
}
reticleConsts.aimingReticles = {
  [reticleConsts.GS_NON_COMBAT] = defaultAimReticles,
  [reticleConsts.GS_COMBAT] = defaultAimReticles,
  [reticleConsts.GS_RAGE] = rageAimReticles,
  [reticleConsts.GS_MINIGAME] = minigameAimReticles
}
reticleConsts.notAimingReticles = {
  [reticleConsts.GS_NON_COMBAT] = nil,
  [reticleConsts.GS_COMBAT] = nil,
  [reticleConsts.GS_RAGE] = {
    "ret_aim_rage"
  },
  [reticleConsts.GS_MINIGAME] = {
    "ret_aim_minigame_default"
  }
}
reticleConsts.alwaysOnReticles = {
  [reticleConsts.GS_NON_COMBAT] = {
    "ret_on_no_aim"
  },
  [reticleConsts.GS_COMBAT] = {
    "ret_on_no_aim"
  },
  [reticleConsts.GS_RAGE] = {
    "ret_aim_rage"
  },
  [reticleConsts.GS_MINIGAME] = {
    "ret_aim_minigame_default"
  }
}
reticleConsts.stateNames = {
  [reticleConsts.RS_OFF] = "RS_OFF",
  [reticleConsts.RS_ON_NO_AIM] = "RS_ON_NO_AIM",
  [reticleConsts.RS_AIMING] = "RS_AIMING",
  [reticleConsts.RS_IN_RANGE] = "RS_IN_RANGE",
  [reticleConsts.RS_HAS_TARGET] = "RS_HAS_TARGET",
  [reticleConsts.RS_UNAVAILABLE] = "RS_UNAVAILABLE",
  [reticleConsts.RS_LOCKED_ON] = "RS_LOCKED_ON",
  [reticleConsts.RS_PRECISION] = "RS_PRECISION"
}
return reticleConsts
