local colors = require("ui.colors")
local lamsConsts = require("ui.lamsConsts")
local pickupConsts = require("ui.pickupConsts")
local resourceConsts = require("ui.resourceConsts")
local skillTreeConsts = {}
skillTreeConsts.MAX_NODE_COUNT = 1
skillTreeConsts.MAX_SUB_NODE_COUNT = 5
skillTreeConsts.MAX_LEVEL_COUNT = 4
skillTreeConsts.MAX_SKILL_CONSUMABLE_REQUIREMENTS_COUNT = 1
skillTreeConsts.MAX_GEM_LEVEL_COUNT = 3
skillTreeConsts.MAX_GEM_REQUIREMENTS_COUNT = 1
skillTreeConsts.SkillTrees = {
  pickupConsts.Axe,
  pickupConsts.Shield,
  pickupConsts.Blades,
  pickupConsts.SonBow
}
skillTreeConsts.SpecializationBranches = {
  "Melee",
  "Bare",
  "Throw"
}
skillTreeConsts.TweaksFlags = {
  [pickupConsts.Axe] = "Axe",
  [pickupConsts.Blades] = "Blades",
  [pickupConsts.SonBow] = "Son"
}
skillTreeConsts.LockedResourceFlags = {
  [resourceConsts.RESOURCE_FLAG_SKILL_ARROW_LIGHT] = {
    "ArrowUnlock_Light"
  },
  [resourceConsts.RESOURCE_FLAG_SKILL_ARROW_ELECTRIC] = {
    "ArrowUnlock_Shock"
  }
}
skillTreeConsts.Skills = {
  [pickupConsts.Axe] = {
    "Axe_Tier01_Melee_Node01",
    "Axe_Tier01_Melee_Node01_SubNode01",
    "Axe_Tier01_Melee_Node01_SubNode02",
    "Axe_Tier01_Melee_Node01_SubNode03",
    "Axe_Tier01_Melee_Node01_SubNode04",
    "Axe_Tier01_Throw_Node01",
    "Axe_Tier01_Throw_Node01_SubNode01",
    "Axe_Tier01_Throw_Node01_SubNode02",
    "Axe_Tier01_Throw_Node01_SubNode03",
    "Axe_Tier01_Throw_Node01_SubNode04",
    "Axe_Tier01_Throw_Node01_SubNode05",
    "Axe_Tier02_Melee_Node01",
    "Axe_Tier02_Melee_Node01_SubNode01",
    "Axe_Tier01_Momentum_Unlock_01",
    "Axe_Tier01_Momentum_Unlock_02",
    "Axe_Tier01_Throw_PaintTargetUpgrade",
    "Axe_Tier01_Throw_PaintTargetUpgrade_02",
    "Axe_Tier01_Throw_CriticalThrowUpgrade",
    "Axe_Tier02_AxeDelayComboUpgrade_Heavy",
    "Axe_Tier02_AxeDelayComboUpgrade_02",
    "Axe_Tier02_AxeDelayComboUpgrade",
    "Axe_Tier01_AxeEvadeAttack_Light_Back",
    "Axe_Tier01_AxeEvadeAttack_Light"
  },
  [pickupConsts.Shield] = {
    "Axe_Tier01_Bare_Node01",
    "Axe_Tier01_Bare_Node01_SubNode01",
    "Axe_Tier01_Bare_Node01_SubNode02",
    "Axe_Tier01_Bare_Node01_SubNode03",
    "Axe_Tier02_Bare_Node01",
    "Axe_Tier02_Bare_Node01_SubNode01",
    "Axe_Tier01_BlockBreak",
    "Axe_Tier01_ParryAttack_Light",
    "Axe_Tier01_ParryAttack_Heavy",
    "Axe_Tier01_ParryProjectile",
    "Axe_Tier01_BareHeavyHold_Upgrade",
    "Axe_RageMode_Upgrade_R1_Base",
    "Axe_RageMode_Upgrade_L1_Base",
    "Axe_RageMode_Upgrade_R1Hold",
    "Axe_RageMode_Upgrade_R2",
    "Axe_RageMode_Upgrade_R2Hold",
    "Axe_Tier01_BareEvadeAttack_Light",
    "Blades_RageMode_Upgrade_R1Mash",
    "Blades_RageMode_Upgrade_L1",
    "Blades_RageMode_Upgrade_L2"
  },
  [pickupConsts.Blades] = {
    "Blades_Tier01_Melee_Node01",
    "Blades_Tier01_Melee_Node01_SubNode01",
    "Blades_Tier01_Melee_Node01_SubNode02",
    "Blades_Tier01_Melee_Node01_SubNode03",
    "Blades_Tier01_Melee_Node01_SubNode04",
    "Blades_Tier01_Bare_Node01",
    "Blades_Tier01_Bare_Node01_SubNode01",
    "Blades_Tier02_Melee_Node01",
    "Blades_Tier02_Melee_Node01_SubNode01",
    "Blades_Blade_Toss_Upgrade",
    "Blades_Momentum_01",
    "Blades_Momentum_02",
    "Blades_StatUpgrade_Luck",
    "Blades_StatUpgrade_Strength",
    "Blades_StatUpgrade_Runic",
    "Blades_Tier01_Melee_Evade_Back",
    "Blades_Tier01_Melee_Evade_Forward",
    "Blades_Tier01_Toss_Light_Upgrade",
    "Blades_Tier02_Melee_Delay_Light_Upgrade_01",
    "Blades_Tier02_Melee_Delay_HeavyBomb",
    "Blades_Toss_Light_Unlock",
    "Blades_ElementalPrecision_Level03",
    "Blades_TossSurge_Lvl02"
  },
  [pickupConsts.SonBow] = {
    "Recipe_SonPerk_LightArrow_ExplosionRadius",
    "Recipe_SonPerk_LightArrow_WeakenDefense",
    "Recipe_SonPerk_LightArrow_ExplosionSpread",
    "Recipe_SonPerk_LightArrow_Potency_Tier01",
    "Recipe_SonPerk_LightArrow_Potency_Tier02",
    "Recipe_SonPerk_LightArrow_Potency_Tier03",
    "Recipe_SonPerk_ShockArrow_SparkRate",
    "Recipe_SonPerk_ShockArrow_DetonationConduit",
    "Recipe_SonPerk_ShockArrow_OnHitSpark",
    "Recipe_SonPerk_ShockArrow_Potency_Tier01",
    "Recipe_SonPerk_ShockArrow_Potency_Tier02",
    "Recipe_SonPerk_ShockArrow_Potency_Tier03",
    "Recipe_Bow_Skill_ArrowDamage_Tier01",
    "Recipe_Bow_Skill_ArrowDamage_Tier02",
    "Recipe_Bow_Skill_ArrowDamage_Tier03",
    "Recipe_Bow_Skill_Deftness_Tier01",
    "Recipe_Bow_Skill_Deftness_Tier02",
    "Recipe_Bow_Skill_Deftness_Tier03",
    "Recipe_SonPerk_CloseCombat",
    "Recipe_SonPerk_LockDownTarget",
    "Recipe_SonPerk_FollowUp"
  }
}
skillTreeConsts.BranchGONames = {
  Branch_Axe_Tier01_Throw_Node01 = "Axe_Tier01_Throw_Node01",
  Branch_Axe_Tier02_AxeDelayComboUpgrade_02 = "Axe_Tier02_AxeDelayComboUpgrade_02",
  Branch_Axe_Tier01_Throw_CriticalThrowUpgrade = "Axe_Tier01_Throw_CriticalThrowUpgrade",
  Branch_Axe_Tier01_Throw_PaintTargetUpgrade = "Axe_Tier01_Throw_PaintTargetUpgrade",
  Branch_Axe_Tier01_Throw_PaintTargetUpgrade_02 = "Axe_Tier01_Throw_PaintTargetUpgrade_02",
  Branch_Axe_Tier02_AxeDelayComboUpgrade_Heavy = "Axe_Tier02_AxeDelayComboUpgrade_Heavy",
  Branch_Axe_Tier01_Momentum_Unlock_02 = "Axe_Tier01_Momentum_Unlock_02",
  Branch_Axe_Tier02_AxeDelayComboUpgrade = "Axe_Tier02_AxeDelayComboUpgrade",
  Branch_Axe_Tier02_Melee_Node01_SubNode01 = "Axe_Tier02_Melee_Node01_SubNode01",
  Branch_Axe_Tier01_ParryAttack_Light = "Axe_Tier01_ParryAttack_Light",
  Branch_Axe_Tier01_ParryAttack_Heavy = "Axe_Tier01_ParryAttack_Heavy",
  Branch_Axe_Tier01_BareHeavyHold_Upgrade = "Axe_Tier01_BareHeavyHold_Upgrade",
  Branch_Axe_Tier02_Bare_Node01_SubNode01 = "Axe_Tier02_Bare_Node01_SubNode01",
  Branch_Axe_RageMode_Upgrade_R1Hold = "Axe_RageMode_Upgrade_R1Hold",
  Branch_Blades_RageMode_Upgrade_L1 = "Blades_RageMode_Upgrade_L1",
  Branch_Blades_RageMode_Upgrade_R1Mash = "Blades_RageMode_Upgrade_R1Mash",
  Branch_Axe_RageMode_Upgrade_R2Hold = "Axe_RageMode_Upgrade_R2Hold",
  Branch_Blades_RageMode_Upgrade_L2 = "Blades_RageMode_Upgrade_L2",
  Branch_Blades_Tier02_Melee_Delay_HeavyBomb = "Blades_Tier02_Melee_Delay_HeavyBomb",
  Branch_Blades_Tier01_Toss_Light_Upgrade = "Blades_Tier01_Toss_Light_Upgrade",
  Branch_Blades_TossSurge_Lvl02 = "Blades_TossSurge_Lvl02",
  Branch_Blades_Momentum_02 = "Blades_Momentum_02",
  Branch_Blades_ElementalPrecision_Level03 = "Blades_ElementalPrecision_Level03",
  Branch_Blades_Tier01_Bare_Node01_SubNode01 = "Blades_Tier01_Bare_Node01_SubNode01",
  Branch_Blades_Tier02_Melee_Node01_SubNode01 = "Blades_Tier02_Melee_Node01_SubNode01",
  Branch_Blades_Tier02_Melee_Delay_Light_Upgrade_01 = "Blades_Tier02_Melee_Delay_Light_Upgrade_01",
  Branch_Recipe_SonPerk_LightArrow_Potency_Tier02 = "Recipe_SonPerk_LightArrow_Potency_Tier02",
  Branch_Recipe_SonPerk_LightArrow_Potency_Tier03 = "Recipe_SonPerk_LightArrow_Potency_Tier03",
  Branch_Recipe_SonPerk_ShockArrow_Potency_Tier02 = "Recipe_SonPerk_ShockArrow_Potency_Tier02",
  Branch_Recipe_SonPerk_ShockArrow_Potency_Tier03 = "Recipe_SonPerk_ShockArrow_Potency_Tier03",
  Branch_Recipe_Bow_Skill_ArrowDamage_Tier02 = "Recipe_Bow_Skill_ArrowDamage_Tier02",
  Branch_Recipe_Bow_Skill_ArrowDamage_Tier03 = "Recipe_Bow_Skill_ArrowDamage_Tier03",
  Branch_Recipe_Bow_Skill_Deftness_Tier02 = "Recipe_Bow_Skill_Deftness_Tier02",
  Branch_Recipe_Bow_Skill_Deftness_Tier03 = "Recipe_Bow_Skill_Deftness_Tier03",
  Branch_Recipe_SonPerk_LightArrow_ExplosionSpread = "Recipe_SonPerk_LightArrow_ExplosionSpread",
  Branch_Recipe_SonPerk_LightArrow_ExplosionRadius = "Recipe_SonPerk_LightArrow_ExplosionRadius",
  Branch_Recipe_SonPerk_ShockArrow_DetonationCondui = "Recipe_SonPerk_ShockArrow_DetonationConduit",
  Branch_Recipe_SonPerk_ShockArrow_OnHitSpark = "Recipe_SonPerk_ShockArrow_OnHitSpark"
}
skillTreeConsts.subtreeTextTables = {
  [pickupConsts.Axe] = {
    Left = {
      Desc = lamsConsts.AxeSkillTree_1_Desc
    },
    Right = {
      Desc = lamsConsts.AxeSkillTree_2_Desc
    }
  },
  [pickupConsts.Shield] = {
    Left = {
      Desc = lamsConsts.ShieldSkillTree_1_Desc
    },
    Right = {
      Desc = lamsConsts.ShieldSkillTree_2_Desc
    }
  },
  [pickupConsts.Blades] = {
    Left = {
      Desc = lamsConsts.BladesSkillTree_1_Desc
    },
    Right = {
      Desc = lamsConsts.BladesSkillTree_2_Desc
    }
  },
  [pickupConsts.SonBow] = {
    Left = {
      Header = lamsConsts.BowSkillTree_1_Header,
      Desc = lamsConsts.BowSkillTree_1_Desc
    },
    Right = {
      Header = lamsConsts.BowSkillTree_2_Header,
      Desc = lamsConsts.BowSkillTree_2_Desc
    }
  }
}
function skillTreeConsts.subtreeTextTables_Validate(table)
  return type(table.Left) == "table" and table.Left.Desc ~= nil and type(table.Right) == "table" and table.Right.Desc ~= nil
end
skillTreeConsts.NodePurchasedStateAnimPos = {
  CantPurchase_LockedByReinforcement = {smallDiamond_State = 0, smallDiamond_Fill = 0},
  CantPurchase_NeedXP = {smallDiamond_State = 0.1, smallDiamond_Fill = 0},
  CanPurchase = {smallDiamond_State = 0.2, smallDiamond_Fill = 0},
  Purchased = {smallDiamond_State = 0.3, smallDiamond_Flourish = 1},
  OnPurchased = {smallDiamond_State = 0.3},
  OnUnlocked = {smallDiamond_Unlock = 0.3}
}
skillTreeConsts.SkillInfoCardLockedColors = colors.SkillInfoCardLockedColors
skillTreeConsts.GemAttributes = {
  [tostring(engine.Hash("Damage"))] = lamsConsts.GemAttribute1,
  [tostring(engine.Hash("Runic"))] = lamsConsts.GemAttribute2,
  [tostring(engine.Hash("Stun"))] = lamsConsts.GemAttribute3,
  [tostring(engine.Hash("Impact"))] = lamsConsts.GemAttribute4,
  [tostring(engine.Hash("Range"))] = lamsConsts.GemAttribute5,
  [tostring(engine.Hash("Frost"))] = lamsConsts.Frost,
  [tostring(engine.Hash("Burn"))] = lamsConsts.Burn
}
return skillTreeConsts
