local classlib = require("core.class")
local tablex = require("core.tablex")
local colors = require("ui.colors")
local consts = require("ui.consts")
local fsm = require("ui.fsm")
local lamsIDs = require("ui.lamsConsts")
local list = require("ui.list")
local menu = require("ui.menu")
local toggle = require("ui.toggle")
local util = require("ui.util")
local Audio = game.Audio
local UI = game.UI
local GraphicsMode = classlib.Class("GraphicsMode", fsm.UIState)
local GraphicsModeOff = GraphicsMode:StateClass("GraphicsModeOff", fsm.UIState)
local GraphicsModeOn = GraphicsMode:StateClass("GraphicsModeOn", fsm.UIState)
local graphicsMode = GraphicsMode.New("graphicsMode", {GraphicsModeOff, GraphicsModeOn})
function GraphicsMode:Enter()
  self:Goto("GraphicsModeOff")
end
function GraphicsModeOff:Setup()
end
function GraphicsModeOff:Enter()
end
function GraphicsModeOff:EVT_OPEN_GRAPHICS_MODE_FROM_BOOT()
  if game.CanRender4K ~= nil and game.CanRender4K() then
    self:Goto("GraphicsModeOn")
  else
    UI.SendEvent("*", consts.EVT_FINISH_GRAPHICS_MODE_BOOT)
  end
end
function GraphicsModeOn:Setup()
  self.goGraphicsModeScreen = util.GetUiObjByName("graphicsModeScreen")
  self.goGraphicsToolTip = util.GetUiObjByName("GraphicsToolTip")
  self.thButtonPrompts = util.GetTextHandle(self.goGraphicsModeScreen, "ButtonPrompts")
  self.thToolTips = util.GetTextHandle(self.goGraphicsToolTip)
  self.menu = menu.Menu.New(self, {})
  local generalList = list.List.New(self, {
    MaxFocusableObjectCount = 3,
    ListObjectName = "graphicsModeList",
    EmptyTextLamsID = lamsIDs.NoSettingsAvailable,
    PreviousEvents = {
      "EVT_Up_Press"
    },
    NextEvents = {
      "EVT_Down_Press"
    }
  })
  generalList:SetSelectedButton(1, false)
  self.menu:SetList("GraphicsList", generalList)
  self.graphicsModeToggle = toggle.Toggle.New(self, {
    Name = "GraphicsModeToggle",
    Settings = {
      {
        Value = false,
        Text = util.GetLAMSMsg(lamsIDs.FavorPerformance)
      },
      {
        Value = true,
        Text = util.GetLAMSMsg(lamsIDs.FavorResolution)
      }
    },
    Get = function()
      if game.GetEnable4K ~= nil then
        return game.GetEnable4K()
      end
      return false
    end,
    Set = function(val)
      if game.SetEnable4K ~= nil then
        game.SetEnable4K(val)
      end
    end,
    OnToggleFunc = function(v)
      self:SetToopTip(v)
    end,
    Default = function()
      return true
    end
  })
  self.settingsInfo = {
    {
      Item = "GraphicsModeToggle",
      Text = util.GetLAMSMsg(lamsIDs.GraphicsMode),
      ActivationList = {
        {
          Item = self.graphicsModeToggle
        }
      }
    }
  }
end
function GraphicsModeOn:Enter()
  self:WantPadEvents(true)
  self.goGraphicsModeScreen:Show()
  self.goGraphicsToolTip:Show()
  UI.SendEvent("*", consts.EVT_OPENED_GRAPHICS_MODE_SCREEN)
  self.menu:Activate()
  local settingsList = self.menu:GetList("GraphicsList")
  local showList = true
  local useOnGainFocus = true
  local itemDetermineFocusabilityFunc
  local itemGetTextFunc = function(setting)
    return setting.Text
  end
  settingsList:Refresh(self.settingsInfo, showList, useOnGainFocus, itemDetermineFocusabilityFunc, itemGetTextFunc)
  settingsList:SetHeaderText(util.GetLAMSMsg(lamsIDs.GraphicsMode))
  local footer = "[AdvanceButton] " .. util.GetLAMSMsg(lamsIDs.Confirm)
  UI.SetText(self.thButtonPrompts, footer)
end
function GraphicsModeOn:Exit()
  UI.SavePrefs()
  UI.SoftSavePlayerState()
  self:WantPadEvents(false)
  self.goGraphicsModeScreen:Hide()
  self.goGraphicsToolTip:Hide()
  self.menu:Deactivate(true)
end
function GraphicsModeOn:SetToopTip(value)
  local tip = util.GetLAMSMsg(lamsIDs.FavorPerformanceDesc)
  if value then
    tip = util.GetLAMSMsg(lamsIDs.FavorResolutionDesc)
  end
  UI.SetText(self.thToolTips, tip)
end
function GraphicsModeOn:HandleExit()
  UI.SendEvent("*", consts.EVT_FINISH_GRAPHICS_MODE_BOOT)
  Audio.PlaySound("SND_UX_Menu_Tick_Confirm")
  self:Goto("GraphicsModeOff")
end
function GraphicsModeOn:EVT_Advance_Release()
  if not self.handling_event then
    self.advance = true
  end
end
function GraphicsModeOn:Update()
  if not self.handling_event and self.advance then
    self.handling_event = true
    self.advance = false
    self:HandleExit()
  end
end
