local UI = game.UI
local FindPlayer = game.Player.FindPlayer
local classlib = require("core.class")
local tablex = require("core.tablex")
local consts = require("ui.consts")
local colors = require("ui.colors")
local fsm = require("ui.fsm")
local lamsIDs = require("ui.lamsConsts")
local messageRequest = require("ui.messageRequest")
local pickupUtil = require("ui.pickupUtil")
local pickupConsts = require("ui.pickupConsts")
local queue = require("ui.queue")
local resourceConsts = require("ui.resourceConsts")
local resourceUtil = require("ui.resourceUtil")
local runeUtil = require("ui.runeUtil")
local sliderHoldFill = require("ui.sliderHoldFill")
local uiCalls = require("ui.uicalls")
local util = require("ui.util")
local meter = require("ui.meter")
local MechanicsHUD = classlib.Class("MechanicsHUD", fsm.UIState)
local mechanicsHUD = MechanicsHUD.New("mechanicsHUD", {})
function MechanicsHUD:Setup()
  self.simpleText = util.GetUiObjByName("MechanicsText")
  self.thSimpleText = util.GetTextHandle(self.simpleText, "text")
  self.simpleText:Hide()
  self.playerMeterName = nil
  self.activeMeter = meter.Meter.New(self, {
    Name = "MechanicsMeter",
    MeterObject = util.GetUiObjByName("MechanicsMeter"),
    MeterInstanceChildName = "eventMeter",
    FillAnimName = "eventMeter_Fill",
    Percent = 0,
    MarkerID = consts.OT_Player,
    OnMeterChanged = function()
      self:ActiveMeterChanged()
    end
  })
  self.activeMeter:Deactivate(true)
  self.activeMeterFillObj = util.GetUiObjByName("eventMeter")
  self.rageButtons = util.GetUiObjByName("DM_Rage_Mode")
  self.genericL3R3 = util.GetUiObjByName("R3_L3")
end
function MechanicsHUD:SetRagePrompts()
  local pad = game.Player.FindPlayer().Pad
  if pad.IsKeyboardAndMouse then
    self.rageButtons:SetMaterialSwap("key")
    if game.GetEnterRageModeOptionNumber ~= nil and game.GetEnterRageModeOptionNumber() == 1 then
      self.genericL3R3:SetMaterialSwap(game.GetKey(6))
      self.genericL3R3:SetMaterialSwap(game.GetKey(5) .. "2")
    else
      self.genericL3R3:SetMaterialSwap(game.GetKey(13))
      self.genericL3R3:SetMaterialSwap(game.GetKey(10) .. "2")
    end
  elseif pad.IsGeneric then
    self.rageButtons:SetMaterialSwap("")
    self.genericL3R3:SetMaterialSwap("")
    self.genericL3R3:SetMaterialSwap("genA")
    self.genericL3R3:SetMaterialSwap("genB2")
  else
    self.rageButtons:SetMaterialSwap("")
    self.genericL3R3:SetMaterialSwap("")
  end
end
function MechanicsHUD:Enter()
  self:EVT_DISABLE_MECHANIC()
  self:SetRagePrompts()
end
function MechanicsHUD:UpdateRageOptionButtons()
  local val = 0
  if game.GetEnterRageModeOptionNumber ~= nil then
    val = game.GetEnterRageModeOptionNumber()
  end
  UI.AnimNoShow(self.genericL3R3, consts.AS_Forward, "", 0, val)
end
function MechanicsHUD:EVT_RAGE_ACCESS_OPTIONS_CHANGED()
  self:UpdateRageOptionButtons()
  self:SetRagePrompts()
end
function MechanicsHUD:EVT_PAD_CHANGED()
  self:SetRagePrompts()
end
function MechanicsHUD:EVT_MECHANIC_METER(meterName, meterIsPurple)
  self:EVT_DISABLE_MECHANIC_METER()
  self.playerMeterName = meterName
  if meterName ~= nil then
    self.activeMeter:SetIDHash(engine.Hash(meterName))
    self.activeMeter:Activate(true)
    local animTime = 0
    if meterIsPurple then
      animTime = 0.12
      self.soundToPlayOnMeterEmpty = "SND_UX_Arena_Timer_Expired"
    end
    UI.Anim(self.activeMeterFillObj, consts.AS_Forward, "eventMeter_Color", 0, animTime)
  end
  UI.Anim(self.activeMeterFillObj, consts.AS_Forward, "eventMeter_Segments", 0, 0)
end
function MechanicsHUD:ActiveMeterChanged()
  if self.playerMeterName ~= nil then
    local player = FindPlayer()
    local playerMeterMax = player:MeterGetMax(self.playerMeterName)
    local playerMeterVal = player:MeterGetValue(self.playerMeterName)
    local prevPercent = self.activeMeter:get_percent()
    self.activeMeter:SetPercent(playerMeterVal / playerMeterMax)
    local curPercent = self.activeMeter:get_percent()
    if self.soundToPlayOnMeterEmpty ~= nil and prevPercent ~= 0 and curPercent == 0 then
      game.Audio.PlaySound(self.soundToPlayOnMeterEmpty)
    end
  end
end
function MechanicsHUD:EVT_MECHANIC_TEXT(text, formattedArgs)
  self.simpleText:Show()
  local finalText = text
  if formattedArgs ~= nil then
    if type(text) ~= "number" then
      finalText = string.format(text, unpack(formattedArgs))
    else
      finalText = util.FormatLAMSString(text, unpack(formattedArgs))
    end
  end
  UI.SetText(self.thSimpleText, finalText)
end
function MechanicsHUD:EVT_MECHANIC_RAGE(timeToDisplayFor)
  self.rageButtons:Show()
  UI.Anim(self.rageButtons, consts.AS_ForwardOscillate, "", 0.75)
  self:UpdateRageOptionButtons()
  self.genericL3R3:Show()
  if timeToDisplayFor ~= nil and 0 < timeToDisplayFor then
    self:StartTimer("RageHelper", timeToDisplayFor, function()
      self:EVT_DISABLE_MECHANIC_RAGE()
    end)
  end
end
function MechanicsHUD:EVT_DISABLE_MECHANIC_RAGE()
  self.rageButtons:Hide()
  self.genericL3R3:Hide()
end
function MechanicsHUD:EVT_MECHANIC_NONRAGE(timeToDisplayFor)
  self.genericL3R3:Show()
  self:UpdateRageOptionButtons()
  if timeToDisplayFor ~= nil and 0 < timeToDisplayFor then
    self:StartTimer("NonRageHelper", timeToDisplayFor, function()
      self:EVT_DISABLE_MECHANIC_NONRAGE()
    end)
  end
end
function MechanicsHUD:EVT_DISABLE_MECHANIC_NONRAGE()
  self.genericL3R3:Hide()
end
function MechanicsHUD:EVT_DISABLE_MECHANIC_TEXT()
  self.simpleText:Hide()
  UI.SetText(self.thSimpleText, "")
end
function MechanicsHUD:EVT_DISABLE_MECHANIC_METER()
  if self.activeMeter ~= nil then
    self.activeMeter:Deactivate(true)
    self.playerMeterName = nil
    self.soundToPlayOnMeterEmpty = nil
  end
end
function MechanicsHUD:EVT_DISABLE_MECHANIC()
  self:EVT_DISABLE_MECHANIC_METER()
  self:EVT_DISABLE_MECHANIC_TEXT()
  self:EVT_DISABLE_MECHANIC_RAGE()
  self:EVT_DISABLE_MECHANIC_NONRAGE()
end
