local fsm = require("ui.fsm")
local logManager = require("ui.logManager")
local ActivateCallback = function(sequence, args, stages)
  for _, stage in ipairs(stages) do
    assert(stage.FuncName ~= nil, "Compass sequence message does not have function name")
    assert(stage.IsMainQuest ~= nil, "Compass sequence message is missing arguments")
    local funcName = stage.FuncName
    local isMainQuest = stage.IsMainQuest
    local markerHash = stage.MarkerHash
    fsm.HandleEvent(funcName, isMainQuest, markerHash)
  end
  sequence._manager:Handle_SequenceFinished(sequence)
  return false
end
local InitSequenceArgs = {
  ParentGOName = "DummyObjectForLogs",
  InitStages = {},
  ActivateCallback = ActivateCallback
}
local CreateSequenceStages = function(args)
  local newStages = {args}
  return newStages
end
return {InitSequenceArgs = InitSequenceArgs, CreateSequenceStages = CreateSequenceStages}
