local tablex = require("core.tablex")
local consts = require("ui.consts")
local fsm = require("ui.fsm")
local questUtil = require("ui.questUtil")
local questConsts = require("ui.questConsts")
local util = require("ui.util")
local logManager = require("ui.logManager")
local Anim_SetText_ProcessCallback = function(childGO, animTable)
  local textLams = animTable.TextLams
  local txtHdl = util.GetTextHandle(childGO)
  if txtHdl ~= nil then
    game.UI.SetText(txtHdl, util.GetLAMSMsg(textLams))
  end
end
local medallionFlagToMaterials = {
  {
    Flag = "Complete_Journey",
    Material = "dragons"
  },
  {
    Flag = "Complete_Favor",
    Material = "huldra_favors"
  },
  {
    Flag = "Complete_Challenge",
    Material = "msp_challenge"
  },
  {
    Flag = "Complete_Realm",
    Material = "realm_unlock"
  },
  {
    Flag = "Complete_Spirits",
    Material = "spirits"
  },
  {
    Flag = "Complete_Treasure",
    Material = "treasure_map"
  },
  {
    Flag = "Complete_Valkyries",
    Material = "valkyries"
  }
}
local Anim_SetTextAndMaterial_ProcessCallback = function(childGO, animTable)
  Anim_SetText_ProcessCallback(childGO, animTable)
  local quest = animTable.Quest
  local materialName = ""
  if quest ~= nil then
    for _, flag2Mat in ipairs(medallionFlagToMaterials) do
      if game.QuestManager.QuestHasFlag(quest, flag2Mat.Flag) then
        materialName = flag2Mat.Material
      end
    end
  elseif animTable.Is100Complete then
    materialName = "100Complete"
  end
  childGO:SetMaterialSwap(materialName)
end
local PausedChanged = function(sequence, gamePaused, uiPaused)
  if uiPaused then
    game.UI.AlphaFade(sequence._parentGO, 0, 1)
  elseif sequence._activeStageName ~= "FadeOut" and sequence._activeStageName ~= "EarlyFadeOut" then
    game.UI.AlphaFade(sequence._parentGO, 1, 1)
  end
end
local InitSequenceArgs = {
  ParentGOName = "CelebrationLog",
  InitStages = {
    {
      StageName = "Reset",
      Timer = 0,
      Anims = {
        {
          GOPath = "log",
          FadeValue = 0,
          FadeTime = 0,
          AnimRate = 0,
          AnimStart = 0
        }
      }
    }
  },
  PausedChanged = PausedChanged
}
local CreateSequenceStages = function(args)
  local newSequenceStages = {
    {
      StageName = "SetText",
      Timer = 0,
      Anims = {
        {
          GOPath = "log",
          FadeValue = 0,
          FadeTime = 0,
          DoAnimate = false,
          Sound = "SND_UX_HUD_Quest_Complete",
          Quest = args.Quest,
          Is100Complete = args.Is100Complete,
          ProcessCallback = Anim_SetTextAndMaterial_ProcessCallback
        },
        {
          GOPath = "log|log_text_header",
          FadeValue = 0,
          FadeTime = 0,
          DoAnimate = false,
          TextLams = args.Header,
          ProcessCallback = Anim_SetText_ProcessCallback
        },
        {
          GOPath = "log|log_text_row0",
          FadeValue = 0,
          FadeTime = 0,
          DoAnimate = false,
          TextLams = args.Body,
          ProcessCallback = Anim_SetText_ProcessCallback
        }
      }
    },
    {
      StageName = "AnimIn",
      Timer = 1,
      Anims = {
        {
          GOPath = "log",
          FadeTime = 1,
          AnimEnd = 2.66667
        },
        {
          GOPath = "log|log_text_header",
          FadeTime = 1
        },
        {
          GOPath = "log|log_text_row0",
          FadeTime = 1
        },
        {
          GOPath = "log",
          DoFade = false,
          AnimStyle = consts.AS_ForwardCycle,
          AnimName = "QuestComplete_Loop",
          AnimRate = 0.25
        }
      }
    },
    {StageName = "Idle", Timer = 4},
    {
      StageName = "EarlyFadeOut",
      Timer = 0.5,
      UnlockTimer = 0,
      Anims = {
        {
          GOPath = "log|log_text_header",
          FadeValue = 0,
          FadeTime = 1,
          DoAnim = false
        },
        {
          GOPath = "log|log_text_row0",
          FadeValue = 0,
          FadeTime = 1,
          DoAnim = false
        }
      }
    },
    {
      StageName = "FadeOut",
      Timer = 1,
      Anims = {
        {
          GOPath = "log",
          DoFade = false,
          AnimName = "QuestComplete_FadeOut"
        }
      }
    }
  }
  return newSequenceStages
end
return {InitSequenceArgs = InitSequenceArgs, CreateSequenceStages = CreateSequenceStages}
