local tablex = require("core.tablex")
local consts = require("ui.consts")
local fsm = require("ui.fsm")
local questUtil = require("ui.questUtil")
local questConsts = require("ui.questConsts")
local util = require("ui.util")
local logManager = require("ui.logManager")
local Anim_SetText_ProcessCallback = function(childGO, animTable)
  local textLams = animTable.TextLams
  local txtHdl = util.GetTextHandle(childGO)
  if txtHdl ~= nil then
    game.UI.SetText(txtHdl, util.GetLAMSMsg(textLams))
  end
end
local SetCompassMarkers_StartCallback = function(stage, startCallbackArgs)
  local questID = startCallbackArgs.QuestID
  questUtil.AddMarkersToCompassFromSequence(questID)
end
local PausedChanged = function(sequence, gamePaused, uiPaused)
  if uiPaused then
    game.UI.AlphaFade(sequence._parentGO, 0, 1)
  elseif sequence._activeStageName ~= "FadeOut" and sequence._activeStageName ~= "EarlyFadeOut" then
    game.UI.AlphaFade(sequence._parentGO, 1, 1)
  end
end
local InitSequenceArgs = {
  ParentGOName = "QuestStartLog",
  InitStages = {
    {
      StageName = "Reset",
      Timer = 0,
      Anims = {
        {
          GOPath = "log",
          FadeValue = 0,
          FadeTime = 0,
          AnimRate = 0,
          AnimStart = 0
        }
      }
    }
  },
  PausedChanged = PausedChanged
}
local CreateSequenceStages = function(args)
  local newSequenceStages = {
    {
      StageName = "SetText",
      Timer = 0,
      Anims = {
        {
          GOPath = "log|log_text_header",
          FadeValue = 0,
          FadeTime = 0,
          DoAnimate = false,
          TextLams = args.Header,
          ProcessCallback = Anim_SetText_ProcessCallback
        },
        {
          GOPath = "log|log_text_row0",
          FadeValue = 0,
          FadeTime = 0,
          DoAnimate = false,
          TextLams = args.Body,
          ProcessCallback = Anim_SetText_ProcessCallback
        }
      }
    },
    {
      StageName = "AnimIn",
      Timer = 1,
      Anims = {
        {
          GOPath = "log",
          FadeTime = 1,
          AnimEnd = 1
        },
        {
          GOPath = "log|log_text_header",
          FadeTime = 1
        },
        {
          GOPath = "log|log_text_row0",
          FadeTime = 1
        }
      }
    },
    {
      StageName = "Idle",
      Timer = 5,
      StartCallback = SetCompassMarkers_StartCallback,
      StartCallbackArgs = {
        QuestID = args.Quest
      }
    },
    {
      StageName = "EarlyFadeOut",
      Timer = 0.5,
      UnlockTimer = 0,
      Anims = {
        {
          GOPath = "log|log_text_header",
          FadeValue = 0,
          FadeTime = 1,
          AnimStyle = consts.AS_Reverse,
          AnimStart = 1,
          AnimEnd = 0
        },
        {
          GOPath = "log|log_text_row0",
          FadeValue = 0,
          FadeTime = 1,
          AnimStyle = consts.AS_Reverse,
          AnimStart = 1,
          AnimEnd = 0
        }
      }
    },
    {
      StageName = "FadeOut",
      Timer = 1,
      Anims = {
        {
          GOPath = "log",
          DoFade = false,
          AnimStyle = consts.AS_Reverse,
          AnimStart = 1,
          AnimEnd = 0
        }
      }
    }
  }
  return newSequenceStages
end
return {InitSequenceArgs = InitSequenceArgs, CreateSequenceStages = CreateSequenceStages}
