local classlib = require("core.class")
local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local attributeCard = require("ui.attributeCard")
local attributeUtil = require("ui.attributeUtil")
local bestiaryUtil = require("ui.bestiaryUtil")
local buttonUtil = require("ui.buttonUtil")
local consts = require("ui.consts")
local fsm = require("ui.fsm")
local lamsConsts = require("ui.lamsConsts")
local list = require("ui.list")
local mapUtil = require("ui.mapUtil")
local menu = require("ui.menu")
local pickupConsts = require("ui.pickupConsts")
local pickupUtil = require("ui.pickupUtil")
local priorityList = require("ui.priorityList")
local questUtil = require("ui.questUtil")
local recipeUtil = require("ui.recipeUtil")
local resourceConsts = require("ui.resourceConsts")
local resourceUtil = require("ui.resourceUtil")
local skillUtil = require("ui.skillUtil")
local topNavBar = require("ui.topNavBar")
local tutorialUtil = require("ui.tutorialUtil")
local uiCalls = require("ui.uicalls")
local util = require("ui.util")
local AI = game.AI
local Audio = game.Audio
local Player = game.Player
local SetText = game.UI.SetText
local UI = game.UI
local GlobalMenu = classlib.Class("GlobalMenu", fsm.UIState)
local GlobalMenuOff = GlobalMenu:StateClass("GlobalMenuOff", fsm.UIState)
local GlobalMenuOn = GlobalMenu:StateClass("GlobalMenuOn", fsm.UIState)
local GlobalInWorldMenu = GlobalMenu:StateClass("GlobalInWorldMenu", fsm.UIState)
local GlobalSettings = GlobalMenu:StateClass("GlobalSettings", fsm.UIState)
local GlobalVendor = GlobalMenu:StateClass("GlobalVendor", fsm.UIState)
local GlobalRealmTable = GlobalMenu:StateClass("GlobalRealmTable", fsm.UIState)
local globalMenu = GlobalMenu.New("globalMenu", {
  GlobalMenuOff,
  GlobalMenuOn,
  {
    GlobalInWorldMenu,
    GlobalSettings,
    GlobalVendor,
    GlobalRealmTable
  }
})
function GlobalMenu:Setup()
  self.vendorWallet = nil
  self.bothHuldraAvailable = nil
  self.selectedRealmInfo = nil
  self.exclusiveAccessMenu = nil
  self.shellLoad = false
  self.systemMenuIsOpen = false
  self.inCinematic = false
  self.waitForRelease = false
  self.waitForTouchRelease = false
  self.selectPressed = false
  self.optionsPressed = false
  self.touchPressed = false
  self.takingPicture = false
  self.menu = menu.Menu.New(self, {})
  self.goGlobalMenu = util.GetUiObjByName("globalMenu")
  self.goRecipeNotice = util.GetUiObjByName("RecipeNotice")
  self.goHeaderLabel = util.GetUiObjByName("HeaderLabel")
  self.goInfoText = util.GetUiObjByName("GlobalInfoText")
  self.thGlobalButtonPrompts = util.GetTextHandle(self.goGlobalMenu, "GlobalButtonPrompts")
  self.thGlobalInfoText = util.GetTextHandle(self.goInfoText, "GlobalInfoText")
  self.thGlobalHeaderLabel = util.GetTextHandle(self.goHeaderLabel, "HeaderLabel")
  self.thRecipeNoticeHeader = util.GetTextHandle(self.goRecipeNotice, "NoticeHeader")
  self.thRecipeNoticeBody = util.GetTextHandle(self.goRecipeNotice, "NoticeBody")
  self.goMessageHUD = util.GetUiObjByName("messageHUD")
  self.globalMenuPosition = self.goGlobalMenu:GetWorldPosition()
  UI.SetTextIsClickable(self.thGlobalButtonPrompts)
  self.pausePriorityList = priorityList.PriorityList.New(false)
  self.pausePriorityList:AddItem("DesignerMessages")
  self.pausePriorityList:AddItem("GlobalInWorldMenu")
  self.pausePriorityList:AddItem("GlobalSettings")
  self.pausePriorityList:AddItem("GlobalVendor")
  self.pausePriorityList:AddItem("GlobalRealmTable")
  self.disablePriorityList = priorityList.PriorityList.New(false)
  self.disablePriorityList:AddItem("In Shell", function()
    if UI.GetInScreen(consts.SHELL) then
      return true
    end
    return nil
  end)
  self.disablePriorityList:AddItem("In Loading Screen", function()
    if UI.GetInScreen(consts.LOADINGSCR) then
      return true
    end
    return nil
  end)
  self.disablePriorityList:AddItem("In Dead Screen", function()
    if UI.GetInScreen(consts.DEADSCR) then
      return true
    end
    return nil
  end)
  self.disablePriorityList:AddItem("DesignerMessages")
  self.disablePriorityList:AddItem("DeadMenu")
  self.disablePriorityList:AddItem("Designer-Specified")
  self.disablePriorityList:AddItem("PhotoMode")
  self.goGlobalMenu:Hide()
  util.Hide("GlobalHeaderBacking", "XPandHS")
end
local g_XP_HS_Flourish_ignoreUpdate = false
function GlobalMenu:Enter()
  self:WantPadEvents(true)
  self.exclusiveAccessMenu = nil
  self.pausePriorityList:Clear()
  self.disablePriorityList:Clear()
  g_XP_HS_Flourish_ignoreUpdate = true
  self:Goto("GlobalMenuOff")
end
GlobalMenu.EVT_GAME_START = GlobalMenu.Enter
GlobalMenu.EVT_GAME_OVER = GlobalMenu.Enter
GlobalMenu.EVT_Restart = GlobalMenu.Enter
function GlobalMenu:Exit()
end
GlobalMenu.isPaused = false
GlobalMenu.newIsPaused = false
function GlobalMenu:AttemptPause()
  if self.pausePriorityList:GetAvailable() == false then
    self.newIsPaused = true
  end
end
function GlobalMenu:AttemptUnpause()
  if self.pausePriorityList:GetAvailable() == false then
    self.newIsPaused = false
  end
end
function GlobalMenu:CheckPauseState()
  if self.isPaused ~= self.newIsPaused then
    if self.newIsPaused then
      UI.GamePause()
    else
      UI.GameUnpause()
    end
    self.isPaused = self.newIsPaused
  end
end
function GlobalMenu:HasAccessToMenu(menuName)
  local hasAccess = false
  local currStateName = self:GetCurrentState().name
  if currStateName == menuName then
    return true
  end
  local accessTable = consts.GLOBAL_MENU_ACCESS[currStateName]
  if accessTable == nil then
    hasAccess = true
  elseif accessTable[menuName] ~= nil then
    local haveExclusiveMenu = self:HasExclusiveAccessMenu()
    if not haveExclusiveMenu or haveExclusiveMenu and self.exclusiveAccessMenu == menuName then
      hasAccess = accessTable[menuName]
    end
  end
  return hasAccess
end
function GlobalMenu:HasExclusiveAccessMenu()
  return not util.IsStringNilOrEmpty(self.exclusiveAccessMenu)
end
function GlobalMenu:CanOpenMenu(menuName)
  return self.systemMenuIsOpen == false and self.disablePriorityList:GetAvailable() ~= true and self:HasAccessToMenu(menuName) == true
end
function GlobalMenu:ShouldShowPauseWorld(menuName)
  return menuName == "GlobalInWorldMenu" or menuName == "GlobalSettings" and not self.shellLoad
end
function GlobalMenu:ShouldShowGlobalStats(menuName)
  return menuName == "GlobalInWorldMenu" or menuName == "GlobalVendor"
end
function GlobalMenu:FinishGoTo(globalMenuSubStateName, fsmToSendTo)
  local currStateName = self:GetCurrentState().name
  if currStateName == globalMenuSubStateName then
    self:SendEventToUIFsm(fsmToSendTo, "EVT_EXECUTE_INSTRUCTIONS", self.menu:get_instructionEntries(), self.menu:get_instructionArgs())
  else
    self:Goto(globalMenuSubStateName)
  end
end
function GlobalMenu:EVT_SET_FOOTER_BUTTON_PROMPT(text)
  SetText(self.thGlobalButtonPrompts, text)
end
function GlobalMenu:EVT_SET_FOOTER_INFO_TEXT(text)
  if util.IsStringNilOrEmpty(text) then
    SetText(self.thGlobalInfoText, "")
    self.goInfoText:Hide()
  else
    self.goInfoText:Show()
    SetText(self.thGlobalInfoText, text)
  end
end
function GlobalMenu:EVT_SET_HEADER_LABEL(text)
  if util.IsStringNilOrEmpty(text) then
    SetText(self.thGlobalHeaderLabel, "")
    self.goHeaderLabel:Hide()
  else
    self.goHeaderLabel:Show()
    SetText(self.thGlobalHeaderLabel, text)
  end
end
function GlobalMenu:EVT_SHOW_RECIPE_NOTICE(headerText, bodyText)
  if headerText ~= nil then
    UI.SetText(self.thRecipeNoticeHeader, headerText)
  end
  if bodyText ~= nil then
    UI.SetText(self.thRecipeNoticeBody, bodyText)
  end
  self.goRecipeNotice:Show()
end
function GlobalMenu:EVT_HIDE_RECIPE_NOTICE()
  self.goRecipeNotice:Hide()
end
function GlobalMenu:EVT_ENABLE_AUTOMATION_PRINTOUTS(enable)
  local enableString = enable and "enabled" or "disabled"
  util.EnableUIAutomationPrintouts(enable)
  print("Automation printouts " .. enableString)
end
function GlobalMenu:EVT_DM_PAUSE(truePause)
  if truePause then
    self:AttemptPause()
    self:CheckPauseState()
    self.pausePriorityList:SetItemByName("DesignerMessages", true)
  end
  self.disablePriorityList:SetItemByName("DesignerMessages", true)
end
function GlobalMenu:EVT_DM_UNPAUSE()
  self.pausePriorityList:SetItemByName("DesignerMessages", nil)
  self.disablePriorityList:SetItemByName("DesignerMessages", nil)
  self:AttemptUnpause()
  self:CheckPauseState()
end
function GlobalMenu:EVT_SET_OPTIONS_OVERRIDE(override)
  self.optionsOverride = override
end
function GlobalMenu:EVT_DISABLE_PAUSE_MENU()
  self.disablePriorityList:SetItemByName("Designer-Specified", true)
end
function GlobalMenu:EVT_ENABLE_PAUSE_MENU()
  self.disablePriorityList:SetItemByName("Designer-Specified", nil)
end
function GlobalMenu:EVT_GLOBAL_MENU_SET_EXCLUSIVE_ACCESS(menuName)
  self.exclusiveAccessMenu = menuName
end
function GlobalMenu:EVT_GLOBAL_MENU_REQUEST_EXCLUSIVE_ACCESS(menuName, requestScript)
  if self:GetCurrentState().name == "GlobalMenuOff" then
    self.exclusiveAccessMenu = menuName
    requestScript:CallScript("OnMenuExclusiveAccess")
  end
end
function GlobalMenu:EVT_GLOBAL_MENU_CLEAR_EXCLUSIVE_ACCESS(menuName)
  self.exclusiveAccessMenu = nil
end
function GlobalMenu:EVT_MENU_CHOICE()
  self.shellLoad = false
  self:EVT_GO_TO_SETTINGS(true)
end
function GlobalMenu:EVT_TELEMETRY_OPT_IN()
  uiCalls.SendSplashScreenDesignerMessage({
    Text = 45130,
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    Critical = true,
    FooterButtonInfo = {
      {
        Text = "[SquareButton] " .. util.GetLAMSMsg(45148),
        EventHandlers = {
          {
            Events = {
              "EVT_Square_Release"
            },
            Handler = function()
              self:TelemetryMoreInfo1()
            end
          }
        }
      },
      {
        Text = "[AdvanceButton] " .. util.GetLAMSMsg(45131),
        EventHandlers = {
          {
            Events = {
              "EVT_Advance_Release"
            },
            Handler = function()
              UI.SetAllowDataCollection(true)
            end
          }
        }
      },
      {
        Text = "[BackButton] " .. util.GetLAMSMsg(45132),
        EventHandlers = {
          {
            Events = {
              "EVT_Back_Release"
            },
            Handler = function()
              UI.SetAllowDataCollection(false)
            end
          }
        }
      }
    }
  })
end
function GlobalMenu:TelemetryMoreInfo1()
  uiCalls.SendSplashScreenDesignerMessage({
    Title = 45149,
    Text = 45134,
    TextStyle = "TelemetryBody",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    Critical = true,
    FooterButtonInfo = {
      {
        Text = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
        EventHandlers = {
          {
            Events = {
              "EVT_Advance_Release"
            },
            Handler = function()
              self:TelemetryMoreInfo2()
            end
          }
        }
      }
    }
  })
end
function GlobalMenu:TelemetryMoreInfo2()
  uiCalls.SendSplashScreenDesignerMessage({
    Title = 45149,
    Text = 45152,
    TextStyle = "TelemetryBody",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    Critical = true,
    FooterButtonInfo = {
      {
        Text = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
        EventHandlers = {
          {
            Events = {
              "EVT_Advance_Release"
            },
            Handler = function()
              self:TelemetryMoreInfo3()
            end
          }
        }
      }
    }
  })
end
function GlobalMenu:TelemetryMoreInfo3()
  uiCalls.SendSplashScreenDesignerMessage({
    Title = 45149,
    Text = 45150,
    TextStyle = "TelemetryBody",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    Critical = true,
    FooterButtonInfo = {
      {
        Text = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
        EventHandlers = {
          {
            Events = {
              "EVT_Advance_Release"
            },
            Handler = function()
              self:TelemetryMoreInfo4()
            end
          }
        }
      }
    }
  })
end
function GlobalMenu:TelemetryMoreInfo4()
  uiCalls.SendSplashScreenDesignerMessage({
    Title = 45149,
    Text = 45151,
    TextStyle = "TelemetryBody",
    AdvanceType = uiCalls.msgParam.ADVANCE_PRESS,
    MessageVariant = uiCalls.msgParam.SPLASHSCREEN_NO_IMAGE,
    Critical = true,
    FooterButtonInfo = {
      {
        Text = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
        EventHandlers = {
          {
            Events = {
              "EVT_Advance_Release"
            },
            Handler = function()
              self:EVT_TELEMETRY_OPT_IN()
            end
          }
        }
      }
    }
  })
end
function GlobalMenu:EVT_OPEN_LOAD_FROM_SHELL()
  self.shellLoad = true
  self:EVT_GO_TO_SETTINGS(true, true)
end
function GlobalMenu:EVT_OPEN_NGP_LOAD_FROM_SHELL()
  self.shellLoad = true
  self:EVT_GO_TO_SETTINGS(true, true, nil, nil, true)
end
function GlobalMenu:EVT_DeadMenu()
  self.disablePriorityList:SetItemByName("DeadMenu", true)
  self:Goto("GlobalMenuOff")
end
function GlobalMenu:EVT_CLOSE_FAKE_DEATH_SCREEN()
  self.disablePriorityList:SetItemByName("DeadMenu", nil)
end
function GlobalMenu:EVT_TURN_PHOTO_MODE_ON()
  self:EVT_GLOBAL_MENU_SET_EXCLUSIVE_ACCESS("PhotoMode")
  self.disablePriorityList:SetItemByName("PhotoMode", true)
  self:Goto("GlobalMenuOff")
end
function GlobalMenu:EVT_TURN_PHOTO_MODE_OFF()
  self:EVT_GLOBAL_MENU_CLEAR_EXCLUSIVE_ACCESS("PhotoMode")
  self.disablePriorityList:SetItemByName("PhotoMode", nil)
end
function GlobalMenu:EVT_TURN_OFF_GLOBAL_MENU()
  local instructionEntries = self.menu:get_instructionEntries()
  if #instructionEntries == 0 then
    self:Goto("GlobalMenuOff")
  end
end
function GlobalMenu:EVT_SYSTEM_MENU_ENTER()
  self.systemMenuIsOpen = true
end
function GlobalMenu:EVT_SYSTEM_MENU_EXIT()
  self.systemMenuIsOpen = false
end
function GlobalMenu:EVT_OPEN_IN_WORLD_MENU()
  if self:CanOpenMenu("GlobalInWorldMenu") == true then
    self:Goto("GlobalInWorldMenu")
  end
end
function GlobalMenu:EVT_OPEN_SETTINGS_MENU()
  local instructionEntries = self.menu:get_instructionEntries()
  if #instructionEntries == 0 and self:CanOpenMenu("GlobalSettings") == true then
    self.menu:AddInstructionArg("overrideReturnToGame", self.inCinematic)
    self:Goto("GlobalSettings")
    game.Audio.PlaySound("SND_UX_Pause_Menu_Settings_Enter")
  end
end
function GlobalMenu:EVT_OPEN_VENDOR_MENU(vendorWallet, bothHuldraAvailable)
  if self:CanOpenMenu("GlobalVendor") == true then
    self.vendorWallet = vendorWallet
    self.bothHuldraAvailable = bothHuldraAvailable
    self:Goto("GlobalVendor")
  end
end
function GlobalMenu:EVT_OPEN_REALM_TABLE_MENU(selectedRealmInfo)
  if self:CanOpenMenu("GlobalRealmTable") == true then
    self.selectedRealmInfo = selectedRealmInfo
    self:Goto("GlobalRealmTable")
  end
end
function GlobalMenu:EVT_CINEMATIC_MODE_START()
  self:EVT_GLOBAL_MENU_SET_EXCLUSIVE_ACCESS("GlobalSettings")
  self.inCinematic = true
end
function GlobalMenu:EVT_CINEMATIC_MODE_END()
  self:EVT_GLOBAL_MENU_CLEAR_EXCLUSIVE_ACCESS("GlobalSettings")
  self.inCinematic = false
end
function GlobalMenu:EVT_PHOTO_CAPTURE()
  if not self.displayTime and not self.takingPicture then
    self.takingPicture = true
    game.StartScreenCapture()
  end
end
function GlobalMenu:FinishPicture()
  if self.displayTime then
    self.displayTime = self.displayTime - UI.GetFrameTime()
    if self.displayTime <= 0 then
      self.takingPicture = false
      self.displayTime = nil
    end
    return
  end
  local path = game.FinishScreenCapture()
  if path then
    self.displayTime = 2.3
    util.Show("messageHUD")
    uiCalls.SendSidebarDesignerMessage({
      Text = "<FilenameHeader>" .. util.GetLAMSMsg(lamsConsts.PhotoSaved) .. [[
</>
<FilenameBody>]] .. string.gsub(path, "\\", "\\\\") .. "</>",
      MessageVariant = uiCalls.msgParam.SIDEBAR_SMALL,
      DisplayTime = self.displayTime
    })
  end
end
function GlobalMenu:Update()
  if self.takingPicture then
    self:FinishPicture()
  end
end
function GlobalMenu:EVT_GO_TO_PHOTO_MODE()
  if self:CanOpenMenu("GlobalSettings") then
    self:EVT_GLOBAL_MENU_SET_EXCLUSIVE_ACCESS("PhotoMode")
    self:SendEventUI("EVT_TURN_ON_PHOTO_MODE")
  end
end
function GlobalMenu:EVT_GO_TO_SKILL_TREE(weaponName)
  if not (not self:HasExclusiveAccessMenu() and self:HasAccessToMenu("GlobalInWorldMenu")) or not self:CanOpenMenu("GlobalInWorldMenu") then
    return
  end
  self.menu:InitializeInstructionEntries()
  self.menu:AddInstructionEntry({
    StateName = "MenuOn",
    ListName = "MainMenu",
    Item = "SkillTree"
  })
  self.menu:AddInstructionEntry({
    StateName = "SkillTreeOn",
    ListName = consts.inworldMenu_SubmenuList,
    Item = weaponName
  })
  self:FinishGoTo("GlobalInWorldMenu", "inWorldMenu")
end
function GlobalMenu:EVT_GO_TO_WEAPON(weaponName, pickupSlotName, pickupName)
  if not self:HasAccessToMenu("GlobalInWorldMenu") then
    return
  end
  self.menu:InitializeInstructionEntries()
  self.menu:AddInstructionEntry({
    StateName = "MenuOn",
    ListName = "MainMenu",
    Item = "Weapon"
  })
  self.menu:AddInstructionEntry({
    StateName = "WeaponOn",
    ListName = consts.inworldMenu_SubmenuList,
    Item = weaponName
  })
  if pickupUtil.IsValidSlotName(pickupSlotName) then
    local mainListEvent
    if pickupUtil.IsValidName(pickupName) then
      self.menu:AddInstructionEntry({
        StateName = weaponName,
        ListName = "dummy",
        EventName = "EVT_PREP_IMMEDIATE_ITEM_SELECT",
        EventParams = {pickupName}
      })
      mainListEvent = "EVT_Advance_Release"
    end
    self.menu:AddInstructionEntry({
      StateName = weaponName,
      ListName = "MainList",
      Item = pickupSlotName,
      EventName = mainListEvent
    })
    if pickupUtil.IsValidName(pickupName) then
      self.menu:AddInstructionEntry({
        StateName = weaponName,
        ListName = pickupSlotName,
        Item = pickupName
      })
    end
  end
  self:FinishGoTo("GlobalInWorldMenu", "inWorldMenu")
end
function GlobalMenu:EVT_GO_TO_STATS(pickupSlotName, pickupName)
  if not self:HasAccessToMenu("GlobalInWorldMenu") then
    return
  end
  self.menu:InitializeInstructionEntries()
  local submenuName = "StatsKratos"
  local isPickupValid = pickupUtil.IsValidName(pickupName)
  if isPickupValid and pickupUtil.HasTag(pickupName, pickupConsts.TAG_PICKUP_SON) then
    submenuName = "StatsSon"
  end
  self:SendEventUI("EVT_InWorldMenu_OnTransition", nil, "Stats")
  self:SendEventUI("EVT_ResetClothForced")
  self.menu:AddInstructionEntry({
    StateName = "MenuOn",
    ListName = "MainMenu",
    Item = "Stats"
  })
  self.menu:AddInstructionEntry({
    StateName = "StatsOn",
    ListName = consts.inworldMenu_SubmenuList,
    Item = submenuName
  })
  if pickupUtil.IsValidSlotName(pickupSlotName) then
    local mainListEvent
    if isPickupValid then
      self.menu:AddInstructionEntry({
        StateName = submenuName,
        ListName = "dummy",
        EventName = "EVT_PREP_IMMEDIATE_ITEM_SELECT",
        EventParams = {pickupName}
      })
      mainListEvent = "EVT_Advance_Release"
    end
    self.menu:AddInstructionEntry({
      StateName = submenuName,
      ListName = "MainList",
      Item = pickupSlotName,
      EventName = mainListEvent
    })
  end
  self:FinishGoTo("GlobalInWorldMenu", "inWorldMenu")
end
function GlobalMenu:EVT_GO_TO_MAP(realmName, markerIdHashToSelectOnOpen, openForFastTravel)
  if not self:HasAccessToMenu("GlobalInWorldMenu") then
    return
  end
  local inWorldMenu = fsm.GetFSMByName("inWorldMenu")
  if inWorldMenu ~= nil then
    local menuOn = inWorldMenu:GetState("MenuOn")
    if menuOn ~= nil and menuOn:IsActive() then
      menuOn.openMapFromTouchPad = true
    end
  end
  local mapMenu = fsm.GetFSMByName("mapMenu")
  if mapMenu ~= nil then
    local mapOn = mapMenu:GetState("MapOn")
    if mapOn ~= nil and mapOn:IsActive() then
      return
    end
  end
  if util.IsStringNilOrEmpty(realmName) then
    realmName = mapUtil.GetPlayerRealm()
  end
  self.menu:InitializeInstructionEntries()
  self.menu:AddInstructionArg("markerIdHashToSelectOnOpen", markerIdHashToSelectOnOpen)
  self.menu:AddInstructionArg("openForFastTravel", openForFastTravel)
  self.menu:AddInstructionArg("disableMainMenuList", openForFastTravel)
  self.menu:AddInstructionEntry({
    StateName = "MenuOn",
    ListName = "MainMenu",
    Item = "Map"
  })
  self.menu:AddInstructionEntry({
    StateName = "MapOn",
    ListName = consts.inworldMenu_SubmenuList,
    Item = realmName
  })
  self:FinishGoTo("GlobalInWorldMenu", "inWorldMenu")
end
function GlobalMenu:EVT_GO_TO_QUEST(questID)
  if not (not self:HasExclusiveAccessMenu() and self:HasAccessToMenu("GlobalInWorldMenu")) or not self:CanOpenMenu("GlobalInWorldMenu") then
    return
  end
  local rootQuestID = questUtil.GetRootQuestID(questID)
  local questSubStateName = questUtil.GetSubStateName(rootQuestID)
  local trackingInfo = questUtil.GetTrackingInfo(rootQuestID)
  self.menu:InitializeInstructionEntries()
  self.menu:AddInstructionEntry({
    StateName = "MenuOn",
    ListName = "MainMenu",
    Item = "Quests"
  })
  self.menu:AddInstructionEntry({
    StateName = "QuestsOn",
    ListName = consts.inworldMenu_SubmenuList,
    Item = questSubStateName
  })
  if questID ~= nil then
    local questInfo = questUtil.CreateQuestInfo(rootQuestID, 0, trackingInfo)
    self.menu:AddInstructionEntry({
      StateName = questSubStateName,
      ListName = "MainList",
      Item = questInfo
    })
  end
  self:FinishGoTo("GlobalInWorldMenu", "inWorldMenu")
end
function GlobalMenu:EVT_GO_TO_JOURNAL(journalResource)
  if not (not self:HasExclusiveAccessMenu() and self:HasAccessToMenu("GlobalInWorldMenu")) or not self:CanOpenMenu("GlobalInWorldMenu") then
    return
  end
  local submenuName = resourceUtil.HasFlag(journalResource, "Lore") and "Lore" or "Bestiary"
  self.menu:InitializeInstructionEntries()
  self.menu:AddInstructionEntry({
    StateName = "MenuOn",
    ListName = "MainMenu",
    Item = "Journal"
  })
  self.menu:AddInstructionEntry({
    StateName = "JournalOn",
    ListName = consts.inworldMenu_SubmenuList,
    Item = submenuName
  })
  self.menu:AddInstructionEntry({
    StateName = submenuName,
    ListName = "MainList",
    Item = journalResource
  })
  self:FinishGoTo("GlobalInWorldMenu", "inWorldMenu")
end
function GlobalMenu:EVT_GO_TO_OPTIONS()
  if self:CanOpenMenu("GlobalSettings") then
    self:EVT_GO_TO_SETTINGS(false, false, nil, true)
  end
end
function GlobalMenu:EVT_GO_TO_SETTINGS(fromShell, loadScreen, overrideSubmenu, overrideReturnToGame, newGamePlus)
  if not fromShell and not self:HasAccessToMenu("GlobalSettings") then
    return
  end
  self.menu:InitializeInstructionEntries()
  self.menu:AddInstructionArg("from_shell", fromShell)
  self.menu:AddInstructionArg("loadScreen", loadScreen)
  self.menu:AddInstructionArg("overrideSubmenu", overrideSubmenu)
  self.menu:AddInstructionArg("overrideReturnToGame", overrideReturnToGame)
  self.menu:AddInstructionArg("shellNewGamePlus", newGamePlus)
  self:FinishGoTo("GlobalSettings", "settingsMenu")
end
function GlobalMenu:EVT_GO_TO_VENDOR_MENU(vendorWallet, subStateSelection, mainSelection, bothHuldraAvailable)
  if not self:HasAccessToMenu("GlobalVendor") then
    return
  end
  self.vendorWallet = vendorWallet
  self.bothHuldraAvailable = bothHuldraAvailable
  self.menu:InitializeInstructionEntries()
  if not util.IsStringNilOrEmpty(subStateSelection) then
    self.menu:AddInstructionEntry({
      StateName = "VendorOn",
      ListName = consts.vendorMenu_SubmenuList,
      Item = subStateSelection
    })
    local isVendorMenu = true
    if not util.IsStringNilOrEmpty(mainSelection) then
      self.menu:AddInstructionEntry({
        StateName = recipeUtil.GetSubMenuNameFromSubStateIndex(subStateSelection, isVendorMenu),
        ListName = "MainList",
        Item = mainSelection
      })
    end
  end
  self:FinishGoTo("GlobalVendor", "vendorMenu")
end
function GlobalMenuOff:Setup()
  self.globalMenu = self:GetState("globalMenu")
end
function GlobalMenuOff:Enter()
  self.globalMenu.vendorWallet = nil
  self.globalMenu.selectedRealmInfo = nil
  self.globalMenu.bothHuldraAvailable = nil
  self:SendEventUI("EVT_GLOBAL_MENU_CLOSED")
  uiCalls.UI_Refresh_HUD()
  UI.WorldUIRender("")
  UI.SetInPauseMenu(false)
  UI.SetForcePauseMenuStreamingMode(false, consts.FORCED_HUD_STATE_VENDOR_SLOT)
end
function GlobalMenuOff:Exit()
end
function GlobalMenuOff:EVT_Select_Press()
  self.selectPressed = true
end
function GlobalMenuOff:EVT_Select_Release()
  self.selectPressed = false
end
function GlobalMenuOff:EVT_Options_Press()
  self.optionsPressed = true
  if self.selectPressed then
    self.globalMenu.waitForRelease = true
  end
end
function GlobalMenuOff:EVT_Options_Release()
  self.optionsPressed = false
  if self.touchPressed then
    self.globalMenu.waitForTouchRelease = true
  end
  if self.globalMenu.waitForRelease then
    self.globalMenu.waitForRelease = false
    return
  end
  if self.globalMenu.inCinematic then
    if self.globalMenu:CanOpenMenu("GlobalSettings") then
      self.globalMenu:EVT_GO_TO_SETTINGS(false, false, nil, true)
    end
    return
  end
  if not self.globalMenu:HasExclusiveAccessMenu() and self.globalMenu:CanOpenMenu("GlobalInWorldMenu") then
    if self.globalMenu.optionsOverride == nil then
      local weaponName = pickupConsts.Axe
      local Kratos = Player.FindPlayer()
      local currentWeapon = Kratos:GetCurrentWeapon()
      local pickupSlotName = pickupConsts.Slot_PrimaryWeapon
      if currentWeapon ~= pickupConsts.Bare then
        weaponName = currentWeapon
      end
      self.globalMenu:EVT_GO_TO_WEAPON(weaponName, pickupSlotName)
    else
      local goToEvt = "EVT_GO_TO_" .. self.globalMenu.optionsOverride.Override
      if self.globalMenu.optionsOverride.Override == uiCalls.msgParam.OPTIONS_SETTINGS then
        if self.globalMenu.optionsOverride.OverrideParams == nil then
          self.globalMenu.optionsOverride.OverrideParams = {}
        end
        table.insert(self.globalMenu.optionsOverride.OverrideParams, 1, false)
        table.insert(self.globalMenu.optionsOverride.OverrideParams, 2, false)
      end
      self.globalMenu[goToEvt](self.globalMenu, unpack(self.globalMenu.optionsOverride.OverrideParams or {}))
    end
  end
end
function GlobalMenuOff:EVT_TouchPad_Press()
  self.touchPressed = true
end
function GlobalMenuOff:EVT_TouchPad_Release()
  self.touchPressed = false
  if self.globalMenu.waitForTouchRelease then
    self.globalMenu.waitForTouchRelease = false
    return
  end
  if game.IsMapAvailable then
    if not game.IsMapAvailable() then
      return
    end
  elseif game.build.PLATINUM_VERSION == 0 then
    return
  end
  if self.globalMenu:CanOpenMenu("GlobalSettings") then
    local player = game.Player.FindPlayer()
    local playerPadPoint = player and player.Pad and player.Pad.FingerOnTouchpad and player.Pad.RawTouchPoint
    local cornerThresholdX = 0
    if playerPadPoint and game.UI.GetPhotoModeFromTouchpad and game.UI.GetPhotoModeFromTouchpad() and cornerThresholdX > playerPadPoint.x then
      self.globalMenu:EVT_GLOBAL_MENU_SET_EXCLUSIVE_ACCESS("PhotoMode")
      self:SendEventUI("EVT_TURN_ON_PHOTO_MODE")
      return
    end
  end
  if self.globalMenu.inCinematic then
    if self.globalMenu:CanOpenMenu("GlobalSettings") then
      self.globalMenu:EVT_GO_TO_SETTINGS(false, false, nil, true)
    end
    return
  end
  if not self.globalMenu:HasExclusiveAccessMenu() and self.globalMenu:CanOpenMenu("GlobalInWorldMenu") then
    self.globalMenu:EVT_GO_TO_MAP()
  end
end
function GlobalMenuOn:Setup()
  self.globalMenu = self:GetState("globalMenu")
  self.goXPAndHS = self.globalMenu.goGlobalMenu:FindSingleGOByName("XPandHS")
  self.goPauseWorld = util.GetUiObjByName("pauseWorld")
  self.goInWorldUIElements = util.GetUiObjByName("inWorldUIElements")
  self.goMainHUD = util.GetUiObjByName("mainHUD")
  self.goMessageHUD = util.GetUiObjByName("messageHUD")
  self.goMenuFooterToolTip = util.GetUiObjByName("MenuFooterToolTip")
  self.goWater_Art = util.GetUiObjByName("Water_Art")
  self.goWater_RT = util.GetUiObjByName("Water_RT")
  self.goPauseCamera = util.GetUiObjByName("uiCamera_pause").Child
  self.globalMenuPosition = self.globalMenu.goGlobalMenu:GetWorldPosition()
  self.mainHUDPosition = self.goMainHUD:GetWorldPosition()
  self.thTooltip_Top = util.GetTextHandle(self.goMenuFooterToolTip, "Top")
  self.thTooltip_Bottom = util.GetTextHandle(self.goMenuFooterToolTip, "Bottom")
  self.thTooltip_BottomCenter = util.GetTextHandle(self.goMenuFooterToolTip, "BottomCenter")
  self.thXP = util.GetTextHandle(self.goXPAndHS, "XP_Number")
  self.thHacksilver = util.GetTextHandle(self.goXPAndHS, "HS_Number")
  tutorialUtil.RegisterRootDesaturationObject("globalMenu", self.globalMenu.goGlobalMenu)
  tutorialUtil.RegisterRootDesaturationObject("pauseWorld", self.goPauseWorld)
  tutorialUtil.RegisterRootDesaturationObject("inWorldUIElements", self.goInWorldUIElements)
  tutorialUtil.RegisterDesaturationObject("XPandHS", self.goXPAndHS)
  local goAttributeCardRefnode = util.GetUiObjByName("globalMenu_AttributeCard"):FindSingleGOByName("Attributes_Group")
  local goAttributesCard_PowerLevelMeter = goAttributeCardRefnode:FindSingleGOByName("powerLevelMeter")
  local goAttributesCard_PowerLevelPreviewArrow = goAttributeCardRefnode:FindSingleGOByName("powerLevelPreviewArrow")
  local goAttributesCard_Attribute1 = goAttributeCardRefnode:FindSingleGOByName("Attribute1")
  local goAttributesCard_Attribute2 = goAttributeCardRefnode:FindSingleGOByName("Attribute2")
  local goAttributesCard_Attribute3 = goAttributeCardRefnode:FindSingleGOByName("Attribute3")
  local goAttributesCard_Attribute4 = goAttributeCardRefnode:FindSingleGOByName("Attribute4")
  local goAttributesCard_Attribute5 = goAttributeCardRefnode:FindSingleGOByName("Attribute5")
  local goAttributesCard_Attribute6 = goAttributeCardRefnode:FindSingleGOByName("Attribute6")
  tutorialUtil.RegisterDesaturationObject("Attributes_Card", goAttributeCardRefnode)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_PowerLevelMeter", goAttributesCard_PowerLevelMeter)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_PowerLevelPreviewArrow", goAttributesCard_PowerLevelPreviewArrow)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_Attribute1", goAttributesCard_Attribute1)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_Attribute2", goAttributesCard_Attribute2)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_Attribute3", goAttributesCard_Attribute3)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_Attribute4", goAttributesCard_Attribute4)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_Attribute5", goAttributesCard_Attribute5)
  tutorialUtil.RegisterDesaturationObject("Attributes_Card_Attribute6", goAttributesCard_Attribute6)
  self.goMessageHUD:SetWorldPosition(self.mainHUDPosition)
  self:EVT_SET_FOOTER_TOOL_TIP(nil)
end
local UpdateHeaderPosition = function()
  UI.SetGOScreenEdgeVertical("globalMenu_MainMenuList")
  UI.SetGOScreenEdgeVertical("XPandHS")
end
function GlobalMenuOn:Enter()
  UI.PushCamera("HUDMenuCam")
  local goSubtitles = util.GetUiObjByName("RealTimeST1")
  if goSubtitles:IsModelShown() then
    self.showSubtitlesOnExit = true
    goSubtitles:Hide()
  end
  self.globalMenu.goGlobalMenu:Show()
  self.goInWorldUIElements:Show()
  self.goMessageHUD:SetWorldPosition(self.globalMenuPosition)
  UpdateHeaderPosition()
  self:SendEventUI("EVT_GLOBAL_MENU_OPEN")
  uiCalls.UI_Event_Turn_Main_HUD_Off()
end
function GlobalMenuOn:EVT_UPDATE_WINDOW_SIZE()
  UpdateHeaderPosition()
end
function GlobalMenuOn:Exit()
  self.globalMenu:CheckPauseState()
  UI.PopCamera("HUDMenuCam")
  if self.showSubtitlesOnExit then
    local goSubtitles = util.GetUiObjByName("RealTimeST1")
    goSubtitles:Show()
  end
  self.showSubtitlesOnExit = false
  self.globalMenu.goGlobalMenu:Hide()
  self.goInWorldUIElements:Hide()
  attributeUtil.MarkAttributesUninitialized()
  UI.SetText(self.thTooltip_Top, "")
  UI.SetText(self.thTooltip_Bottom, "")
  UI.SetText(self.thTooltip_BottomCenter, "")
  self.goMessageHUD:SetWorldPosition(self.mainHUDPosition)
  uiCalls.UI_Event_Turn_Main_HUD_On()
end
function GlobalMenuOn:Submenu_Enter(menuName)
  if self.globalMenu:ShouldShowPauseWorld(menuName) then
    UI.SetInPauseMenu(true)
    self.globalMenu:AttemptPause()
    self.globalMenu:CheckPauseState()
    self.globalMenu.pausePriorityList:SetItemByName(menuName, true)
    self.goPauseWorld:Show()
    util.Show("WorldUiScene")
    util.Hide("sonJournal_Main")
    util.Hide("messageHUD")
    self.goPauseCamera:StartAnim("uiPauseMenu_Idle")
    if self.goWater_Art ~= nil and self.goWater_RT ~= nil then
      local targetTimelinePos = 1
      local animRate = 0.3
      UI.Anim(self.goWater_Art, consts.AS_ForwardCycle, "", animRate, targetTimelinePos)
      UI.Anim(self.goWater_RT, consts.AS_ForwardCycle, "", animRate, targetTimelinePos)
    end
    Audio.PlaySound("SND_UX_Pause_Menu_AMB_EMIT_FOL_Tree_LP")
    Audio.PlaySound("SND_UX_Pause_Menu_AMB_EMIT_WTR_River_LP")
    Audio.PlaySound("SND_UX_Pause_Menu_AMB_Bird_Call_LP")
  end
end
function GlobalMenuOn:Submenu_Exit(menuName)
  if self.globalMenu:ShouldShowPauseWorld(menuName) then
    UI.SetInPauseMenu(false)
    self.globalMenu.pausePriorityList:SetItemByName(menuName, nil)
    if tutorialUtil.ShouldUnpauseGameInMenu() then
      self.globalMenu:AttemptUnpause()
    end
    self.goPauseWorld:Hide()
    util.Show("messageHUD")
    util.Hide("WorldUiScene")
    Audio.StopSound("SND_UX_Pause_Menu_AMB_EMIT_FOL_Tree_LP")
    Audio.StopSound("SND_UX_Pause_Menu_AMB_EMIT_WTR_River_LP")
    Audio.StopSound("SND_UX_Pause_Menu_AMB_Bird_Call_LP")
  end
end
function GlobalMenuOn:EVT_SET_FOOTER_TOOL_TIP(text)
  local show_text = text
  if util.IsStringNilOrEmpty(text) then
    show_text = ""
    self.goMenuFooterToolTip:Hide()
  else
    self.goMenuFooterToolTip:Show()
  end
  SetText(self.thTooltip_Top, "")
  if self.globalMenu.inCinematic then
    SetText(self.thTooltip_Bottom, "")
    SetText(self.thTooltip_BottomCenter, show_text)
  else
    SetText(self.thTooltip_Bottom, show_text)
    SetText(self.thTooltip_BottomCenter, "")
  end
end
function GlobalMenuOn:EVT_SET_FOOTER_TOOL_TIP_TOP(text)
  local show_text = text
  if util.IsStringNilOrEmpty(text) and not self.globalMenu.inCinematic then
    show_text = ""
    self.goMenuFooterToolTip:Hide()
  else
    self.goMenuFooterToolTip:Show()
  end
  SetText(self.thTooltip_Top, show_text or "")
  if not self.globalMenu.inCinematic then
    SetText(self.thTooltip_Bottom, "")
  end
end
local g_animateXP = false
local g_targetXP, g_currentDisplayedXP, g_currDist_XP
local g_animateHS = false
local g_targetHS, g_currentDisplayedHS, g_currDist_HS
local g_timeStep = 0.04
local g_desiredAnimTime = 0.7
local GetAnimDelta = function(target, current, distance)
  local ratio = math.abs(g_timeStep / g_desiredAnimTime * distance)
  local delta = target < current and -1 or 1
  local appliedDelta = math.floor(delta * ratio)
  local distToTarget = target - (current + appliedDelta)
  if 0 < delta and distToTarget < 0 or delta < 0 and 0 < distToTarget then
    appliedDelta = appliedDelta + distToTarget
  end
  return appliedDelta
end
function GlobalMenuOn:Update()
  if g_animateXP and g_currentDisplayedXP ~= nil then
    if g_currentDisplayedXP ~= g_targetXP then
      g_currentDisplayedXP = g_currentDisplayedXP + GetAnimDelta(g_targetXP, g_currentDisplayedXP, g_currDist_XP)
      self:SetText_XP(g_currentDisplayedXP)
    end
    if g_currentDisplayedXP == g_targetXP then
      self:SetText_XP(g_targetXP)
      g_animateXP = false
    end
  end
  if g_animateHS and g_currentDisplayedHS ~= nil then
    if g_currentDisplayedHS ~= g_targetHS then
      g_currentDisplayedHS = g_currentDisplayedHS + GetAnimDelta(g_targetHS, g_currentDisplayedHS, g_currDist_HS)
      self:SetText_HS(g_currentDisplayedHS)
    end
    if g_currentDisplayedHS == g_targetHS then
      self:SetText_HS(g_targetHS)
      g_animateHS = false
    end
  end
end
local g_prevXP, g_prevHS
function GlobalMenuOn:EVT_REFRESH_GLOBAL_STATS()
  local currXP = resourceUtil.GetAmount(resourceConsts.RESOURCE_XP)
  local currHS = resourceUtil.GetAmount("Hacksilver")
  if g_prevXP == nil then
    self:SetText_XP(currXP)
  end
  if g_prevHS == nil then
    self:SetText_HS(currHS)
  end
  g_currentDisplayedXP = g_prevXP
  if g_currentDisplayedXP then
    g_targetXP = currXP
  end
  g_currentDisplayedHS = g_prevHS
  if g_currentDisplayedHS then
    g_targetHS = currHS
  end
  if not g_XP_HS_Flourish_ignoreUpdate and g_prevXP ~= nil and g_prevHS ~= nil and (currXP ~= g_prevXP or currHS ~= g_prevHS) then
    local jid_XP_Up = self.goXPAndHS:GetJointIndex("XP_arrowUP")
    local jid_XP_Down = self.goXPAndHS:GetJointIndex("XP_arrowDOWN")
    local jid_HS_Up = self.goXPAndHS:GetJointIndex("HS_arrowUP")
    local jid_HS_Down = self.goXPAndHS:GetJointIndex("HS_arrowDOWN")
    if currXP > g_prevXP then
      self.goXPAndHS:ShowJoint(jid_XP_Up)
      self.goXPAndHS:HideJoint(jid_XP_Down)
    elseif currXP < g_prevXP then
      self.goXPAndHS:ShowJoint(jid_XP_Down)
      self.goXPAndHS:HideJoint(jid_XP_Up)
    else
      self.goXPAndHS:HideJoint(jid_XP_Down)
      self.goXPAndHS:HideJoint(jid_XP_Up)
    end
    if currHS > g_prevHS then
      self.goXPAndHS:ShowJoint(jid_HS_Up)
      self.goXPAndHS:HideJoint(jid_HS_Down)
    elseif currHS < g_prevHS then
      self.goXPAndHS:ShowJoint(jid_HS_Down)
      self.goXPAndHS:HideJoint(jid_HS_Up)
    else
      self.goXPAndHS:HideJoint(jid_HS_Up)
      self.goXPAndHS:HideJoint(jid_HS_Down)
    end
    local animName = ""
    local animRate = 1
    local frameMax = 30
    local animFrame_Start = 0
    local animFrame_End = 30
    local animPos_Start = animFrame_Start / frameMax
    local animPos_End = animFrame_End / frameMax
    UI.Anim(self.goXPAndHS, consts.AS_Forward, animName, animRate, animPos_Start, animPos_End)
  end
  if g_XP_HS_Flourish_ignoreUpdate then
    self:SetText_XP(currXP)
    self:SetText_HS(currHS)
  else
    if currXP ~= g_currentDisplayedXP then
      g_currDist_XP = g_currentDisplayedXP - g_targetXP
      g_animateXP = true
    end
    if currHS ~= g_currentDisplayedHS then
      g_currDist_HS = g_currentDisplayedHS - g_targetHS
      g_animateHS = true
    end
  end
  g_prevXP = currXP
  g_prevHS = currHS
  g_XP_HS_Flourish_ignoreUpdate = false
end
function GlobalMenuOn:SetText_XP(amount)
  local xpText = "[EconomyXP] " .. tostring(amount)
  SetText(self.thXP, xpText)
  g_currentDisplayedXP = amount
end
function GlobalMenuOn:SetText_HS(amount)
  local hacksilverText = "[Hacksilver] " .. util.GetLAMSMsg(lamsConsts.HS) .. " " .. tostring(amount)
  SetText(self.thHacksilver, hacksilverText)
  g_currentDisplayedHS = amount
end
function GlobalInWorldMenu:Setup()
  self.globalMenuOn = self:GetState("GlobalMenuOn")
end
function GlobalInWorldMenu:Enter()
  self.globalMenuOn:Submenu_Enter("GlobalInWorldMenu")
  self:SendEventToUIFsm("inWorldMenu", "EVT_TURN_ON_IN_WORLD_MENU", self.globalMenuOn.globalMenu.menu:get_instructionEntries(), self.globalMenuOn.globalMenu.menu:get_instructionArgs())
end
function GlobalInWorldMenu:Exit()
  self.globalMenuOn.globalMenu:EVT_SET_FOOTER_BUTTON_PROMPT("")
  self.globalMenuOn:Submenu_Exit("GlobalInWorldMenu")
  self:SendEventToUIFsm("inWorldMenu", "EVT_TURN_OFF_IN_WORLD_MENU")
end
function GlobalSettings:Setup()
  self.globalMenuOn = self:GetState("GlobalMenuOn")
  self.globalMenu = self:GetState("globalMenu")
end
function GlobalSettings:Enter()
  self.globalMenuOn:Submenu_Enter("GlobalSettings")
  self:SendEventToUIFsm("settingsMenu", "EVT_TURN_ON_SETTINGS_MENU", self.globalMenuOn.globalMenu.menu:get_instructionEntries(), self.globalMenuOn.globalMenu.menu:get_instructionArgs())
end
function GlobalSettings:Exit()
  self.globalMenu.shellLoad = false
  self.globalMenuOn:Submenu_Exit("GlobalSettings")
  self:SendEventToUIFsm("settingsMenu", "EVT_TURN_OFF_SETTINGS_MENU")
end
function GlobalVendor:Setup()
  self.globalMenuOn = self:GetState("GlobalMenuOn")
end
function GlobalVendor:Enter()
  self.globalMenuOn:Submenu_Enter("GlobalVendor")
  self:SendEventToUIFsm("vendorMenu", "EVT_TURN_ON_VENDOR_MENU", self.globalMenuOn.globalMenu.vendorWallet, self.globalMenuOn.globalMenu.bothHuldraAvailable, self.globalMenuOn.globalMenu.menu:get_instructionEntries(), self.globalMenuOn.globalMenu.menu:get_instructionArgs())
end
function GlobalVendor:Exit()
  self.globalMenuOn.globalMenu.vendorWallet = nil
  self.globalMenuOn.globalMenu.bothHuldraAvailable = nil
  self.globalMenuOn.globalMenu:EVT_SET_FOOTER_BUTTON_PROMPT("")
  self.globalMenuOn:Submenu_Exit("GlobalVendor")
  self:SendEventToUIFsm("vendorMenu", "EVT_TURN_OFF_VENDOR_MENU")
end
function GlobalRealmTable:Setup()
  self.globalMenu = self:GetState("globalMenu")
  self.globalMenuOn = self:GetState("GlobalMenuOn")
end
function GlobalRealmTable:Enter()
  self.globalMenuOn:Submenu_Enter("GlobalRealmTable")
  self:SendEventToUIFsm("realmTableMenu", "EVT_TURN_ON_REALM_TABLE_MENU", self.globalMenuOn.globalMenu.selectedRealmInfo, self.globalMenuOn.globalMenu.menu:get_instructionEntries(), self.globalMenuOn.globalMenu.menu:get_instructionArgs())
end
function GlobalRealmTable:Exit()
  self.globalMenuOn.globalMenu.selectedRealmInfo = nil
  self.globalMenuOn.globalMenu:EVT_SET_FOOTER_BUTTON_PROMPT("")
  self.globalMenuOn:Submenu_Exit("GlobalRealmTable")
  self:SendEventToUIFsm("realmTableMenu", "EVT_TURN_OFF_REALM_TABLE_MENU")
end
function GlobalRealmTable:EVT_Back_Press()
  self.globalMenu.waitForRelease = true
end
function GlobalMenu:OnSaveCheckpoint(tab)
end
function GlobalMenu:OnRestoreCheckpoint(tab)
end
