local classlib = require("core.class")
local tablex = require("core.tablex")
local animationUtil = require("ui.animationUtil")
local attributeCard = require("ui.attributeCard")
local attributeUtil = require("ui.attributeUtil")
local bestiaryUtil = require("ui.bestiaryUtil")
local buttonUtil = require("ui.buttonUtil")
local characterUtil = require("ui.characterUtil")
local consts = require("ui.consts")
local fsm = require("ui.fsm")
local lamsConsts = require("ui.lamsConsts")
local list = require("ui.list")
local mapUtil = require("ui.mapUtil")
local menu = require("ui.menu")
local pickupConsts = require("ui.pickupConsts")
local pickupUtil = require("ui.pickupUtil")
local questUtil = require("ui.questUtil")
local recipeUtil = require("ui.recipeUtil")
local resourceConsts = require("ui.resourceConsts")
local resourceUtil = require("ui.resourceUtil")
local skillUtil = require("ui.skillUtil")
local timer = require("level.timer")
local topNavBar = require("ui.topNavBar")
local tutorials = require("ui.tutorials")
local tutorialUtil = require("ui.tutorialUtil")
local uiCalls = require("ui.uicalls")
local util = require("ui.util")
local iconConsts = require("ui.iconConsts")
local AI = game.AI
local Audio = game.Audio
local Player = game.Player
local SetText = game.UI.SetText
local UI = game.UI
local InWorldMenu = classlib.Class("InWorldMenu", fsm.UIState)
local MenuOff = InWorldMenu:StateClass("MenuOff", fsm.UIState)
local MenuOn = InWorldMenu:StateClass("MenuOn", fsm.UIState)
local Weapon = InWorldMenu:StateClass("Weapon", fsm.UIState)
local SkillTree = InWorldMenu:StateClass("SkillTree", fsm.UIState)
local Stats = InWorldMenu:StateClass("Stats", fsm.UIState)
local Map = InWorldMenu:StateClass("Map", fsm.UIState)
local Quests = InWorldMenu:StateClass("Quests", fsm.UIState)
local Journal = InWorldMenu:StateClass("Journal", fsm.UIState)
local Resources = InWorldMenu:StateClass("Resources", fsm.UIState)
local inWorldMenu = InWorldMenu.New("inWorldMenu", {
  MenuOff,
  MenuOn,
  {
    Weapon,
    SkillTree,
    Stats,
    Map,
    Quests,
    Journal,
    Resources
  }
})
local SoundMenuEventNames = {
  journalMenu = "SND_UX_Pause_Menu_Screen_Codex_LP",
  mapMenu = "SND_UX_Pause_Menu_Screen_Map_LP",
  questsMenu = "SND_UX_Pause_Menu_Screen_Quest_LP",
  skillTreeMenu = "SND_UX_Pause_Menu_Screen_Skills_LP",
  statsMenu = "",
  weaponMenu = "",
  resourcesMenu = ""
}
function PlayUniqueMenuScreenSound(menuName)
  if SoundMenuEventNames[menuName] ~= nil and SoundMenuEventNames[menuName] ~= "" then
    Audio.PlaySound(SoundMenuEventNames[menuName])
  end
end
function StopUniqueMenuScreenSound(menuName)
  if SoundMenuEventNames[menuName] ~= nil and SoundMenuEventNames[menuName] ~= "" then
    Audio.StopSound(SoundMenuEventNames[menuName])
  end
end
function InWorldMenu:Setup()
end
function InWorldMenu:Enter()
  self:WantPadEvents(true)
  self:TurnOff()
end
function InWorldMenu:Exit()
end
function InWorldMenu:TurnOff()
  self:Goto("MenuOff")
end
function InWorldMenu:EVT_TURN_OFF_GAME_MENU()
  self:Goto("MenuOff")
end
function InWorldMenu:EVT_HIDE_ATTRIBUTE_CARD(instant)
  self:GetState("MenuOn").attributeCard:HideCard(instant)
end
function InWorldMenu:EVT_TURN_ON_IN_WORLD_MENU(instructionEntries, instructionArgs)
  self.menuOn = self:GetState("MenuOn")
  self.menuOn.menu:set_instructionEntries(instructionEntries)
  self.menuOn.menu:set_instructionArgs(instructionArgs)
  self.menuOn.disableMainMenuList = instructionArgs.disableMainMenuList
  self:Goto("MenuOn")
end
function InWorldMenu:EVT_TURN_OFF_IN_WORLD_MENU()
  self:Goto("MenuOff")
end
InWorldMenu.EVT_GAME_OVER = InWorldMenu.TurnOff
InWorldMenu.EVT_Restart = InWorldMenu.TurnOff
InWorldMenu.EVT_GAME_START = InWorldMenu.TurnOff
function MenuOff:Setup()
  self.inWorldMenu = self:GetState("inWorldMenu")
  self.menuOn = self:GetState("MenuOn")
end
function MenuOff:Enter()
  util.Hide("inWorldMenu")
  self:SendEventUI("EVT_PAUSE_MENU_CLOSED")
  self.L2_Pressed = false
  self.menuOn.markerIdHashToSelectOnOpen = nil
  self:StartTimer("MenuExitVideoUnloadTimer", 0.5, UI.VideoUnload)
end
function MenuOff:Exit()
end
function MenuOn:Setup()
  self.inWorldMenu = self:GetState("inWorldMenu")
  self.disableMainMenuList = false
  self._oldState = nil
  self.menu = menu.Menu.New(self, {})
  local maxMainMenuButtonCount = #consts.SUB_STATES.inWorldMenu
  local mainMenuList = list.List.New(self, {
    MaxFocusableObjectCount = maxMainMenuButtonCount,
    ListObjectName = consts.inworldMenu_MainMenuList,
    SelectionChangeSound = "SND_UX_Menu_Tick_Horizontal",
    DelayTime = consts.SingleFrameDelayTime,
    AllowScrollIndicatorAnim = true,
    PreviousEvents = {
      "EVT_L1_Press"
    },
    NextEvents = {
      "EVT_R1_Press"
    },
    Button_Update = function(button)
      self:Button_Update(button)
    end,
    Button_OnGainFocus = function(button)
      if self._oldState == nil then
        self:Button_OnGainFocus(button)
      end
    end,
    Button_HighlightOn = function(button, animateImmediately)
      self:Button_HighlightOn(button, animateImmediately)
    end,
    Button_HighlightOff = function(button, animateImmediately)
      self:Button_HighlightOff(button, animateImmediately)
    end,
    AfterDelay = function(list, delayStartButtonIndex, selectedButtonIndex)
      local selectedButton = list:GetButton(selectedButtonIndex)
      self:Button_OnGainFocus(selectedButton)
    end
  })
  self.menu:SetList("MainMenu", mainMenuList)
  local showList = false
  self:RefreshMainMenuList(mainMenuList, showList)
  self.topNavBar = topNavBar.TopNavBar.New(mainMenuList)
  self.topNavBar:Init(maxMainMenuButtonCount)
  local useOnGainFocus = false
  mainMenuList:SelectItem("Weapon", useOnGainFocus)
  mainMenuList:HideLabel()
  local goAttributeCardRefnode = util.GetUiObjByName("globalMenu_AttributeCard")
  self.attributeCard = attributeCard.AttributeCard.New(goAttributeCardRefnode)
  self.attributeCard:Init(self)
  self.attributeCard:HideCard()
  util.ShowRecursive("pause_environment", "proxyKratos", "proxySon")
  util.Show("inWorldUIElements")
  util.Hide("WorldUiScene")
  tutorialUtil.RegisterDesaturationList("MainMenu", mainMenuList)
  self.trinketAvailability = true
  self.weaponSpecialsAvailability = {}
  for _, slotName in ipairs(pickupConsts.WEAPONMENU_WEAPON_SPECIAL_SLOTS) do
    self.weaponSpecialsAvailability[slotName] = true
  end
end
function MenuOn:Enter()
  self.menu:Activate()
  UI.PadClear()
  UI.WorldUIRender("cameraJoint")
  util.Show("inWorldMenu")
  self:CheckTrinketAvailability()
  self:CheckWeaponSpecialsAvailability()
  self:SendEventUI("EVT_PAUSE_MENU_OPEN")
  self:SendEventUI("EVT_TURN_OFF_PHOTO_MODE")
  self:SendEventToUIFsm("inWorldMenu", "EVT_REFRESH_NOTIFICATIONS")
  local mainMenuList = self.menu:GetList("MainMenu")
  local showList = true
  local useOnGainFocus = false
  mainMenuList:SelectItem("Weapon", useOnGainFocus)
  self:RefreshMainMenuList(mainMenuList, showList)
  self.topNavBar:UpdatePositions()
  if self.disableMainMenuList == true then
    local hideList = true
    local clearButtons = false
    mainMenuList:Deactivate(hideList, clearButtons)
  end
  animationUtil.InitCamera()
  self:UpdateProxySonVisibility()
  pickupUtil.InitializeSlotsOnUICreatures()
  characterUtil.InitializePickupSlots()
  self.uiCreaturesInitialized = false
  self:ClearAttributePreview()
  self:StartTimer("PickupUICreatureDelayTimer", consts.SingleFrameDelayTime, function()
    self:OnCreaturesInitialized(false)
    self.menu:ExecuteInstructions()
  end)
  self:RefreshGlobalStats()
  self:UpdateEnvironment()
  self.menu:ExecuteInstructions()
end
function MenuOn:Exit()
  self.menu:Deactivate(true)
  characterUtil.ApplyAllPickupChanges()
  UI.WorldUIRender("")
  if game.UI.SoftSavePlayerState then
    game.UI.SoftSavePlayerState()
  else
    game.SubObject.SoftSave()
  end
  self.disableMainMenuList = false
  self.uiCreaturesInitialized = false
  self._oldState = nil
  if game.Wallets.FixupRuneUnderflow then
    game.Wallets.FixupRuneUnderflow("HERO")
  end
  self.attributeCard._firstPowerLevelSet = false
end
function MenuOn:UpdateEnvironment()
  local debugOn = false
  local goEnvironment = util.GetUiObjByName("Pause_Environment")
  local GetGlobalVar = game.Level.GetVariable
  local completedCineNumber = GetGlobalVar("CompletedCineNumber")
  local sindriGetsServed = 450
  local modiReturns = 460
  local baldurDeath = 570
  local jid_snow = goEnvironment:GetJointIndex("emit_ui_snow")
  if completedCineNumber >= baldurDeath or debugOn then
    goEnvironment:ShowJoint(jid_snow)
  else
    goEnvironment:HideJoint(jid_snow)
  end
  local jid_lightning = goEnvironment:GetJointIndex("emit_ui_lightning")
  if completedCineNumber >= sindriGetsServed and completedCineNumber < modiReturns or debugOn then
    goEnvironment:ShowJoint(jid_lightning)
  else
    goEnvironment:HideJoint(jid_lightning)
  end
end
function MenuOn:CheckTrinketAvailability()
  self.trinketAvailability = true
  local playerCreature = Player.FindPlayer()
  assert(playerCreature ~= nil, "Player creature is nil when entering pause menu")
  local trinketName = playerCreature:PickupGetPickupNameInSlot(pickupConsts.Slot_ArmorTrinket)
  if not util.IsStringNilOrEmpty(trinketName) then
    local cooldownPickupName = playerCreature:PickupGetPickupNameInSlot(pickupConsts.Slot_TalismanCooldown)
    if not util.IsStringNilOrEmpty(cooldownPickupName) and not playerCreature:PickupIsAvailable(cooldownPickupName) then
      self.trinketAvailability = false
      return
    end
  end
  for _, markerStr in ipairs(pickupConsts.TRINKET_MARKER_LOCKS) do
    if playerCreature:HasMarker(markerStr) then
      self.trinketAvailability = false
      return
    end
  end
end
function MenuOn:CheckWeaponSpecialsAvailability()
  local playerCreature = Player.FindPlayer()
  assert(playerCreature ~= nil, "Player creature is nil when entering pause menu")
  for pickupSlotName, _ in pairs(self.weaponSpecialsAvailability) do
    self.weaponSpecialsAvailability[pickupSlotName] = true
    if playerCreature:PickupIsSlotUsed(pickupSlotName) then
      local pickupInSlot = playerCreature:PickupGetPickupNameInSlot(pickupSlotName)
      if playerCreature.PickupIsInCooldown then
        if playerCreature:PickupIsInCooldown(pickupInSlot) or playerCreature:PickupIsActive(pickupInSlot) then
          self.weaponSpecialsAvailability[pickupSlotName] = false
        end
      elseif not playerCreature:PickupIsAvailable(pickupInSlot) then
        self.weaponSpecialsAvailability[pickupSlotName] = false
      end
      local markerList = pickupConsts.WEAPONMENU_SLOT_TO_MARKER_LOCKS[pickupSlotName]
      for _, markerStr in ipairs(markerList) do
        if playerCreature:HasMarker(markerStr) then
          self.weaponSpecialsAvailability[pickupSlotName] = false
        end
      end
    end
  end
end
function MenuOn:RefreshMainMenuList(mainMenuList, showList)
  local newItemArray = self:GetSubStateNames()
  local useOnGainFocus = not self.menu:HasInstructionEntryForMenuState()
  local itemDetermineFocusabilityFunc
  local itemGetTextFunc = function(name)
    return self:GetSubStateDisplayName(name)
  end
  mainMenuList:Refresh(newItemArray, showList, useOnGainFocus, itemDetermineFocusabilityFunc, itemGetTextFunc)
end
function MenuOn:UpdateProxySonVisibility()
  local showSon = util.SonUI_ShouldShow()
  local arrowsPickup = "SonArrow_Visual"
  if showSon == true then
    util.Show("proxySon")
    local arrowsStage = 0
    local son = game.AI.FindSon()
    if son and son:PickupIsAcquired(arrowsPickup) then
      arrowsStage = son:PickupGetStage(arrowsPickup)
    end
    local uiSon = pickupUtil.GetUICreature(pickupConsts.TAG_PICKUP_SON)
    if uiSon then
      uiSon:PickupAcquire(arrowsPickup, arrowsStage, true)
    end
  else
    pickupUtil.ClearUISonPickups()
    local uiSon = pickupUtil.GetUICreature(pickupConsts.TAG_PICKUP_SON)
    if uiSon and uiSon:PickupIsAcquired(arrowsPickup) then
      uiSon:PickupRelinquish(arrowsPickup)
    end
    util.Hide("proxySon")
  end
end
function MenuOn:Button_Update(button)
  local showNotificationFunctionsTable = {
    SkillTree = skillUtil.AnyNewInside,
    Weapon = resourceUtil.WeaponMenu_AnyNewInside,
    Stats = resourceUtil.StatsMenu_AnyNewInside,
    Map = function(button)
      return UI.HasNotificationOfType ~= nil and UI.HasNotificationOfType("Map")
    end,
    Quests = nil,
    Journal = nil,
    Resources = nil
  }
  local currentItem = button:get_item()
  local showNotificationFunc = showNotificationFunctionsTable[currentItem]
  button:UpdateNewIcon(showNotificationFunc)
end
function MenuOn:Button_OnGainFocus(button)
  local currItem = button:get_item()
  button:Update()
  self:RefreshGlobalStats()
  self.menu:SetMenuListLabelText("MainMenu", "")
  self._oldState = self:GetCurrentState().name
  self._newState = currItem
  self:SendEventUI("EVT_InWorldMenu_OnTransition", self._oldState, self._newState)
  if tablex.Contains(consts.STATES_WITH_ATTRIBUTES, self._oldState) and not tablex.Contains(consts.STATES_WITH_ATTRIBUTES, self._newState) then
    local instant = true
    self:GetState("MenuOn").attributeCard:HideCard(instant)
  end
  if self.openMapFromTouchPad == true then
    self.menu:InitializeInstructionEntries()
    self.openMapFromTouchPad = false
  end
  self:Goto(currItem)
end
function MenuOn:Button_HighlightOn(button, animateImmediately)
  if self.disableMainMenuList then
    self:Button_HighlightOff(button, true)
    return
  end
  local thText = button:GetTextHandle("text")
  local goButtonChild = button:GetInstancedChildObject()
  local goHighlight = goButtonChild:FindSingleGOByName("Highlight")
  local animRate = 1
  local startTime = 0
  local endTime = 0.5
  if animateImmediately == true then
    animRate = 0
    UI.Anim(goHighlight, consts.AS_Forward, "", animRate, endTime)
  else
    UI.Anim(goHighlight, consts.AS_Forward, "", animRate, startTime, endTime)
  end
end
function MenuOn:Button_HighlightOff(button, animateImmediately)
  local thText = button:GetTextHandle("text")
  local goButtonChild = button:GetInstancedChildObject()
  local goHighlight = goButtonChild:FindSingleGOByName("Highlight")
  local animRate = 1
  local startTime = 0.5
  local endTime = 1
  if animateImmediately == true then
    animRate = 0
    UI.Anim(goHighlight, consts.AS_Forward, "", animRate, endTime)
  else
    UI.Anim(goHighlight, consts.AS_Reverse, "", animRate, startTime, endTime)
  end
end
function MenuOn:GetSubStateNames()
  local allSubstates = consts.SUB_STATES.inWorldMenu
  local visibleSubstates = {}
  for index, name in ipairs(allSubstates) do
    local shouldAdd = true
    if shouldAdd then
      visibleSubstates[#visibleSubstates + 1] = name
    end
    if self.topNavBar ~= nil then
      local active = shouldAdd
      self.topNavBar:SetFrameActive(index, active)
    end
  end
  return visibleSubstates
end
function MenuOn:GetSubStateDisplayName(subStateName)
  return util.GetLAMSMsg(lamsConsts[subStateName])
end
function MenuOn:GetSubStateDisplayIcon(subStateName)
  return iconConsts[subStateName]
end
function MenuOn:RefreshGlobalStats()
  self:SendEventToUIFsm("globalMenu", "EVT_REFRESH_GLOBAL_STATS")
end
function MenuOn:ClearAttributePreview()
  self.attributeCard:UpdateMeter_Preview(nil)
  self.attributeCard:ClearPowerLevelPreview()
end
function MenuOn:UpdateEquippedAttributes(character, refreshAttributes, deltaAttributes)
  if refreshAttributes == nil then
    refreshAttributes = true
  end
  pickupUtil.CheckCharacterPickupID(character)
  local attributes = attributeUtil.GetUICreatureAttributes(character)
  if deltaAttributes then
    for i, deltaValue in ipairs(deltaAttributes) do
      if deltaValue ~= 0 then
        attributes[i] = attributes[i] + deltaValue
      end
    end
  end
  attributeUtil.SetCurrentlyEquippedAttributes(character, attributes, self.uiCreaturesInitialized)
  self:SendEventUI("EVT_EQUIPPED_ATTRIBUTES_UPDATED")
  if refreshAttributes then
    self:RefreshAttributes(character)
  end
end
function MenuOn:UpdateEquippedAttributes_RuneSwap(character, refreshAttributes, deltaAttributes)
  if refreshAttributes == nil then
    refreshAttributes = true
  end
  pickupUtil.CheckCharacterPickupID(character)
  attributeUtil.UpdateCurrentlyEquippedAttributes(character, deltaAttributes)
  self:SendEventUI("EVT_EQUIPPED_ATTRIBUTES_UPDATED")
  if refreshAttributes then
    self:RefreshAttributes(character)
  end
end
function MenuOn:RefreshAttributes(character)
  pickupUtil.CheckCharacterPickupID(character)
  character = pickupConsts.TAG_PICKUP_KRATOS
  local equippedAttributes = attributeUtil.GetCurrentlyEquippedAttributes(character)
  local uiCreature = pickupUtil.GetUICreature(character)
  self.attributeCard:UpdateMeter_Equipped(equippedAttributes, character, uiCreature)
end
function MenuOn:OnCreaturesInitialized(updateMeters)
  if util.SonUI_ShouldShow() and not util.SonUI_ShouldDisable() then
    self:UpdateEquippedAttributes(pickupConsts.TAG_PICKUP_SON, updateMeters)
  end
  self:UpdateEquippedAttributes(pickupConsts.TAG_PICKUP_KRATOS, updateMeters)
  self.uiCreaturesInitialized = true
  if self.characterToInitialize ~= nil then
    self:UpdateEquippedAttributes(self.characterToInitialize)
    self.characterToInitialize = nil
  end
  attributeUtil.MarkAttributesInitialized()
end
function MenuOn:EVT_VFS_On()
  self:WantPadEvents(false)
end
function MenuOn:EVT_VFS_Off()
  self:WantPadEvents(true)
end
function MenuOn:EVT_CLOSE_PAUSE_MENU()
  self:Goto("MenuOff")
end
function MenuOn:EVT_SHOW_ATTRIBUTE_CARD()
  self.attributeCard:ShowCard(false)
end
function MenuOn:EVT_SMALL_ATTRIBUTE_CARD()
  self.attributeCard:SmallCard(true)
end
function MenuOn:EVT_LARGE_ATTRIBUTE_CARD()
  self.attributeCard:SmallCard(false)
end
function MenuOn:EVT_REFRESH_NOTIFICATIONS()
  self:RefreshGlobalStats()
  local mainMenuList = self.menu:GetList("MainMenu")
  mainMenuList:Update()
end
function MenuOn:EVT_UPDATE_EQUIPPED_ATTRIBUTES(character)
  assert(character ~= nil, "'character' passed into event MenuOn:EVT_REFRESH_ATTRIBUTES was nil")
  self:StartTimer("RefreshEquippedAttributesDelayTimer", consts.SingleFrameDelayTime, function()
    if self.uiCreaturesInitialized then
      self:UpdateEquippedAttributes(character)
    else
      self.characterToInitialize = character
    end
  end)
end
function MenuOn:EVT_UPDATE_EQUIPPED_ATTRIBUTES_WITH_DELTA(character, deltaAttributes)
  assert(character ~= nil, "'character' passed into event MenuOn:EVT_REFRESH_ATTRIBUTES was nil")
  self:StartTimer("RefreshEquippedAttributesDelayTimer", consts.SingleFrameDelayTime, function()
    if self.uiCreaturesInitialized then
      local refreshAttributes = true
      self:UpdateEquippedAttributes(character, refreshAttributes, deltaAttributes)
    else
      self.characterToInitialize = character
    end
  end)
end
function MenuOn:EVT_UPDATE_EQUIPPED_ATTRIBUTES_WITH_DELTA_RUNESWAP(character, deltaAttributes)
  assert(character ~= nil, "'character' passed into event MenuOn:EVT_UPDATE_EQUIPPED_ATTRIBUTES_WITH_DELTA_RUNESWAP was nil")
  self:StartTimer("RefreshEquippedAttributesDelayTimer", consts.SingleFrameDelayTime, function()
    if self.uiCreaturesInitialized then
      local refreshAttributes = true
      self:UpdateEquippedAttributes_RuneSwap(character, refreshAttributes, deltaAttributes)
    else
      self.characterToInitialize = character
    end
  end)
end
function MenuOn:EVT_REFRESH_ATTRIBUTES(character)
  assert(character ~= nil, "'character' passed into event MenuOn:EVT_REFRESH_ATTRIBUTES was nil")
  self:StartTimer("RefreshAttributesDelayTimer", consts.SingleFrameDelayTime, function()
    if self.uiCreaturesInitialized then
      self:RefreshAttributes(character)
    else
      self.characterToInitialize = character
    end
  end)
end
function MenuOn:EVT_UPDATE_ATTRIBUTES_PREVIEW(character)
  assert(character ~= nil, "'character' passed into event MenuOn:EVT_UPDATE_ATTRIBUTES_PREVIEW was nil")
  attributeUtil.UpdateAttributePreview(self, character, function()
    if self.uiCreaturesInitialized then
      local isVendorMenu = false
      attributeUtil.UpdateAttributePreview_PostTimer(self.attributeCard, character, isVendorMenu)
    end
  end)
end
function MenuOn:EVT_CLEAR_ATTRIBUTES_PREVIEW()
  self:StartTimer("ClearAttributesDelayTimer", consts.SingleFrameDelayTime, function()
    self:ClearAttributePreview()
  end)
end
local statesWithAnimatedCamera = {
  "Weapon",
  "Stats",
  "Resources"
}
function MenuOn:EVT_INIT_CAMERA(character, cameraState)
  local initCamera = false
  local oldStateIsStateWithAnimatedCamera = tablex.Contains(statesWithAnimatedCamera, self._oldState)
  if not oldStateIsStateWithAnimatedCamera then
    initCamera = true
  end
  animationUtil.InitMenuState(self, character, cameraState, initCamera)
end
function MenuOn:EVT_UPDATE_CAMERA(character, cameraState)
  animationUtil.UpdateCamera(self, character, cameraState)
end
function MenuOn:EVT_ATTEMPT_TUTORIAL(inWorldSubstateName, tutorialResource, tutorialName)
  local subState = self:GetState(inWorldSubstateName)
  local subStateAvailable = subState ~= nil and subState:IsActive()
  if subStateAvailable then
    local mainMenuList = self.menu:GetList("MainMenu")
    if not mainMenuList:DelayTimerExists() then
      tutorialUtil.SetupAndBeginTutorial(self, tutorials, tutorialResource, tutorialName)
    end
  end
end
function MenuOn:EVT_EXECUTE_INSTRUCTIONS(instructionEntries, instructionArgs)
  self.menu:set_instructionEntries(instructionEntries)
  self.menu:set_instructionArgs(instructionArgs)
  self.disableMainMenuList = instructionArgs.disableMainMenuList
  self.menu:ExecuteInstructions()
end
function Weapon:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function Weapon:Enter()
  PlayUniqueMenuScreenSound("weaponMenu")
  self:SendEventToUIFsm("weaponMenu", "EVT_TURN_ON_WEAPON_MENU", self.menuOn.weaponSpecialsAvailability, self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
  util.Show("XPandHS")
end
function Weapon:Exit()
  StopUniqueMenuScreenSound("weaponMenu")
  self:SendEventToUIFsm("weaponMenu", "EVT_TURN_OFF_WEAPON_MENU")
  util.Hide("XPandHS")
end
function Stats:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function Stats:Enter()
  PlayUniqueMenuScreenSound("statsMenu")
  self:SendEventToUIFsm("statsMenu", "EVT_TURN_ON_STATS_MENU", self.menuOn.trinketAvailability, self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
  util.Show("XPandHS")
end
function Stats:Exit()
  StopUniqueMenuScreenSound("statsMenu")
  self:SendEventToUIFsm("statsMenu", "EVT_TURN_OFF_STATS_MENU")
  util.Hide("XPandHS")
end
function SkillTree:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function SkillTree:Enter()
  PlayUniqueMenuScreenSound("skillTreeMenu")
  self:SendEventToUIFsm("skillTreeMenu", "EVT_TURN_ON_SKILL_TREE_MENU", self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
  util.Show("XPandHS")
end
function SkillTree:Exit()
  StopUniqueMenuScreenSound("skillTreeMenu")
  self:SendEventToUIFsm("skillTreeMenu", "EVT_TURN_OFF_SKILL_TREE_MENU")
  util.Hide("XPandHS")
end
function Quests:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function Quests:Enter()
  PlayUniqueMenuScreenSound("questsMenu")
  self:SendEventToUIFsm("questsMenu", "EVT_TURN_ON_QUESTS_MENU", self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
  util.Show("XPandHS")
end
function Quests:Exit()
  StopUniqueMenuScreenSound("questsMenu")
  self:SendEventToUIFsm("questsMenu", "EVT_TURN_OFF_QUESTS_MENU")
  util.Hide("XPandHS")
end
function Journal:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function Journal:Enter()
  PlayUniqueMenuScreenSound("journalMenu")
  self:SendEventToUIFsm("journalMenu", "EVT_TURN_ON_JOURNAL_MENU", self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
  util.Show("XPandHS")
end
function Journal:Exit()
  StopUniqueMenuScreenSound("journalMenu")
  self:SendEventToUIFsm("journalMenu", "EVT_TURN_OFF_JOURNAL_MENU")
  util.Hide("XPandHS")
end
function Map:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function Map:Enter()
  PlayUniqueMenuScreenSound("mapMenu")
  self:SendEventToUIFsm("mapMenu", "EVT_TURN_ON_MAP_MENU", self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
end
function Map:Exit()
  StopUniqueMenuScreenSound("mapMenu")
  self:SendEventToUIFsm("mapMenu", "EVT_TURN_OFF_MAP_MENU")
  util.Hide("XPandHS")
end
function Resources:Setup()
  self.menuOn = self:GetState("MenuOn")
end
function Resources:Enter()
  PlayUniqueMenuScreenSound("resourcesMenu")
  self:SendEventToUIFsm("resourcesMenu", "EVT_TURN_ON_RESOURCES_MENU", self.menuOn.menu:get_instructionEntries(), self.menuOn.menu:get_instructionArgs())
  util.Show("XPandHS")
end
function Resources:Exit()
  self:SendEventToUIFsm("resourcesMenu", "EVT_TURN_OFF_RESOURCES_MENU")
  StopUniqueMenuScreenSound("resourcesMenu")
  util.Hide("XPandHS")
end
function InWorldMenu:OnSaveCheckpoint(tab)
end
function InWorldMenu:OnRestoreCheckpoint(tab)
end
