local classlib = require("core.class")
local fsm = require("ui.fsm")
local util = require("ui.util")
local UI = game.UI
local FadeBlack = classlib.Class("FadeBlack", fsm.UIState)
local FadeOff = FadeBlack:StateClass("FadeOff", fsm.UIState)
local FadeIdle = FadeBlack:StateClass("FadeIdle", fsm.UIState)
local FadeOn = FadeBlack:StateClass("FadeOn", fsm.UIState)
local fadeBlack = FadeBlack.New("fadeBlack", {
  FadeOff,
  FadeIdle,
  FadeOn
})
function FadeBlack:Enter()
  self:Goto("FadeIdle")
end
FadeBlack.EVT_Restart = FadeBlack.Enter
FadeBlack.EVT_GAME_START = FadeBlack.Enter
local defaultTimer = 3
function FadeOff:Enter()
end
function FadeIdle:Enter()
end
function FadeIdle:EVT_FADE_OUT(time)
  if time == nil then
    UI.FadeOut(0, 0, 0, defaultTimer)
  else
    UI.FadeOut(0, 0, 0, time)
  end
  self:Goto("FadeOn")
end
function FadeOn:Enter()
end
function FadeOn:EVT_FADE_IN(time)
  if time == nil then
    UI.FadeIn(defaultTimer)
  else
    UI.FadeIn(time)
  end
  self:Goto("FadeIdle")
end
function FadeBlack:OnSaveCheckpoint(tab)
end
function FadeBlack:OnRestoreCheckpoint(tab)
end
