local lamsConsts = require("ui.lamsConsts")
local pickupConsts = require("ui.pickupConsts")
local resourceConsts = require("ui.resourceConsts")
local tutorialConsts = require("ui.tutorialConsts")
local tutorialUtil = require("ui.tutorialUtil")
local uiCalls = require("ui.uicalls")
local util = require("ui.util")
local tutorials = {}
tutorials.DesaturationTest = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = "LEG ARMOR?",
      BodyMessage = [=[
Testing out different desaturation.

[AdvanceButton] [TriangleButton]]=],
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_LARGE,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {
        pickupConsts.Slot_ArmorLegs
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = "LEG ARMOR?",
      BodyMessage = "Presss [BackButton] to exit and return back to the game.",
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "",
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Back_Release"
    }),
    ConditionArgs = tutorialUtil.OnBackReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {}
    },
    EventHandler = function()
      uiCalls.UI_Event_SendTutorialMessage("This is to test going back to the game.", uiCalls.msgParam.ADVANCE_PRESS, {
        tutorialHeaderText = "YOU WENT BACK TO THE GAME!",
        time = 0.5,
        FooterButtonInfo = tutorialUtil.CreateFooterButtonInfoTable("[AdvanceButton] Continue", {
          "EVT_Advance_Release"
        }, nil)
      })
    end
  }
}
tutorials.Pause_RunicAttackGem = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40851, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_LARGE,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -0.5),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-2.3, -0.5),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40852, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Down_Press",
      "EVT_LeftStick_Down",
      "EVT_MOUSE_HOVER"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus(pickupConsts.Slot_WeaponSpecial_Light),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {
        pickupConsts.Slot_WeaponSpecial_Light
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -0.5),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-2.3, -0.5),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40853, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(pickupConsts.Slot_WeaponSpecial_Light),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {
        pickupConsts.Slot_WeaponSpecial_Light
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.8, 0.5),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 0.5),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40854, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Axe_" .. pickupConsts.Slot_WeaponSpecial_Light
      },
      Items = {
        pickupConsts.Slot_WeaponSpecial_Light
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.56, 0.9),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.26, 0.9),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40855, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Weapon_Gem_Info_Card_LeftGroup"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0.4, -0.3),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.4, -0.3),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40857, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Weapon_Gem_Info_Card_RightGroup",
        "XPandHS"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.8, 0.5),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 0.5),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40858, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {
        "FrostSpecialAxeQuickClear"
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.8, 0.5),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 0.5),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40859, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Back_Release"
    }),
    ConditionArgs = tutorialUtil.OnBackReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {
        "Axe_MainList",
        "Axe_" .. pickupConsts.Slot_WeaponSpecial_Light
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -0.9),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-2.3, -0.9),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40860, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Down_Press",
      "EVT_LeftStick_Down",
      "EVT_MOUSE_HOVER"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus(pickupConsts.Slot_WeaponSpecial_Heavy),
    ResaturateTable = {
      GameObjectNames = {
        "Axe_MainList"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -3.3),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-2.3, -3.3),
      HeaderMessage = util.GetLAMSMsg(40863, nil),
      BodyMessage = util.GetLAMSMsg(40861, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {
        "WeaponSpecial_Heavy"
      }
    },
    EventHandler = function()
      uiCalls.UI_Global_Menu_Clear_Exclusive_Access("GlobalInWorldMenu")
    end
  }
}
tutorials.Pause_Enchantments = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-3.3, 1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-1.3, 1),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44286, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "StatsKratos_MainList"
      },
      Items = {
        "StatsKratos",
        pickupConsts.Slot_ArmorChest,
        pickupConsts.Slot_ArmorLegs,
        pickupConsts.Slot_ArmorWaist,
        pickupConsts.Slot_ArmorTrinket
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.4, 0.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.2, 0),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44287, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "StatsKratos_MainList",
        "Upgrade_Stats_Card"
      },
      Items = {
        "StatsKratos",
        pickupConsts.Slot_ArmorChest,
        pickupConsts.Slot_ArmorLegs,
        pickupConsts.Slot_ArmorWaist,
        pickupConsts.Slot_ArmorTrinket
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.4, 0.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.2, 0),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44288, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Square_Release"
    }),
    ConditionArgs = tutorialUtil.OnSquareReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {
        "Stats_Stats_Card_socket1",
        "Stats_Stats_Card_buttonPromptGrp"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.4, 0.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.2, 0),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44289, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Down_Press",
      "EVT_LeftStick_Down",
      "EVT_MOUSE_HOVER"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus(0),
    ResaturateTable = {
      GameObjectNames = {
        "PickupUpgrade_MainList",
        "Upgrade_Stats_Card"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -0.8),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-2.3, -0.8),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44290, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(0),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {0}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.8, -1.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, -1.1),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44291, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_Down_Press",
      "EVT_LeftStick_Down",
      "EVT_Up_Press",
      "EVT_LeftStick_Up",
      "EVT_MOUSE_HOVER",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(0),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card",
        "Upgrade_Stats_Card",
        "PickupUpgrade_0"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.8, -1.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, -1.1),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44292, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card",
        "Upgrade_Stats_Card",
        "PickupUpgrade_0"
      },
      Items = {0}
    },
    EventHandler = nil
  }
}
tutorials.Pause_Enchantments_From_List = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -0.2),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44286, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "StatsKratos_" .. pickupConsts.Slot_ArmorChest,
        "StatsKratos_" .. pickupConsts.Slot_ArmorWrist,
        "StatsKratos_" .. pickupConsts.Slot_ArmorLegs,
        "StatsKratos_" .. pickupConsts.Slot_ArmorTrinket
      },
      Items = {
        pickupConsts.Slot_ArmorChest,
        pickupConsts.Slot_ArmorLegs,
        pickupConsts.Slot_ArmorWaist,
        pickupConsts.Slot_ArmorTrinket
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.5, 0.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.3, 0),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44287, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "StatsKratos_" .. pickupConsts.Slot_ArmorChest,
        "StatsKratos_" .. pickupConsts.Slot_ArmorWrist,
        "StatsKratos_" .. pickupConsts.Slot_ArmorLegs,
        "StatsKratos_" .. pickupConsts.Slot_ArmorTrinket,
        "Upgrade_Stats_Card"
      },
      Items = {
        pickupConsts.Slot_ArmorChest,
        pickupConsts.Slot_ArmorLegs,
        pickupConsts.Slot_ArmorWaist,
        pickupConsts.Slot_ArmorTrinket
      }
    }
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.5, 0.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.3, 0),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44288, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Square_Release"
    }),
    ConditionArgs = tutorialUtil.OnSquareReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {
        "Stats_Stats_Card_socket1",
        "Stats_Stats_Card_buttonPromptGrp"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, 0.7),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-1.8, 0.3),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44289, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Down_Press",
      "EVT_LeftStick_Down",
      "EVT_MOUSE_HOVER"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus(0),
    ResaturateTable = {
      GameObjectNames = {
        "PickupUpgrade_MainList",
        "Upgrade_Stats_Card"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -0.8),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-1.8, -0.6),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44290, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(0),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {0}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.9, -1.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, -1.1),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44291, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_Down_Press",
      "EVT_LeftStick_Down",
      "EVT_Up_Press",
      "EVT_LeftStick_Up",
      "EVT_MOUSE_HOVER",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(0),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card",
        "Upgrade_Stats_Card",
        "PickupUpgrade_0"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -1),
      HeaderMessage = util.GetLAMSMsg(44285, nil),
      BodyMessage = util.GetLAMSMsg(44292, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card",
        "Upgrade_Stats_Card",
        "PickupUpgrade_0"
      },
      Items = {0}
    },
    EventHandler = nil
  }
}
tutorials.Pause_UpgradeAvailable_Axe = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43230, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_UpgradeAvailable_Axe_Blades = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43230, nil) .. "\n" .. util.GetLAMSMsg(43229, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_UpgradeAvailable_Axe_Blades_SonBow = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43230, nil) .. "\n" .. util.GetLAMSMsg(43229, nil) .. "\n" .. util.GetLAMSMsg(43731, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_UpgradeAvailable_Axe_SonBow = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43230, nil) .. "\n" .. util.GetLAMSMsg(43731, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_UpgradeAvailable_Blades = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43229, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_UpgradeAvailable_Blades_SonBow = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43229, nil) .. "\n" .. util.GetLAMSMsg(43731, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_UpgradeAvailable_SonBow = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(43228, nil),
      BodyMessage = util.GetLAMSMsg(43731, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Pause_SpiritSummons = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-2.9, -0.8),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-2, -0.8),
      HeaderMessage = util.GetLAMSMsg(44320, nil),
      BodyMessage = util.GetLAMSMsg(44181, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {
        resourceConsts.RESOURCE_FLAG_WEAPON_SPECIAL_SON
      }
    },
    EventHandler = nil
  }
}
tutorials.Vendor_UpgradeWeapon = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 0),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44294, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Right_Press",
      "EVT_MOUSE_CLICKED"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus("Upgrade"),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {"Upgrade"}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 0),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44295, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {"Upgrade"}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.9, 2.3),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.7, 1.9),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44296, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled("Axe"),
    ResaturateTable = {
      GameObjectNames = {
        "VendorUpgrade_MainList"
      },
      Items = {"Upgrade"}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -0.9),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.8, -1.1),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44297, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard",
        "VendorUpgrade_SubList",
        "Attributes_Card_PowerLevelMeter",
        "Attributes_Card_PowerLevelPreviewArrow",
        "Attributes_Card_Attribute1"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1.9, 2.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.8, 2.1),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44298, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_L3_Release"
    }),
    ConditionArgs = tutorialUtil.OnL3ReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1.9, 2.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.8, 2.1),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(40856, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card_Attribute2"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1.9, -2.8),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.8, -2.8),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(40866, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card_Attribute6"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1.9, 2.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.8, 2.1),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44299, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_L3_Release"
    }),
    ConditionArgs = tutorialUtil.OnL3ReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {
        "Attributes_Card"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1.1, 0),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.9, -0.7),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44300, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard_IconGroup",
        "Vendor_StatsCard_Stat1",
        "Attributes_Card_Attribute1",
        "Attributes_Card_PowerLevelMeter",
        "Attributes_Card_PowerLevelPreviewArrow"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1.1, 0),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(0.9, -0.7),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44301, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard_Stat1",
        "Attributes_Card_Attribute1"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.5, -0.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.3, -0.1),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44302, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_RequirementsBox"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.5, -0.1),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.3, -0.1),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44303, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Square_Press",
      "EVT_Square_Release"
    }),
    ConditionArgs = tutorialUtil.OnSliderOnComplete("CardManager_HoldFillMeter"),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard",
        "Vendor_RequirementsBox"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateOffscreenOffset(),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = "This card should be offscreen.",
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnButtonGainFocus("Recipe_ReinforceAxe_Tier03"),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(7.5, 3),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(7.3, 3),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44304, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard",
        "Vendor_RequirementsBox",
        "VendorUpgrade_SubList"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -0.2),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44305, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Back_Release"
    }),
    ConditionArgs = tutorialUtil.OnBackReleaseHandled(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -0.2),
      HeaderMessage = util.GetLAMSMsg(44293, nil),
      BodyMessage = util.GetLAMSMsg(44306, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "",
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Left_Press",
      "EVT_MOUSE_CLICKED"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus("Craft"),
    ResaturateTable = {
      GameObjectNames = {
        "VendorUpgrade_SubList"
      },
      Items = {"Craft", "Upgrade"}
    },
    EventHandler = nil
  }
}
tutorials.Vendor_ResurrectionStone = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 0),
      HeaderMessage = util.GetLAMSMsg(44307, nil),
      BodyMessage = util.GetLAMSMsg(44308, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.9, 2.3),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 1.8),
      HeaderMessage = util.GetLAMSMsg(44307, nil),
      BodyMessage = util.GetLAMSMsg(44309, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Right_Press",
      "EVT_MOUSE_CLICKED"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus("Buy"),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {"Buy"}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.9, 2.3),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 1.8),
      HeaderMessage = util.GetLAMSMsg(44307, nil),
      BodyMessage = util.GetLAMSMsg(44310, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Advance_Release",
      "EVT_Down_Press",
      "EVT_Up_Press",
      "EVT_MOUSE_HOVER",
      "EVT_MOUSE_RELEASED"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceReleaseHandled(resourceConsts.RESOURCE_FLAG_RESURRECTION_STONE),
    ResaturateTable = {
      GameObjectNames = {
        "VendorBuy_MainList"
      },
      Items = {
        "ResurrectionStone"
      }
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 0),
      HeaderMessage = util.GetLAMSMsg(44307, nil),
      BodyMessage = util.GetLAMSMsg(44311, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "VendorCraft_MainList",
        "VendorUpgrade_SubList",
        "Vendor_StatsCard"
      },
      Items = {}
    },
    EventHandler = nil
  }
}
tutorials.Vendor_UpgradeArmor = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(44312, nil),
      BodyMessage = util.GetLAMSMsg(44313, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.9, 2.5),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 2.5),
      HeaderMessage = util.GetLAMSMsg(44314, nil),
      BodyMessage = util.GetLAMSMsg(44315, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = ""
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Right_Press",
      "EVT_MOUSE_CLICKED"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus("Upgrade"),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {"Upgrade"}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-1.9, 1.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-0.8, 1.2),
      HeaderMessage = util.GetLAMSMsg(44314, nil),
      BodyMessage = util.GetLAMSMsg(44316, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "VendorUpgrade_SubList"
      },
      Items = {"Upgrade"}
    },
    EventHandler = nil
  }
}
tutorials.Vendor_LostItems = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 0),
      HeaderMessage = util.GetLAMSMsg(44321, nil),
      BodyMessage = util.GetLAMSMsg(44322, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "",
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_Right_Press",
      "EVT_MOUSE_CLICKED"
    }),
    ConditionArgs = tutorialUtil.OnButtonGainFocus("LostItems"),
    ResaturateTable = {
      GameObjectNames = {},
      Items = {"LostItems"}
    },
    EventHandler = nil
  }
}
tutorials.Vendor_NGPItems = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, 1),
      HeaderMessage = util.GetLAMSMsg(44805, nil),
      BodyMessage = util.GetLAMSMsg(44806, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {"globalMenu"},
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  }
}
tutorials.Shared_AxePommelTutorial = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -3.4),
      HeaderMessage = util.GetLAMSMsg(44318, nil),
      BodyMessage = util.GetLAMSMsg(44319, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard",
        "Attributes_Card"
      },
      Items = {}
    },
    EventHandler = nil
  }
}
tutorials.Shared_Talisman = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(0, -2.9),
      HeaderMessage = util.GetLAMSMsg(42990, nil),
      BodyMessage = util.GetLAMSMsg(42991, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "Vendor_StatsCard",
        "Attributes_Card"
      },
      Items = {}
    },
    EventHandler = nil
  }
}
tutorials.MapFilterTutorial = {
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(1, 0),
      HeaderMessage = util.GetLAMSMsg(44380, nil),
      BodyMessage = util.GetLAMSMsg(44422, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({}),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "MapCursor",
        "MapCursorInfo"
      },
      Items = {}
    },
    EventHandler = nil,
    StartBlender = false
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(-9.4, -5.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(-7.4, -4.2),
      HeaderMessage = util.GetLAMSMsg(44380, nil),
      BodyMessage = util.GetLAMSMsg(44381, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue)
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_L2_Release",
      "EVT_R2_Release"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "MapSortList",
        "MapCursor",
        "MapCursorInfo"
      },
      Items = {}
    },
    EventHandler = nil
  },
  {
    MessageArgs = {
      CenterOffset = tutorialUtil.CreateCenterOffset(3.5, -5.2),
      ScaledCenterOffset = tutorialUtil.CreateCenterOffset(3.5, -4.2),
      HeaderMessage = util.GetLAMSMsg(44380, nil),
      BodyMessage = util.GetLAMSMsg(44382, nil),
      MessageType = uiCalls.msgParam.PAUSE_TUTORIAL_SMALL,
      FooterButtonText = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.Continue),
      UnpauseWhenComplete = true
    },
    AllowedEvents = tutorialUtil.ConvertAllowedEventsTable({
      "EVT_R3_Release"
    }),
    ConditionArgs = tutorialUtil.OnAdvanceRelease(),
    ResaturateTable = {
      GameObjectNames = {
        "globalMenu",
        "MapCursorInfo",
        "MapCursorInfo"
      },
      Items = {}
    },
    EventHandler = nil
  }
}
return tutorials
