local UI = game.UI
local GetCategories = function()
  return UI.GetBestiaryCategories()
end
local Categories_GetBestiaryCategoryEntries = function(category)
  assert(category ~= nil, "Attempted to call GetBestiaryEntry with nil category!")
  return UI.GetBestiaryEntriesForCategory(category)
end
local BestiaryCategoryEntry_GetEntryNameHash = function(bestiaryCategoryEntry)
  return bestiaryCategoryEntry.Hash
end
local BestiaryCategoryEntry_GetDisplayNameLamsID = function(bestiaryCategoryEntry)
  return bestiaryCategoryEntry.Name
end
local BestiaryCategoryEntry_HasEntryNameHash = function(bestiaryCategoryEntry, bestiaryEntryNameHash)
  return bestiaryCategoryEntry.Hash == bestiaryEntryNameHash
end
local GetBestiaryEntry = function(entryNameHash)
  assert(entryNameHash ~= nil, "Attempted to call GetBestiaryEntry with nil entryNameHash!")
  return UI.GetBestiaryEntry(entryNameHash)
end
local BestiaryEntry_GetDisplayNameLamsID = function(bestiaryEntry)
  return bestiaryEntry.Name
end
local BestiaryEntry_GetDescriptionLamsID = function(bestiaryEntry)
  return bestiaryEntry.Description
end
local BestiaryEntry_GetMaterialSwap = function(bestiaryEntry)
  return bestiaryEntry.MaterialSwap
end
local BestiaryEntry_GetLockingResource = function(bestiaryEntry)
  return bestiaryEntry.LockingResource
end
local BestiaryEntry_GetWeaknesses = function(bestiaryEntry)
  return bestiaryEntry.Weaknesses
end
local BestiaryEntryWeakness_GetDescriptionLamsID = function(bestiaryEntry, index)
  local descriptionLamsID
  local weaknesses = BestiaryEntry_GetWeaknesses(bestiaryEntry)
  if weaknesses ~= nil then
    descriptionLamsID = weaknesses[index]
  end
  return descriptionLamsID
end
return {
  GetCategories = GetCategories,
  Categories_GetBestiaryCategoryEntries = Categories_GetBestiaryCategoryEntries,
  BestiaryCategoryEntry_GetEntryNameHash = BestiaryCategoryEntry_GetEntryNameHash,
  BestiaryCategoryEntry_GetDisplayNameLamsID = BestiaryCategoryEntry_GetDisplayNameLamsID,
  BestiaryCategoryEntry_HasEntryNameHash = BestiaryCategoryEntry_HasEntryNameHash,
  GetBestiaryEntry = GetBestiaryEntry,
  BestiaryEntry_GetDisplayNameLamsID = BestiaryEntry_GetDisplayNameLamsID,
  BestiaryEntry_GetDescriptionLamsID = BestiaryEntry_GetDescriptionLamsID,
  BestiaryEntry_GetMaterialSwap = BestiaryEntry_GetMaterialSwap,
  BestiaryEntry_GetLockingResource = BestiaryEntry_GetLockingResource,
  BestiaryEntry_GetWeaknesses = BestiaryEntry_GetWeaknesses,
  BestiaryEntryWeakness_GetDescriptionLamsID = BestiaryEntryWeakness_GetDescriptionLamsID
}
