local pickupConsts = require("ui.pickupConsts")
local pickupUtil = require("ui.pickupUtil")
local util = require("ui.util")
local pickupSlots = {
  [pickupConsts.TAG_PICKUP_KRATOS] = {
    pickupConsts.Slot_PrimaryWeapon,
    pickupConsts.Slot_Blades,
    pickupConsts.Slot_WeaponComponent,
    pickupConsts.Slot_WeaponComponent_Blades,
    pickupConsts.Slot_WeaponSpecial_Light,
    pickupConsts.Slot_WeaponSpecial_Heavy,
    pickupConsts.Slot_WeaponSpecial_Blades_Light,
    pickupConsts.Slot_WeaponSpecial_Blades_Heavy,
    pickupConsts.Slot_SonSpecial,
    pickupConsts.Slot_ArmorChest,
    pickupConsts.Slot_ArmorLegs,
    pickupConsts.Slot_ArmorWrist,
    pickupConsts.Slot_ArmorTrinket
  },
  [pickupConsts.TAG_PICKUP_SON] = {
    pickupConsts.Slot_PrimaryWeapon,
    pickupConsts.Slot_SonArmor
  }
}
local pickupSlotsEquipped = {
  [pickupConsts.TAG_PICKUP_KRATOS] = {},
  [pickupConsts.TAG_PICKUP_SON] = {}
}
local ClearPickupSlotsOnCharacter = function(character)
  local pickupSlotsForCharacter = pickupSlots[character]
  for _, pickupSlotName in ipairs(pickupSlotsForCharacter) do
    pickupSlotsEquipped[character][pickupSlotName] = nil
  end
end
local SetPickupSlot = function(character, slot, pickupName, acquirePickup, fromMenu)
  assert(character == pickupConsts.TAG_PICKUP_KRATOS or character == pickupConsts.TAG_PICKUP_SON)
  if pickupName == nil then
    pickupName = ""
  end
  pickupSlotsEquipped[character][slot] = pickupName
  if acquirePickup then
    local creature = pickupUtil.GetCreatureFromCharacter(character)
    local stage = pickupUtil.GetProfileStage(pickupName)
    pickupUtil.PickupAcquire(creature, pickupName, stage, fromMenu)
  end
end
local InitializePickupSlotsOnCharacter = function(character)
  local pickupSlotsForCharacter = pickupSlots[character]
  local pickupSlotsOnCharacter = pickupSlotsEquipped[character]
  local creature = pickupUtil.GetCreatureFromCharacter(character)
  for _, pickupSlotName in ipairs(pickupSlotsForCharacter) do
    local pickupName = pickupUtil.GetPickupNameInSlot(creature, pickupSlotName)
    SetPickupSlot(character, pickupSlotName, pickupName)
  end
end
local ApplyPickupsToCharacter = function(character)
  assert(character == pickupConsts.TAG_PICKUP_KRATOS or character == pickupConsts.TAG_PICKUP_SON)
  local creature = pickupUtil.GetCreatureFromCharacter(character)
  local fromMenu = true
  local creatureUI = pickupUtil.GetUICreature(character)
  for slotName, pickupName in pairs(pickupSlotsEquipped[character]) do
    if pickupName ~= "" then
      local stage = pickupUtil.GetProfileStage(pickupName)
      pickupUtil.PickupAcquire(creature, pickupName, stage, fromMenu)
      pickupUtil.UpdateSlotOnUICreature(slotName, pickupName, stage, creature, character)
    else
      if pickupUtil.GetPickupNameInSlot(creature, slotName) ~= nil then
        creature:PickupRelinquishBySlot(slotName)
      end
      if pickupUtil.GetPickupNameInSlot(creatureUI, slotName) ~= nil then
        creatureUI:PickupRelinquishBySlot(slotName)
      end
    end
  end
end
local ApplyAllPickupChanges = function()
  ApplyPickupsToCharacter(pickupConsts.TAG_PICKUP_KRATOS)
  ApplyPickupsToCharacter(pickupConsts.TAG_PICKUP_SON)
end
local ItemIsEquipped = function(pickupName)
  for _, characterSlots in ipairs(pickupSlotsEquipped) do
    for _, pickup in pairs(characterSlots) do
      if pickupName == pickup then
        return true
      end
    end
  end
  return false
end
local GetPickupInSlot = function(character, pickupSlot)
  local pickupName = pickupSlotsEquipped[character][pickupSlot]
  if pickupName ~= "" then
    return pickupName
  else
    return nil
  end
end
local InitializePickupSlots = function()
  InitializePickupSlotsOnCharacter(pickupConsts.TAG_PICKUP_KRATOS)
  if util.SonUI_ShouldShow() then
    InitializePickupSlotsOnCharacter(pickupConsts.TAG_PICKUP_SON)
  else
    ClearPickupSlotsOnCharacter(pickupConsts.TAG_PICKUP_SON)
  end
end
return {
  SetPickupSlot = SetPickupSlot,
  InitializePickupSlots = InitializePickupSlots,
  GetPickupInSlot = GetPickupInSlot,
  ApplyAllPickupChanges = ApplyAllPickupChanges,
  ItemIsEquipped = ItemIsEquipped
}
