local tablex = require("core.tablex")
local consts = require("ui.consts")
local colors = require("ui.colors")
local lamsIDs = require("ui.lamsConsts")
local util = require("ui.util")
local resourceUtil = require("ui.resourceUtil")
local pickupConsts = require("ui.pickupConsts")
local UI = game.UI
local AllButtonTable = function()
  return {
    L2Button = {
      macro = "AimButton",
      DefaultLamsKey = "Aim",
      buttonMacro = "L2Button",
      tweak = tweaks.ePad.kPadL2
    },
    R2Button = {
      macro = "HeavyAttackButton",
      DefaultLamsKey = "HeavyAttack",
      buttonMacro = "R2Button",
      tweak = tweaks.ePad.kPadR2
    },
    L1Button = {
      macro = "BlockButton",
      DefaultLamsKey = "BlockParry",
      buttonMacro = "L1Button",
      tweak = tweaks.ePad.kPadL1
    },
    R1Button = {
      macro = "LightAttackButton",
      DefaultLamsKey = "LightAttack",
      buttonMacro = "R1Button",
      tweak = tweaks.ePad.kPadR1
    },
    TriangleButton = {
      macro = "AxeRecallButton",
      DefaultLamsKey = "AxeRecall",
      buttonMacro = "TriangleButton",
      tweak = tweaks.ePad.kPadTriangle
    },
    CircleButton = {
      macro = "InteractButton",
      DefaultLamsKey = "Interact",
      buttonMacro = "CircleButton",
      tweak = tweaks.ePad.kPadCircle
    },
    XButton = {
      macro = "EvadeButton",
      DefaultLamsKey = "Evade",
      buttonMacro = "XButton",
      tweak = tweaks.ePad.kPadCross
    },
    SquareButton = {
      macro = "SonActionButton",
      DefaultLamsKey = "SonAction",
      buttonMacro = "SquareButton",
      tweak = tweaks.ePad.kPadSquare
    }
  }
end
local FindDefaultsForButton = function(button)
  for _, data in pairs(AllButtonTable()) do
    if data.tweak == button then
      return data
    end
  end
end
local GetLamsForButton = function(button)
  local buttonTweak = AllButtonTable()[button].tweak
  local mappedButton = game.GetCurrentControlOnButton(buttonTweak)
  local buttonData = FindDefaultsForButton(mappedButton)
  if buttonData ~= nil then
    return buttonData.DefaultLamsKey
  end
end
local GetButtonForControl = function(control)
  local buttonTable = AllButtonTable()
  local controlPad
  for pad, data in pairs(buttonTable) do
    if control == data.macro then
      controlPad = pad
    end
  end
  if controlPad ~= nil then
    return game.GetCurrentButtonForControl(controlPad)
  end
end
local GetButtonTextString = function(args)
  local lamsData = GetLamsForButton(args.button)
  local text = util.GetLAMSMsg(lamsIDs[lamsData])
  if args.left_align then
    text = "[" .. args.button .. "] " .. text
  else
    text = text .. " [" .. args.button .. "]"
  end
  return text
end
local UpdateDpadButtons = function(th, quickturn)
  local text = ""
  if resourceUtil.HasResource("ArrowUnlock_Shock") then
    text = util.GetLAMSMsg(lamsIDs.ArrowType) .. " [UpButton]\n"
  end
  if resourceUtil.HasResource(pickupConsts.Blades) then
    text = text .. util.GetLAMSMsg(lamsIDs.RecipesAxe) .. " [RightButton]\n" .. util.GetLAMSMsg(lamsIDs.RecipesBlades) .. " [LeftButton]"
  else
    text = text .. util.GetLAMSMsg(lamsIDs.SheatheUnsheathe) .. " [RightButton]"
  end
  if quickturn then
    text = text .. "\n" .. util.GetLAMSMsg(lamsIDs.QuickTurnConfig) .. " [DownButton]"
  end
  UI.SetText(th, text)
end
local UpdateJoyLButtons = function(th, quickturn, sprint)
  local text = util.GetLAMSMsg(lamsIDs.Move) .. " [JoystickL]"
  if sprint then
    text = text .. "\n" .. util.GetLAMSMsg(lamsIDs.Sprint) .. " [L3]"
  end
  if quickturn then
    text = text .. "\n" .. util.GetLAMSMsg(lamsIDs.QuickTurnConfig) .. " [JoystickL]+[L3]"
  end
  UI.SetText(th, text)
end
local UpdateJoyRButtons = function(th, lockon)
  local text = "[JoystickR] " .. util.GetLAMSMsg(lamsIDs.CameraHeader)
  if lockon then
    text = text .. "\n" .. "[R3] " .. util.GetLAMSMsg(lamsIDs.LockOnController)
  end
  UI.SetText(th, text)
end
local UpdateAllFaceButtons = function(th, quickturn, sprint)
  local text = GetButtonTextString({
    button = "SquareButton",
    left_align = true
  }) .. "\n" .. GetButtonTextString({
    button = "TriangleButton",
    left_align = true
  }) .. "\n" .. GetButtonTextString({
    button = "CircleButton",
    left_align = true
  }) .. "\n" .. GetButtonTextString({button = "XButton", left_align = true})
  if quickturn then
    text = text .. "\n" .. "[SquareButton]+[TriangleButton] " .. util.GetLAMSMsg(lamsIDs.QuickTurnConfig)
  end
  if sprint then
    text = text .. "\n" .. "[EvadeButton] " .. util.GetLAMSMsg(lamsIDs.HoldToSprint)
  end
  UI.SetText(th, text)
end
local UpdateFaceButtonText = function(th, buttons)
  local text = GetButtonTextString({
    button = buttons[1],
    left_align = true
  }) .. "\n" .. GetButtonTextString({
    button = buttons[2],
    left_align = true
  })
  UI.SetText(th, text)
end
local UpdateButton = function(args)
  local text = GetButtonTextString(args)
  UI.SetText(args.th, text)
end
return {
  FindDefaultsForButton = FindDefaultsForButton,
  AllButtonTable = AllButtonTable,
  GetLamsForButton = GetLamsForButton,
  GetButtonForControl = GetButtonForControl,
  UpdateButton = UpdateButton,
  UpdateAllFaceButtons = UpdateAllFaceButtons,
  UpdateDpadButtons = UpdateDpadButtons,
  UpdateJoyLButtons = UpdateJoyLButtons,
  UpdateJoyRButtons = UpdateJoyRButtons,
  GetButtonTextString = GetButtonTextString,
  UpdateFaceButtonText = UpdateFaceButtonText
}
