local tablex = require("core.tablex")
local consts = require("ui.consts")
local colors = require("ui.colors")
local lamsIDs = require("ui.lamsConsts")
local util = require("ui.util")
local UI = game.UI
local GetSaveSlotIndex = function(saveData)
  return saveData.slot
end
local IsAutoSaveSlot = function(saveData)
  return saveData.autoSave
end
local IsImpossibleSaveSlot = function(saveData)
  if saveData.difficulty == 3 then
    return true
  end
  return false
end
local GetSaveSlotSaveTime = function(saveData)
  return saveData.dateTime
end
local GetSaveSlotSaveTimeString = function(saveData)
  return tostring(saveData.dateTimeString)
end
local GetSaveSlotDifficulty = function(saveData)
  return saveData.difficulty
end
local GetSaveSlotDifficultyString = function(saveData)
  return tostring(saveData.difficultyString)
end
local GetSaveSlotPlayTime = function(saveData)
  return saveData.playTime
end
local GetSaveSlotNewGamePlus = function(saveData)
  return saveData.newGamePlus
end
local GetSaveSlotPlayTimeString = function(saveData)
  return tostring(saveData.playTimeString)
end
local GetSaveSlotPlayGo = function(saveData)
  return saveData.PlayGo
end
local GetSaveSlotRealm = function(saveData)
  return util.GetLAMSMsg(saveData.realmLams)
end
local GetSaveSlotRegion = function(saveData)
  return util.GetLAMSMsg(saveData.regionLams)
end
local GetSaveSlotQuest = function(saveData)
  return util.GetLAMSMsg(saveData.questLams)
end
local GetSaveSlotImage = function(saveData)
  return saveData.imageID
end
local GetSaveSlotDisplayOrder = function(saveData)
  return saveData.order
end
local realmLookup = {
  "Midgard",
  "Muspelheim",
  "Niflheim",
  "Asgard",
  "Svartalfheim",
  "Helheim",
  "Alfheim",
  "Jotunheim"
}
local regionLookup = {
  CalderaLake = {
    lamsIDs.CalderaTemple_Region,
    lamsIDs.CalderaShores_Region,
    lamsIDs.Caldera_Airlock_Region,
    lamsIDs.Caldera_JotunheimTower_Region,
    lamsIDs.Caldera_Lake_Region,
    lamsIDs.Caldera_OdinLibrary_Region,
    lamsIDs.Caldera_RuneVault_Region,
    lamsIDs.Caldera_RuneVaultEntrance_Region,
    lamsIDs.Caldera_SnakeBelly_Region,
    lamsIDs.Caldera_TempleExterior_Region,
    lamsIDs.CalderaTempleflip_Region,
    lamsIDs.Caldera_FD_Load_Region,
    lamsIDs.Caldera_HSHLoad_Region,
    lamsIDs.Caldera_HTTKLoad_Region,
    lamsIDs.Caldera_Huldra2Load_Region,
    lamsIDs.Caldera_HuldraLoad_Region,
    lamsIDs.Caldera_VF_Load_Region,
    lamsIDs.Caldera_RiverpassLoad_Region,
    lamsIDs.BeachCave_Region,
    lamsIDs.BeachTower_Region,
    lamsIDs.BeachRuins_Region,
    lamsIDs.BeachWaterfall_Region,
    lamsIDs.BeachMaze_Region,
    lamsIDs.BeachShipwreck_Region,
    lamsIDs.ForestDungeon_Region,
    lamsIDs.HuldraMine01_Region,
    lamsIDs.HuldraMine02_Region,
    lamsIDs.HuldraStrongHold_Region,
    lamsIDs.HTTK_Region,
    lamsIDs.IslandArch_Region,
    lamsIDs.IslandClimb_Region,
    lamsIDs.IslandShipwreck_Region,
    lamsIDs.MasonTrail_Region,
    lamsIDs.StoneMasonConnector_Region,
    lamsIDs.VikingFuneral_Region
  },
  Foothills = {
    lamsIDs.Foothills_Region,
    lamsIDs.Foothills_Arena_Region,
    lamsIDs.Foothills_Chisel_Region
  },
  Forest = {
    lamsIDs.Forest_Region,
    lamsIDs.Forest_Chisel_Region
  },
  PeaksPass = {
    lamsIDs.Peakspass_Region,
    lamsIDs.Peakspass_Summit_Region,
    lamsIDs.Peakspass_Chimney_Region,
    lamsIDs.Peakspass_ChiselDungeon_Region
  },
  RiverPass = {
    lamsIDs.Riverpass_Region,
    lamsIDs.Riverpass_Grove_Region,
    lamsIDs.Riverpass_Dangers_Region,
    lamsIDs.Riverpass_ChiselDungeon_Region,
    lamsIDs.Riverpass_FreyaCavern_Region
  },
  StoneMason = {
    lamsIDs.StoneMason_Region,
    lamsIDs.Stonemason_ChasmRoom_Region,
    lamsIDs.Stonemason_Chisel_Region,
    lamsIDs.Stonemason_ChiselDungeon_Region,
    lamsIDs.Stonemason_BanditCamp_Region,
    lamsIDs.Stonemason_Entrance_Region,
    lamsIDs.Stonemason_HammerHead_Region
  },
  Muspelheim = {
    lamsIDs.Muspelheim
  },
  Niflheim = {
    lamsIDs.Niflheim
  }
}
local GetSaveSlotImageMaterial = function(saveData)
  return saveData.MaterialSwap
end
local FindSaveSlotImageMaterial = function(saveData)
  local material_swap = ""
  local imageID = GetSaveSlotImage(saveData)
  if imageID == 0 then
    local regionLamsID = saveData.regionLams
    local use_image = false
    for image, regions in pairs(regionLookup) do
      for _, lamsID in ipairs(regions) do
        if lamsID == regionLamsID then
          material_swap = image
          break
        end
      end
      if material_swap ~= "" then
        break
      end
    end
  else
    material_swap = realmLookup[imageID + 1]
  end
  if material_swap == "" then
    material_swap = "Forest"
  end
  return material_swap
end
local AreThereAnyUsedSaveSlots = function()
  local saveTable = UI.GetSaveGameInfo(false)
  if #saveTable == 0 then
    return false
  end
  return true
end
local GetSaveSlotDebugText = function(saveData)
  return GetSaveSlotRealm(saveData) .. "\t" .. GetSaveSlotRegion(saveData) .. "\t" .. GetSaveSlotQuest(saveData) .. "\t" .. GetSaveSlotSaveTimeString(saveData) .. "\t" .. GetSaveSlotDifficultyString(saveData)
end
local SetupEmptySlot = function(nextFreeSlot)
  local t = {
    realmLams = 0,
    regionLams = 0,
    questLams = 0,
    dateTimeString = "",
    difficultyString = "",
    slot = nextFreeSlot,
    empty = true,
    MaterialSwap = "gow_logo"
  }
  return t
end
local IsSaveDataEmpty = function(saveData)
  return saveData == nil or saveData.empty
end
local GetSaveSlots = function(manualOnly)
  local saveTable = UI.GetSaveGameInfo(manualOnly)
  for i, data in ipairs(saveTable) do
    local material_name = FindSaveSlotImageMaterial(data)
    saveTable[i].MaterialSwap = material_name
  end
  if manualOnly or #saveTable == 0 then
    local nextFreeSlot = UI.GetFreeManualSlot()
    if nextFreeSlot ~= -1 then
      local t = SetupEmptySlot(nextFreeSlot)
      table.insert(saveTable, 1, t)
    end
  end
  return saveTable
end
local SaveGame = function(saveData)
  local slotIndex = GetSaveSlotIndex(saveData)
  UI.MakeManualSaveGame(slotIndex)
end
local LoadGame = function(saveData)
  local slotIndex = GetSaveSlotIndex(saveData)
  UI.SetCurrentSlot(slotIndex)
  UI.LoadSaveGame()
end
local GetPlayerStateSoftSaveDisabledInNifleheim = function()
  local currentRealmIndex = game.Level.GetVariable("_GBL_CurrentRealm")
  local isInNifleheim = currentRealmIndex == 2 and true or false
  if game.World.IsPlayerStateSoftSaveDisabled ~= nil and isInNifleheim then
    return game.World.IsPlayerStateSoftSaveDisabled()
  end
  return false
end
return {
  GetSaveSlotIndex = GetSaveSlotIndex,
  IsAutoSaveSlot = IsAutoSaveSlot,
  IsImpossibleSaveSlot = IsImpossibleSaveSlot,
  GetSaveSlotSaveTime = GetSaveSlotSaveTime,
  GetSaveSlotSaveTimeString = GetSaveSlotSaveTimeString,
  GetSaveSlotDifficulty = GetSaveSlotDifficulty,
  GetSaveSlotDifficultyString = GetSaveSlotDifficultyString,
  GetSaveSlotPlayTime = GetSaveSlotPlayTime,
  GetSaveSlotPlayTimeString = GetSaveSlotPlayTimeString,
  GetSaveSlotPlayGo = GetSaveSlotPlayGo,
  GetSaveSlotRealm = GetSaveSlotRealm,
  GetSaveSlotRegion = GetSaveSlotRegion,
  GetSaveSlotQuest = GetSaveSlotQuest,
  GetSaveSlotImage = GetSaveSlotImage,
  GetSaveSlotDisplayOrder = GetSaveSlotDisplayOrder,
  GetSaveSlotNewGamePlus = GetSaveSlotNewGamePlus,
  GetSaveSlotImageMaterial = GetSaveSlotImageMaterial,
  FindSaveSlotImageMaterial = FindSaveSlotImageMaterial,
  AreThereAnyUsedSaveSlots = AreThereAnyUsedSaveSlots,
  GetSaveSlotDebugText = GetSaveSlotDebugText,
  SetupEmptySlot = SetupEmptySlot,
  IsSaveDataEmpty = IsSaveDataEmpty,
  GetSaveSlots = GetSaveSlots,
  SaveGame = SaveGame,
  LoadGame = LoadGame,
  GetPlayerStateSoftSaveDisabledInNifleheim = GetPlayerStateSoftSaveDisabledInNifleheim
}
