local classlib = require("core.class")
local fsm = require("ui.fsm")
local lamsConsts = require("ui.lamsConsts")
local menu = require("ui.menu")
local util = require("ui.util")
local UI = game.UI
local RealmTableMenu = classlib.Class("RealmTableMenu", fsm.UIState)
local RealmTableOff = RealmTableMenu:StateClass("RealmTableOff", fsm.UIState)
local RealmTableOn = RealmTableMenu:StateClass("RealmTableOn", fsm.UIState)
local realmTableMenu = RealmTableMenu.New("realmTableMenu", {RealmTableOff, RealmTableOn})
function RealmTableMenu:Setup()
end
function RealmTableMenu:Enter()
  self:WantPadEvents(true)
  self:Goto("RealmTableOff")
end
RealmTableMenu.EVT_GAME_OVER = RealmTableMenu.Enter
RealmTableMenu.EVT_Restart = RealmTableMenu.Enter
function RealmTableMenu:EVT_DM_PAUSE()
  self:WantPadEvents(false)
end
function RealmTableMenu:EVT_DM_UNPAUSE()
  self:WantPadEvents(true)
end
function RealmTableOff:Setup()
  self.realmTableOn = self:GetState("RealmTableOn")
end
function RealmTableOff:Enter()
  self:SendEventUI("EVT_REALM_TABLE_MENU_CLOSED")
end
function RealmTableOff:Exit()
end
function RealmTableOff:EVT_TURN_ON_REALM_TABLE_MENU(selectedRealmInfo, instructionEntries, intructionArgs)
  self.realmTableOn.selectedRealmInfo = selectedRealmInfo
  self:Goto("RealmTableOn")
end
function RealmTableOn:Setup()
  self.selectedRealmInfo = nil
  self.exitAllowed = nil
  self.menu = menu.Menu.New(self, {
    FooterButtonInfo = {
      {
        Item = "ChangeRealm",
        Text = "[JoystickLX] " .. util.GetLAMSMsg(lamsConsts.ChangeRealm)
      },
      {
        Item = "TravelToRealm",
        Text = "[AdvanceButton] " .. util.GetLAMSMsg(lamsConsts.TravelToRealm)
      },
      {
        Item = "ReturnToMidgard",
        Text = "[TriangleButton] " .. util.GetLAMSMsg(lamsConsts.ReturnToMidgard)
      },
      {
        Item = "Exit",
        Text = "[BackButton] " .. util.GetLAMSMsg(lamsConsts.Exit)
      }
    }
  })
  self.goRealmTableMenu = util.GetUiObjByName("realmTableMenu")
  self.goRealmTravelTableMessage = self.goRealmTableMenu:FindSingleGOByName("realmTravelTableMessage")
  self.goRealmTravelTableMessageChild = self.goRealmTravelTableMessage:FindSingleGOByName("message")
  self.thRealmName = util.GetTextHandle(self.goRealmTravelTableMessageChild, "RealmName")
  self.thRealmStatus = util.GetTextHandle(self.goRealmTravelTableMessageChild, "RealmStatus")
  self.thRealmDesc = util.GetTextHandle(self.goRealmTravelTableMessageChild, "RealmDescription")
end
function RealmTableOn:Enter()
  self.menu:Activate()
  self.exitAllowed = true
  self.menu._updateFooterText = true
  self:UpdateInfo(self.selectedRealmInfo)
  self.goRealmTableMenu:Show()
  self.goRealmTravelTableMessage:Show()
  self.goRealmTravelTableMessageChild:Show()
  util.Show("GlobalHeaderBacking")
end
function RealmTableOn:Exit()
  self.menu:Deactivate(true)
  self.exitAllowed = false
  util.Hide("GlobalHeaderBacking")
  self.goRealmTableMenu:Hide()
end
function RealmTableOn:UpdateFooterButtonPrompt(currMenu, canChangeRealm, canTravelToRealm, canReturnToMidgard, canExit)
  currMenu:UpdateFooterButton("ChangeRealm", canChangeRealm)
  currMenu:UpdateFooterButton("TravelToRealm", canTravelToRealm)
  currMenu:UpdateFooterButton("ReturnToMidgard", canReturnToMidgard)
  currMenu:UpdateFooterButton("Exit", canExit)
  currMenu:UpdateFooterButtonText()
end
function RealmTableOn:UpdateInfo(selectedRealmInfo)
  if selectedRealmInfo ~= nil then
    local currentRealmName = selectedRealmInfo.CurrrentRealmName
    local selectedRealmName = selectedRealmInfo.SelectedRealmName
    local canBeUnlocked = selectedRealmInfo.CanBeUnlocked
    local isUnlocked = selectedRealmInfo.IsUnlocked
    UI.SetText(self.thRealmName, util.GetLAMSMsg(lamsConsts[selectedRealmName]))
    UI.SetText(self.thRealmStatus, util.GetLAMSMsg(selectedRealmInfo.Status))
    UI.SetText(self.thRealmDesc, selectedRealmInfo.Desc == nil and "" or util.GetLAMSMsg(selectedRealmInfo.Desc))
    local canChangeRealm = selectedRealmInfo.EnableChangeRealm
    local canTravelToRealm = canBeUnlocked and isUnlocked and selectedRealmInfo.EnableConfirmRealm
    local canReturnToMidgard = currentRealmName ~= "Midgard" and selectedRealmInfo.EnableMidgardReturn
    local canExit = self.exitAllowed and selectedRealmInfo.EnableExit
    self:UpdateFooterButtonPrompt(self.menu, canChangeRealm, canTravelToRealm, canReturnToMidgard, canExit)
  else
    self:UpdateFooterButtonPrompt(self.menu, false, false, false, false)
  end
end
function RealmTableOn:EVT_TURN_OFF_REALM_TABLE_MENU()
  self:Goto("RealmTableOff")
end
function RealmTableOn:EVT_UPDATE_REALM_TABLE_MENU(selectedRealmInfo)
  self.selectedRealmInfo = selectedRealmInfo
  self:UpdateInfo(self.selectedRealmInfo)
end
function RealmTableOn:EVT_SET_EXIT_ALLOWED()
  self.exitAllowed = true
  self:UpdateInfo(self.selectedRealmInfo)
end
function RealmTableOn:EVT_SET_EXIT_NOT_ALLOWED()
  self.exitAllowed = false
  self:UpdateInfo(self.selectedRealmInfo)
end
function RealmTableMenu:OnSaveCheckpoint(tab)
end
function RealmTableMenu:OnRestoreCheckpoint(tab)
end
