/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.event.EGClientEvents;
import com.mcmoddev.golems.event.EGClientModEvents;
import com.mcmoddev.golems.event.EGForgeEvents;
import com.mcmoddev.golems.golem_models.GolemRenderSettings;
import com.mcmoddev.golems.golem_stats.GolemContainer;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import com.mcmoddev.golems.integration.TopDescriptionManager;
import com.mcmoddev.golems.network.SGolemContainerPacket;
import com.mcmoddev.golems.network.SGolemModelPacket;
import com.mcmoddev.golems.util.GenericJsonReloadListener;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="golems")
public class ExtraGolems {
    public static final String MODID = "golems";
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"golems");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("golems", "channel"), () -> "1", "1"::equals, "1"::equals);
    public static final GenericJsonReloadListener<GolemContainer> GOLEM_CONTAINERS = new GenericJsonReloadListener<GolemContainer>("golem_stats", GolemContainer.class, GolemContainer.CODEC, l -> l.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemContainerPacket((ResourceLocation)e.getKey(), (GolemContainer)c)))));
    public static final GenericJsonReloadListener<GolemRenderSettings> GOLEM_RENDER_SETTINGS = new GenericJsonReloadListener<GolemRenderSettings>("golem_models", GolemRenderSettings.class, GolemRenderSettings.CODEC, l -> l.getEntries().forEach(e -> ((Optional)e.getValue()).ifPresent(c -> CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SGolemModelPacket((ResourceLocation)e.getKey(), (GolemRenderSettings)c)))));

    public ExtraGolems() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        GolemBehaviors.init();
        this.registerCommonEvents();
        DistExecutor.runForDist(() -> () -> this.registerClientEvents(), () -> () -> this.registerServerEvents());
        EGConfig.setupConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, EGConfig.COMMON_CONFIG);
        LOGGER.info("golems:registerNetwork");
        int messageId = 0;
        CHANNEL.registerMessage(messageId++, SGolemContainerPacket.class, SGolemContainerPacket::toBytes, SGolemContainerPacket::fromBytes, SGolemContainerPacket::handlePacket, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(messageId++, SGolemModelPacket.class, SGolemModelPacket::toBytes, SGolemModelPacket::fromBytes, SGolemModelPacket::handlePacket, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            LOGGER.info("Extra Golems detected TheOneProbe, registering plugin now");
            InterModComms.sendTo((String)MODID, (String)"theoneprobe", (String)"getTheOneProbe", () -> new TopDescriptionManager.GetTheOneProbe());
        }
    }

    private int registerCommonEvents() {
        LOGGER.info("golems:registerEventHandlers");
        MinecraftForge.EVENT_BUS.register(EGForgeEvents.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(EGRegistry.class);
        return 0;
    }

    private int registerServerEvents() {
        return 1;
    }

    private int registerClientEvents() {
        MinecraftForge.EVENT_BUS.register(EGClientEvents.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(EGClientModEvents.class);
        EGClientEvents.addResources();
        return 2;
    }

    public static Optional<ResourceLocation> getGolemId(Block below1, Block below2, Block arm1, Block arm2) {
        ResourceLocation id = null;
        for (Map.Entry<ResourceLocation, Optional<GolemContainer>> entry : GOLEM_CONTAINERS.getEntries()) {
            if (!entry.getValue().isPresent() || !entry.getValue().get().matches(below1, below2, arm1, arm2)) continue;
            id = entry.getKey();
            break;
        }
        return Optional.ofNullable(id);
    }

    @Nullable
    public static GolemBase getGolem(World world, Block below1, Block below2, Block arm1, Block arm2) {
        Optional<ResourceLocation> id = ExtraGolems.getGolemId(below1, below2, arm1, arm2);
        if (id.isPresent()) {
            GolemBase entity = GolemBase.create(world, id.get());
            return entity;
        }
        return null;
    }
}

