/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.block.UtilityBlock;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GlowBlock
extends UtilityBlock {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.func_177719_a((String)"light", (int)0, (int)15);
    public static final int UPDATE_TICKS = 6;

    public GlowBlock(Material m, float defaultLight) {
        super(AbstractBlock.Properties.func_200945_a((Material)m).func_200944_c().func_235838_a_(state -> (Integer)state.func_177229_b((Property)LIGHT_LEVEL)), 6);
        int light = (int)(defaultLight * 15.0f);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(light)));
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        boolean hasLightGolem;
        AxisAlignedBB toCheck = new AxisAlignedBB(pos).func_186662_g(0.5);
        List list = worldIn.func_217357_a(GolemBase.class, toCheck);
        boolean bl = hasLightGolem = !list.isEmpty() && GlowBlock.hasLightGolem(list);
        if (hasLightGolem) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), this.tickRate);
        } else {
            this.remove((World)worldIn, state, pos, 3);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIGHT_LEVEL});
    }

    public static boolean hasLightGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.isProvidingLight()) continue;
            return true;
        }
        return false;
    }
}

