/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.entity.GolemBase;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class GolemHeadBlock
extends HorizontalBlock {
    public GolemHeadBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196625_cS));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        GolemHeadBlock.trySpawnGolem((Entity)placer, worldIn, pos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn instanceof World && GolemHeadBlock.trySpawnGolem(null, (World)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return stateIn;
    }

    public static boolean canDispenserPlace(IWorldReader world, BlockPos headPos) {
        Block blockBelow1 = world.func_180495_p(headPos.func_177979_c(1)).func_177230_c();
        Block blockBelow2 = world.func_180495_p(headPos.func_177979_c(2)).func_177230_c();
        Block blockArmNorth = world.func_180495_p(headPos.func_177979_c(1).func_177964_d(1)).func_177230_c();
        Block blockArmSouth = world.func_180495_p(headPos.func_177979_c(1).func_177970_e(1)).func_177230_c();
        Block blockArmEast = world.func_180495_p(headPos.func_177979_c(1).func_177965_g(1)).func_177230_c();
        Block blockArmWest = world.func_180495_p(headPos.func_177979_c(1).func_177985_f(1)).func_177230_c();
        if (GolemHeadBlock.doBlocksMatch(Blocks.field_196604_cC, blockBelow1, blockBelow2)) {
            return true;
        }
        if (GolemHeadBlock.doBlocksMatch(Blocks.field_150339_S, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth)) {
            return true;
        }
        if (GolemHeadBlock.doBlocksMatch(Blocks.field_150339_S, blockBelow1, blockBelow2, blockArmEast, blockArmWest)) {
            return true;
        }
        if (ExtraGolems.getGolemId(blockBelow1, blockBelow2, blockArmNorth, blockArmSouth).isPresent()) {
            return true;
        }
        return ExtraGolems.getGolemId(blockBelow1, blockBelow2, blockArmEast, blockArmWest).isPresent();
    }

    public static boolean trySpawnGolem(@Nullable Entity placer, World world, BlockPos headPos) {
        if (world.func_201670_d()) {
            return false;
        }
        BlockState stateBelow1 = world.func_180495_p(headPos.func_177979_c(1));
        BlockState stateBelow2 = world.func_180495_p(headPos.func_177979_c(2));
        BlockState stateArmNorth = world.func_180495_p(headPos.func_177979_c(1).func_177964_d(1));
        BlockState stateArmSouth = world.func_180495_p(headPos.func_177979_c(1).func_177970_e(1));
        BlockState stateArmEast = world.func_180495_p(headPos.func_177979_c(1).func_177965_g(1));
        BlockState stateArmWest = world.func_180495_p(headPos.func_177979_c(1).func_177985_f(1));
        Block blockBelow1 = stateBelow1.func_177230_c();
        Block blockBelow2 = stateBelow2.func_177230_c();
        Block blockArmNorth = stateArmNorth.func_177230_c();
        Block blockArmSouth = stateArmSouth.func_177230_c();
        Block blockArmEast = stateArmEast.func_177230_c();
        Block blockArmWest = stateArmWest.func_177230_c();
        double spawnX = (double)headPos.func_177958_n() + 0.5;
        double spawnY = (double)headPos.func_177956_o() - 1.95;
        double spawnZ = (double)headPos.func_177952_p() + 0.5;
        if (GolemHeadBlock.doBlocksMatch(Blocks.field_196604_cC, blockBelow1, blockBelow2)) {
            GolemHeadBlock.removeGolemBody(world, headPos);
            SnowGolemEntity entitysnowman = (SnowGolemEntity)EntityType.field_200745_ak.func_200721_a(world);
            ExtraGolems.LOGGER.info("[Extra Golems]: Building regular boring Snow Golem");
            entitysnowman.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)entitysnowman);
            return true;
        }
        boolean isIron = GolemHeadBlock.doBlocksMatch(Blocks.field_150339_S, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        boolean flagX = false;
        if (!isIron) {
            isIron = GolemHeadBlock.doBlocksMatch(Blocks.field_150339_S, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            flagX = true;
        }
        if (isIron) {
            GolemHeadBlock.removeAllGolemBlocks(world, headPos, flagX);
            IronGolemEntity ironGolem = (IronGolemEntity)EntityType.field_200757_aw.func_200721_a(world);
            ExtraGolems.LOGGER.info("[Extra Golems]: Building regular boring Iron Golem");
            ironGolem.func_70849_f(true);
            ironGolem.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)ironGolem);
            return true;
        }
        if (GolemHeadBlock.isInvalidBlock(blockBelow1) || GolemHeadBlock.isInvalidBlock(blockBelow2)) {
            return false;
        }
        GolemBase golem = ExtraGolems.getGolem(world, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        flagX = false;
        if (golem == null) {
            golem = ExtraGolems.getGolem(world, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            flagX = true;
        }
        if (golem != null) {
            GolemHeadBlock.removeAllGolemBlocks(world, headPos, flagX);
            golem.func_70849_f(true);
            golem.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            ExtraGolems.LOGGER.debug("[Extra Golems]: Building golem " + golem.toString());
            world.func_217376_c((Entity)golem);
            if (placer != null && placer.func_130014_f_() instanceof ServerWorld) {
                golem.func_213386_a((IServerWorld)((ServerWorld)placer.func_130014_f_()), world.func_175649_E(headPos), SpawnReason.MOB_SUMMONED, null, null);
            }
            golem.onBuilt(stateBelow1, stateBelow2, flagX ? stateArmEast : stateArmWest, flagX ? stateArmNorth : stateArmSouth);
            return true;
        }
        return false;
    }

    public static boolean doBlocksMatch(Block master, Block ... toCheck) {
        boolean success = toCheck != null && toCheck.length > 0;
        for (Block b : toCheck) {
            success &= b == master;
        }
        return success;
    }

    public static void removeAllGolemBlocks(World world, BlockPos pos, boolean isXAligned) {
        GolemHeadBlock.removeGolemBody(world, pos);
        GolemHeadBlock.removeGolemArms(world, pos, isXAligned);
    }

    public static void removeGolemBody(World world, BlockPos head) {
        world.func_175655_b(head, false);
        world.func_175655_b(head.func_177979_c(1), false);
        world.func_175655_b(head.func_177979_c(2), false);
    }

    public static void removeGolemArms(World world, BlockPos pos, boolean isXAligned) {
        if (isXAligned) {
            world.func_175655_b(pos.func_177979_c(1).func_177985_f(1), false);
            world.func_175655_b(pos.func_177979_c(1).func_177965_g(1), false);
        } else {
            world.func_175655_b(pos.func_177979_c(1).func_177964_d(1), false);
            world.func_175655_b(pos.func_177979_c(1).func_177970_e(1), false);
        }
    }

    private static boolean isInvalidBlock(Block b) {
        return b == null || b == Blocks.field_150350_a || b == Blocks.field_150355_j;
    }
}

