/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.block.UtilityBlock;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PowerBlock
extends UtilityBlock {
    public static final IntegerProperty POWER_LEVEL = IntegerProperty.func_177719_a((String)"power", (int)0, (int)15);
    public static final int UPDATE_TICKS = 4;

    public PowerBlock(int powerLevel) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200944_c(), 4);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWER_LEVEL, (Comparable)Integer.valueOf(powerLevel)));
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        boolean hasPowerGolem;
        AxisAlignedBB toCheck = new AxisAlignedBB(pos).func_186662_g(0.25);
        List list = worldIn.func_217357_a(GolemBase.class, toCheck);
        boolean bl = hasPowerGolem = !list.isEmpty() && PowerBlock.hasPowerGolem(list);
        if (hasPowerGolem) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate);
        } else {
            this.remove((World)worldIn, state, pos, 3);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWER_LEVEL});
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((Property)POWER_LEVEL);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((Property)POWER_LEVEL);
    }

    public static boolean hasPowerGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.isProvidingPower()) continue;
            return true;
        }
        return false;
    }
}

