/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.EGConfig;
import com.mcmoddev.golems.EGRegistry;
import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GlowBlock;
import com.mcmoddev.golems.block.PowerBlock;
import com.mcmoddev.golems.entity.IArrowShooter;
import com.mcmoddev.golems.entity.IFuelConsumer;
import com.mcmoddev.golems.entity.IMultitextured;
import com.mcmoddev.golems.entity.IRandomExploder;
import com.mcmoddev.golems.entity.IRandomTeleporter;
import com.mcmoddev.golems.entity.goal.GoToWaterGoal;
import com.mcmoddev.golems.entity.goal.PlaceUtilityBlocksGoal;
import com.mcmoddev.golems.entity.goal.SwimUpGoal;
import com.mcmoddev.golems.golem_stats.GolemContainer;
import com.mcmoddev.golems.golem_stats.behavior.ExplodeBehavior;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import com.mcmoddev.golems.golem_stats.behavior.ShootArrowsBehavior;
import com.mcmoddev.golems.golem_stats.behavior.UseFuelBehavior;
import com.mcmoddev.golems.item.SpawnGolemItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class GolemBase
extends IronGolemEntity
implements IMultitextured,
IFuelConsumer,
IRandomTeleporter,
IRandomExploder,
IArrowShooter,
IEntityAdditionalSpawnData {
    protected static final DataParameter<String> MATERIAL = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Boolean> CHILD = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> TEXTURE = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> FUSE_LIT = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> ARROWS = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String KEY_MATERIAL = "Material";
    public static final String KEY_CHILD = "IsChild";
    private ResourceLocation material = new ResourceLocation("golems", "empty");
    private GolemContainer container = GolemContainer.EMPTY;
    protected ITextComponent description;
    protected final SwimmerPathNavigator waterNavigator;
    protected final GroundPathNavigator groundNavigator;
    protected boolean swimmingUp;
    protected int fuse;
    protected final RangedAttackGoal aiArrowAttack;
    protected final MeleeAttackGoal aiMeleeAttack;
    private Inventory inventory;
    protected int biomeColor = 8626266;

    public GolemBase(EntityType<? extends GolemBase> type, World world) {
        super(type, world);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
        this.aiArrowAttack = new RangedAttackGoal((IRangedAttackMob)this, 1.0, 28, 32.0f);
        this.aiMeleeAttack = new MeleeAttackGoal((CreatureEntity)this, 1.0, true);
        this.initArrowInventory();
    }

    public static GolemBase create(World world, ResourceLocation material) {
        GolemBase golem = new GolemBase(EGRegistry.GOLEM, world);
        golem.setMaterial(material);
        return golem;
    }

    public void setMaterial(ResourceLocation materialIn) {
        if (materialIn.equals((Object)this.material)) {
            return;
        }
        this.func_184212_Q().func_187227_b(MATERIAL, (Object)materialIn.toString());
        this.material = materialIn;
        this.container = ExtraGolems.GOLEM_CONTAINERS.get(materialIn).orElse(GolemContainer.EMPTY);
        this.field_110155_d = new AttributeModifierManager(this.container.getAttributeSupplier().get().func_233813_a_());
        if (SpawnGolemItem.BEDROCK_GOLEM.equals((Object)materialIn)) {
            this.func_184224_h(true);
        }
        if (!this.field_70170_p.func_201670_d()) {
            switch (this.container.getSwimAbility()) {
                case FLOAT: {
                    this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                    break;
                }
                case SWIM: {
                    this.field_70138_W = 1.0f;
                    this.field_70765_h = new SwimmingMovementController(this);
                    this.func_184644_a(PathNodeType.WATER, 0.0f);
                    this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal(this, 14, 1.0));
                    this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, (double)0.8f, 200));
                    this.field_70714_bg.func_75776_a(5, (Goal)new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F() + 1));
                    break;
                }
            }
            if (this.container.getAttributes().isHurtByWater()) {
                this.func_184644_a(PathNodeType.WATER, -1.0f);
            }
            this.registerGlowGoal();
            this.registerPowerGoal();
            this.container.getBehaviors().values().forEach(list -> list.forEach(b -> b.onRegisterGoals(this)));
        }
    }

    public ResourceLocation getMaterial() {
        return this.material;
    }

    public GolemContainer getContainer() {
        return this.container;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MATERIAL, (Object)new ResourceLocation("golems", "empty").toString());
        this.func_184212_Q().func_187214_a(CHILD, (Object)false);
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)0);
        this.func_184212_Q().func_187214_a(FUEL, (Object)0);
        this.func_184212_Q().func_187214_a(FUSE_LIT, (Object)false);
        this.func_184212_Q().func_187214_a(ARROWS, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (MATERIAL.equals(key)) {
            this.setMaterial(new ResourceLocation((String)this.func_184212_Q().func_187225_a(MATERIAL)));
        }
        if (CHILD.equals(key)) {
            if (this.func_70631_g_()) {
                double childHealth = Math.floor(this.getContainer().getAttributes().getHealth() * 0.3 * 10.0) / 10.0;
                double childAttack = Math.floor(this.getContainer().getAttributes().getAttack() * 0.6 * 10.0) / 10.0;
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(childHealth);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(childAttack);
                this.func_110148_a(Attributes.field_233820_c_).func_111128_a(0.0);
            } else {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getContainer().getAttributes().getHealth());
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.getContainer().getAttributes().getAttack());
                this.func_110148_a(Attributes.field_233820_c_).func_111128_a(this.getContainer().getAttributes().getKnockbackResist());
            }
            this.func_213323_x_();
        } else if (TEXTURE.equals(key)) {
            this.setTextureId((byte)this.getTextureId());
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70606_j(this.func_110138_aP());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    protected void registerGlowGoal() {
        if (this.container.getMaxLightLevel() > 0) {
            int lightInt = this.container.getMaxLightLevel();
            BlockState state = (BlockState)EGRegistry.UTILITY_LIGHT.func_176223_P().func_206870_a((Property)GlowBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightInt));
            this.field_70714_bg.func_75776_a(9, (Goal)new PlaceUtilityBlocksGoal(this, state, 6, true, (golem, pos) -> golem.isProvidingLight()));
        }
    }

    protected void registerPowerGoal() {
        if (this.getContainer().getMaxPowerLevel() > 0) {
            int powerInt = this.getContainer().getMaxPowerLevel();
            BlockState state = (BlockState)EGRegistry.UTILITY_POWER.func_176223_P().func_206870_a((Property)PowerBlock.POWER_LEVEL, (Comparable)Integer.valueOf(powerInt));
            int freq = 4;
            this.field_70714_bg.func_75776_a(9, (Goal)new PlaceUtilityBlocksGoal(this, state, 4, false, (golem, pos) -> golem.isProvidingPower()));
        }
    }

    public boolean canInteractChangeTexture() {
        return this.getContainer().getMultitexture().isPresent() && this.getContainer().getMultitexture().get().canCycle();
    }

    public boolean isProvidingLight() {
        if (this.getContainer().getMultitexture().isPresent()) {
            return this.getContainer().getMultitexture().get().getLight(this) > 0;
        }
        return this.getContainer().getMaxLightLevel() > 0;
    }

    public boolean isProvidingPower() {
        return this.getContainer().getMaxPowerLevel() > 0;
    }

    public float getHealAmount(ItemStack i) {
        float amount = (float)((double)this.func_110138_aP() * this.getContainer().getHealAmount(i.func_77973_b()));
        if (this.func_70631_g_()) {
            amount *= 1.75f;
        }
        return Math.min(amount, 64.0f);
    }

    public BlockPos getBlockBelow() {
        return this.func_226270_aj_();
    }

    public ItemStack getBanner() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    public void setBanner(ItemStack bannerItem) {
        this.func_184201_a(EquipmentSlotType.CHEST, bannerItem);
        if (bannerItem.func_77973_b() instanceof BannerItem) {
            this.func_184642_a(EquipmentSlotType.CHEST, 1.0f);
        }
    }

    public void func_70636_d() {
        BlockPos pos;
        super.func_70636_d();
        if (this.getContainer().getAttributes().isHurtByWater() && this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.getContainer().getAttributes().isHurtByHeat() && this.field_70170_p.func_226691_t_(pos = this.getBlockBelow().func_177981_b(2)).func_225486_c(pos) > 1.0f) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
        if (this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS) && this.field_70173_aa % 35 == 1) {
            boolean forceMelee = this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 8.0;
            this.updateCombatTask(forceMelee);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_201670_d()) {
            if (this.field_70173_aa % 15 == 1) {
                Biome biome = this.field_70170_p.func_226691_t_(this.getBlockBelow().func_177981_b(2));
                this.biomeColor = biome.func_225527_a_();
            }
            if (this.isFuseLit()) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + this.field_70146_Z.nextDouble() - 0.5, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + this.field_70146_Z.nextDouble() - 0.5, 0.0, 0.0, 0.0);
            }
            this.getContainer().getParticle().ifPresent(particle -> {
                if (particle.func_235047_a_(this.field_70146_Z)) {
                    this.field_70170_p.func_195594_a(particle.func_235044_a_(), this.func_226277_ct_() + this.field_70146_Z.nextDouble() - 0.5, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_70047_e(), this.func_226281_cx_() + this.field_70146_Z.nextDouble() - 0.5, 0.1 * (this.field_70146_Z.nextDouble() - 0.5), 0.1 * (this.field_70146_Z.nextDouble() - 0.5), 0.1 * (this.field_70146_Z.nextDouble() - 0.5));
                }
            });
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (!this.getContainer().getAttributes().isHurtByFall()) {
            return false;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        boolean flag = super.func_225503_b_(distance, damageMultiplier);
        int i = this.func_225508_e_(distance, damageMultiplier);
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_226295_cZ_();
            this.func_70097_a(DamageSource.field_76379_h, i);
            return true;
        }
        return flag;
    }

    public boolean func_230279_az_() {
        return this.getContainer().getAttributes().hasFireImmunity();
    }

    public boolean func_180427_aV() {
        return this.getContainer().getAttributes().hasExplosionImmunity();
    }

    public boolean func_213358_a(EntityType<?> type) {
        if (type == EntityType.field_200729_aH && this.func_70850_q()) {
            return EGConfig.enableFriendlyFire();
        }
        if (type == EntityType.field_200756_av || type == EGRegistry.GOLEM || type == EntityType.field_200757_aw || type == EntityType.field_200745_ak) {
            return false;
        }
        return super.func_213358_a(type);
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            double knockback = this.getContainer().getAttributes().getAttackKnockback();
            if (knockback > 0.0 && !this.func_70631_g_()) {
                Vector3d myPos = this.func_213303_ch();
                Vector3d ePos = target.func_213303_ch();
                double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * knockback;
                double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * knockback;
                target.func_213317_d(target.func_213322_ci().func_72441_c(dX, knockback / 2.0, dZ));
            }
            this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onHurtTarget(this, target)));
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        double knockback = this.getContainer().getAttributes().getAttackKnockback() * 0.25;
        if (source.func_76364_f() != null && knockback > 0.0 && !this.func_70631_g_()) {
            Vector3d myPos = this.func_213303_ch();
            Vector3d ePos = source.func_76364_f().func_213303_ch();
            double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * knockback;
            double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * knockback;
            source.func_76364_f().func_213317_d(source.func_76364_f().func_213322_ci().func_72441_c(dX, knockback / 2.0, dZ));
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        super.func_70665_d(source, amount);
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onActuallyHurt(this, source, amount)));
    }

    public ItemStack getPickedResult(RayTraceResult ray) {
        return this.container.hasBlocks() ? new ItemStack((IItemProvider)this.container.getAllBlocks().toArray(new Block[0])[0]) : ItemStack.field_190927_a;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.getBanner().func_190926_b() && stack.func_77973_b() instanceof ShearsItem) {
            this.func_70099_a(this.getBanner(), this.func_70631_g_() ? 0.9f : 1.4f);
            this.setBanner(ItemStack.field_190927_a);
            return ActionResultType.CONSUME;
        }
        if (stack.func_77973_b() instanceof BannerItem && this.processInteractBanner(player, hand, stack)) {
            return ActionResultType.CONSUME;
        }
        float healAmount = this.getHealAmount(stack);
        if (!stack.func_190926_b() && healAmount > 0.0f && this.processInteractHeal(player, hand, stack, healAmount)) {
            return ActionResultType.CONSUME;
        }
        if (hand == Hand.MAIN_HAND && !this.field_70170_p.func_201670_d() && !player.func_213453_ef() && this.canInteractChangeTexture() && this.cycleTexture()) {
            player.func_184609_a(hand);
            return ActionResultType.CONSUME;
        }
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onMobInteract(this, player, hand)));
        return super.func_230254_b_(player, hand);
    }

    protected boolean processInteractBanner(PlayerEntity player, Hand hand, ItemStack stack) {
        if (!this.getBanner().func_190926_b()) {
            this.func_70099_a(this.getBanner(), this.func_70631_g_() ? 0.9f : 1.4f);
        }
        this.setBanner(stack.func_77979_a(1));
        return true;
    }

    protected boolean processInteractHeal(PlayerEntity player, Hand hand, ItemStack stack, float healAmount) {
        if (EGConfig.enableHealGolems() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(healAmount);
            if (!player.func_184812_l_()) {
                if (stack.func_190916_E() > 1) {
                    stack.func_190918_g(1);
                } else {
                    player.func_184611_a(hand, stack.getContainerItem());
                }
            }
            if (this.func_70638_az() == player) {
                this.func_70604_c(null);
                this.func_70624_b(null);
            }
            Vector3d pos = this.func_213303_ch();
            SpawnGolemItem.spawnParticles(this.field_70170_p, pos.field_72450_a, pos.field_72448_b + (double)this.func_213302_cg() / 2.0, pos.field_72449_c, 0.15, (IParticleData)ParticleTypes.field_197590_A, 30);
            this.func_184185_a(SoundEvents.field_187845_fY, 0.85f, 1.1f + this.field_70146_Z.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    public boolean func_230270_dK_() {
        return this.getContainer().getAttributes().isHurtByWater();
    }

    public float func_70013_c() {
        return this.isProvidingLight() || this.isProvidingPower() ? 1.0f : super.func_70013_c();
    }

    protected ITextComponent func_225513_by_() {
        if (this.description == null) {
            this.description = new TranslationTextComponent("entity." + this.material.func_110624_b() + ".golem." + this.material.func_110623_a());
        }
        return this.description;
    }

    protected ResourceLocation func_184647_J() {
        return this.getContainer().getLootTable(this);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHILD);
    }

    public void setBaby(boolean isChild) {
        if ((Boolean)this.func_184212_Q().func_187225_a(CHILD) != isChild) {
            this.func_184212_Q().func_187227_b(CHILD, (Object)isChild);
            this.func_213323_x_();
        }
    }

    public void func_70645_a(DamageSource source) {
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onDie(this, source)));
        super.func_70645_a(source);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setMaterial(new ResourceLocation(tag.func_74779_i(KEY_MATERIAL)));
        this.setBaby(tag.func_74767_n(KEY_CHILD));
        this.container.getMultitexture().ifPresent(m -> this.loadTextureId(tag));
        this.initArrowInventory();
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onReadData(this, tag)));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74778_a(KEY_MATERIAL, this.getMaterial().toString());
        tag.func_74757_a(KEY_CHILD, this.func_70631_g_());
        this.container.getMultitexture().ifPresent(m -> this.saveTextureId(tag));
        this.getContainer().getBehaviors().values().forEach(list -> list.forEach(b -> b.onWriteData(this, tag)));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_192572_a(this.material);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.setMaterial(buffer.func_192575_l());
        this.func_70606_j(this.func_110138_aP());
    }

    protected SoundEvent func_184639_G() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return this.getGolemSound() == SoundEvents.field_187569_bQ ? SoundEvents.field_187565_bO : this.getGolemSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getGolemSound() == SoundEvents.field_187569_bQ ? SoundEvents.field_187561_bM : this.getGolemSound();
    }

    public final SoundEvent getGolemSound() {
        return this.container.getSound();
    }

    @Override
    public int getTextureCount() {
        return this.container.getMultitexture().isPresent() ? this.container.getMultitexture().get().getTextureCount() : 0;
    }

    @Override
    public void setTextureId(byte toSet) {
        if (toSet >= 0) {
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)toSet);
        }
    }

    @Override
    public int getTextureId() {
        return ((Byte)this.func_184212_Q().func_187225_a(TEXTURE)).byteValue();
    }

    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        this.container.getMultitexture().ifPresent(m -> this.setTextureId((byte)m.getTextureFromBlock(body.func_177230_c())));
    }

    public int getBiomeColor() {
        return this.biomeColor;
    }

    @Override
    public void setFuel(int fuel) {
        this.func_184212_Q().func_187227_b(FUEL, (Object)fuel);
    }

    @Override
    public int getFuel() {
        return (Integer)this.func_184212_Q().func_187225_a(FUEL);
    }

    @Override
    public int getMaxFuel() {
        List b = this.container.getBehaviors(GolemBehaviors.USE_FUEL);
        return b.isEmpty() ? 0 : ((UseFuelBehavior)b.get(0)).getMaxFuel();
    }

    @Override
    public GolemBase getGolemEntity() {
        return this;
    }

    @Override
    public int getFuseLen() {
        List b = this.container.getBehaviors(GolemBehaviors.EXPLODE);
        return b.isEmpty() ? 0 : ((ExplodeBehavior)b.get(0)).getFuseLen();
    }

    @Override
    public int getFuse() {
        return this.fuse;
    }

    @Override
    public void setFuse(int fuseIn) {
        this.fuse = fuseIn;
    }

    @Override
    public void setFuseLit(boolean litIn) {
        this.func_184212_Q().func_187227_b(FUSE_LIT, (Object)litIn);
    }

    @Override
    public boolean isFuseLit() {
        return (Boolean)this.func_184212_Q().func_187225_a(FUSE_LIT);
    }

    @Override
    public void initArrowInventory() {
        Inventory simplecontainer = this.inventory;
        this.inventory = new Inventory(9);
        if (simplecontainer != null) {
            simplecontainer.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(simplecontainer.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.func_76316_a((IInventory)this.inventory);
    }

    @Override
    public double getArrowDamage() {
        if (this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
            double multiplier = this.func_70631_g_() ? 0.5 : 1.0;
            return multiplier * ((ShootArrowsBehavior)this.getContainer().getBehaviors(GolemBehaviors.SHOOT_ARROWS).get(0)).getDamage();
        }
        return 0.0;
    }

    public boolean func_213365_e(ItemStack stack) {
        if (this.canAddArrowToInventory(stack)) {
            return true;
        }
        return super.func_213365_e(stack);
    }

    public boolean func_98052_bS() {
        return this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS) || super.func_98052_bS();
    }

    @Override
    public IInventory getArrowInventory() {
        return this.inventory;
    }

    @Override
    public RangedAttackGoal getRangedGoal() {
        return this.aiArrowAttack;
    }

    @Override
    public MeleeAttackGoal getMeleeGoal() {
        return this.aiMeleeAttack;
    }

    @Override
    public int getArrowsInInventory() {
        return (Integer)this.func_184212_Q().func_187225_a(ARROWS);
    }

    @Override
    public void setArrowsInInventory(int count) {
        this.func_184212_Q().func_187227_b(ARROWS, (Object)count);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
            this.dropArrowInventory();
        }
    }

    public boolean func_233665_g_(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ArrowItem && this.getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS) && this.canAddArrowToInventory(stack)) {
            this.addArrowToInventory(stack);
            return true;
        }
        return super.func_233665_g_(stack);
    }

    public void func_71001_a(Entity itemEntity, int quantity) {
        super.func_71001_a(itemEntity, quantity);
        this.func_76316_a(this.getArrowInventory());
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public void func_205343_av() {
        if (this.container.getSwimAbility() != GolemContainer.SwimMode.SWIM) {
            super.func_205343_av();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    protected float func_189749_co() {
        return this.container.getSwimAbility() == GolemContainer.SwimMode.SWIM ? 0.88f : super.func_189749_co();
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    public void setSwimmingUp(boolean isSwimmingUp) {
        this.swimmingUp = isSwimmingUp && this.container.getSwimAbility() == GolemContainer.SwimMode.SWIM;
    }

    public boolean isSwimmingUp() {
        if (this.container.getSwimAbility() != GolemContainer.SwimMode.SWIM) {
            return false;
        }
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    public static boolean isSwimmingUp(GolemBase golem) {
        return golem.swimmingUp;
    }

    public boolean shouldMoveToWater(Vector3d target) {
        return this.container.getSwimAbility() == GolemContainer.SwimMode.SWIM;
    }

    static class SwimmingMovementController
    extends MovementController {
        private final GolemBase golem;

        public SwimmingMovementController(GolemBase golem) {
            super((MobEntity)golem);
            this.golem = golem;
        }

        public void func_75641_c() {
            LivingEntity target = this.golem.func_70638_az();
            if (this.golem.isSwimmingUp() && this.golem.func_70090_H()) {
                if (target != null && target.func_226278_cu_() > this.golem.func_226278_cu_() || this.golem.swimmingUp) {
                    this.golem.func_213317_d(this.golem.func_213322_ci().func_72441_c(0.0, 0.002, 0.0));
                }
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.golem.func_70661_as().func_75500_f()) {
                    this.golem.func_70659_e(0.0f);
                    return;
                }
                double dX = this.field_75646_b - this.golem.func_226277_ct_();
                double dY = this.field_75647_c - this.golem.func_226278_cu_();
                double dZ = this.field_75644_d - this.golem.func_226281_cx_();
                double dTotal = MathHelper.func_76133_a((double)(dX * dX + dY * dY + dZ * dZ));
                dY /= dTotal;
                float rot = (float)(MathHelper.func_181159_b((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
                this.golem.field_70761_aq = this.golem.field_70177_z = this.func_75639_a(this.golem.field_70177_z, rot, 90.0f);
                float moveSpeed = (float)(this.field_75645_e * this.golem.func_233637_b_(Attributes.field_233821_d_));
                float moveSpeedAdjusted = MathHelper.func_219799_g((float)0.125f, (float)this.golem.func_70689_ay(), (float)moveSpeed);
                this.golem.func_70659_e(moveSpeedAdjusted);
                this.golem.func_213317_d(this.golem.func_213322_ci().func_72441_c((double)moveSpeedAdjusted * dX * 0.005, (double)moveSpeedAdjusted * dY * 0.1, (double)moveSpeedAdjusted * dZ * 0.005));
            } else {
                if (!this.golem.field_70122_E) {
                    this.golem.func_213317_d(this.golem.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                }
                super.func_75641_c();
            }
        }
    }
}

