/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.golem_stats.behavior.GolemBehaviors;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public interface IArrowShooter
extends IRangedAttackMob,
IInventoryChangedListener {
    public static final String KEY_INVENTORY = "Items";
    public static final String KEY_SLOT = "Slot";
    public static final int INVENTORY_SIZE = 9;
    public static final BiPredicate<IInventory, ItemStack> PICK_UP_ARROW_PRED = (inventory, stack) -> {
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ArrowItem) {
            int l = inventory.func_70302_i_();
            for (int i = 0; i < l; ++i) {
                ItemStack invStack = inventory.func_70301_a(i);
                if (!invStack.func_190926_b() && (invStack.func_77973_b() != stack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)invStack, (ItemStack)stack) || invStack.func_190916_E() + stack.func_190916_E() > invStack.func_77976_d())) continue;
                return true;
            }
        }
        return false;
    };

    public double getArrowDamage();

    public int getArrowsInInventory();

    public void setArrowsInInventory(int var1);

    public void initArrowInventory();

    public IInventory getArrowInventory();

    public RangedAttackGoal getRangedGoal();

    public MeleeAttackGoal getMeleeGoal();

    public GolemBase getGolemEntity();

    default public void func_76316_a(IInventory container) {
        GolemBase entity = this.getGolemEntity();
        if (!entity.field_70170_p.field_72995_K) {
            entity.setArrowsInInventory(this.countArrowsInInventory());
            entity.updateCombatTask(false);
        }
    }

    default public void func_82196_d(LivingEntity target, float distanceFactor) {
        GolemBase entity = this.getGolemEntity();
        ItemStack itemstack = IArrowShooter.findArrowsInInventory(this.getArrowInventory());
        if (!itemstack.func_190926_b()) {
            Vector3d pos = entity.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() * 0.55f), 0.0);
            Vector3d to = target.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() * 0.5f), 0.0);
            double i = 0.0;
            double l = pos.func_72436_e(to);
            double stepSize = 0.25;
            while (i * i < l) {
                Vector3d scaled = to.func_178788_d(pos).func_72432_b().func_186678_a(i);
                double x = pos.field_72450_a + scaled.field_72450_a;
                double y = pos.field_72448_b + scaled.field_72448_b;
                double z = pos.field_72449_c + scaled.field_72449_c;
                AxisAlignedBB aabb = new AxisAlignedBB(x - 0.2, y - 0.2, z - 0.2, x + 0.2, y + 0.2, z + 0.2);
                for (Entity e : entity.field_70170_p.func_72839_b((Entity)entity, aabb)) {
                    if (entity.func_213358_a(e.func_200600_R())) continue;
                    return;
                }
                i += stepSize;
            }
            AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)entity, (ItemStack)itemstack, (float)distanceFactor);
            Vector3d entityPos = entity.func_213303_ch();
            arrow.func_70107_b(entityPos.field_72450_a, entityPos.field_72448_b + (double)(entity.func_213302_cg() * 0.66666f), entityPos.field_72449_c);
            double d0 = target.func_226277_ct_() - entity.func_226277_ct_();
            double d1 = target.func_226283_e_(0.3333333333333333) - arrow.func_226278_cu_();
            double d2 = target.func_226281_cx_() - entity.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            arrow.func_212361_a((Entity)entity);
            arrow.func_70239_b(this.getArrowDamage() + entity.field_70170_p.func_201674_k().nextDouble() * 0.5);
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            arrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 1.6f, 1.2f);
            entity.func_184185_a(SoundEvents.field_187737_v, 1.0f, 0.9f + entity.field_70170_p.func_201674_k().nextFloat() * 0.2f);
            entity.field_70170_p.func_217376_c((Entity)arrow);
            itemstack.func_190918_g(1);
            this.func_76316_a(this.getArrowInventory());
        }
    }

    default public void saveArrowInventory(CompoundNBT tag) {
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < this.getArrowInventory().func_70302_i_(); ++i) {
            ItemStack stack = this.getArrowInventory().func_70301_a(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT slotNBT = new CompoundNBT();
            slotNBT.func_74774_a(KEY_SLOT, (byte)i);
            stack.func_77955_b(slotNBT);
            listNBT.add((Object)slotNBT);
        }
        tag.func_218657_a(KEY_INVENTORY, (INBT)listNBT);
    }

    default public void loadArrowInventory(CompoundNBT tag) {
        ListNBT list = tag.func_150295_c(KEY_INVENTORY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT slotNBT = list.func_150305_b(i);
            int slotNum = slotNBT.func_74771_c(KEY_SLOT) & 0xFF;
            if (slotNum < 0 || slotNum >= this.getArrowInventory().func_70302_i_()) continue;
            this.getArrowInventory().func_70299_a(slotNum, ItemStack.func_199557_a((CompoundNBT)slotNBT));
        }
        this.func_76316_a(this.getArrowInventory());
    }

    default public void updateCombatTask(boolean forceMelee) {
        GolemBase entity = this.getGolemEntity();
        if (!entity.field_70170_p.func_201670_d()) {
            entity.field_70714_bg.func_85156_a((Goal)this.getMeleeGoal());
            entity.field_70714_bg.func_85156_a((Goal)this.getRangedGoal());
            if (forceMelee || this.getArrowsInInventory() == 0) {
                entity.field_70714_bg.func_75776_a(0, (Goal)this.getMeleeGoal());
            } else {
                entity.field_70714_bg.func_75776_a(0, (Goal)this.getRangedGoal());
            }
        }
    }

    public static ItemStack findArrowsInInventory(IInventory inv) {
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArrowItem)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    default public void dropArrowInventory() {
        if (this.getArrowInventory() != null) {
            for (int i = 0; i < this.getArrowInventory().func_70302_i_(); ++i) {
                ItemStack itemstack = this.getArrowInventory().func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.getGolemEntity().func_199701_a_(itemstack);
            }
        }
    }

    default public int countArrowsInInventory() {
        int arrowCount = 0;
        int l = this.getArrowInventory().func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.getArrowInventory().func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArrowItem)) continue;
            arrowCount += stack.func_190916_E();
        }
        return arrowCount;
    }

    default public boolean canAddArrowToInventory(ItemStack stack) {
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ArrowItem && this.getGolemEntity().getContainer().hasBehavior(GolemBehaviors.SHOOT_ARROWS)) {
            int l = this.getArrowInventory().func_70302_i_();
            for (int i = 0; i < l; ++i) {
                ItemStack invStack = this.getArrowInventory().func_70301_a(i);
                if (!invStack.func_190926_b() && (invStack.func_77973_b() != stack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)invStack, (ItemStack)stack) || invStack.func_190916_E() + stack.func_190916_E() > invStack.func_77976_d())) continue;
                return true;
            }
        }
        return false;
    }

    default public void addArrowToInventory(ItemStack stack) {
        int l = this.getArrowInventory().func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack invStack = this.getArrowInventory().func_70301_a(i);
            if (!invStack.func_190926_b() && (invStack.func_77973_b() != stack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)invStack, (ItemStack)stack) || invStack.func_190916_E() + stack.func_190916_E() > stack.func_77976_d())) continue;
            stack.func_190920_e(stack.func_190916_E() + invStack.func_190916_E());
            this.getArrowInventory().func_70299_a(i, stack);
            this.func_76316_a(this.getArrowInventory());
            return;
        }
    }
}

