/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ForgeHooks;

public interface IFuelConsumer {
    public static final String KEY_FUEL = "Fuel";

    public void setFuel(int var1);

    public int getFuel();

    public int getMaxFuel();

    default public void saveFuel(CompoundNBT tag) {
        tag.func_74768_a(KEY_FUEL, this.getFuel());
    }

    default public void loadFuel(CompoundNBT tag) {
        this.setFuel(tag.func_74762_e(KEY_FUEL));
    }

    default public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    default public float getFuelPercentage() {
        return (float)this.getFuel() / (float)this.getMaxFuel();
    }

    default public void addFuel(int toAdd) {
        if (toAdd != 0) {
            this.setFuel(this.getFuel() + toAdd);
        }
    }

    default public void consumeFuel(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack) * (player.func_213453_ef() ? stack.func_190916_E() : 1);
        if (burnTime > 0 && this.getFuel() + burnTime <= this.getMaxFuel()) {
            if (player.func_213453_ef()) {
                this.addFuel(burnTime * stack.func_190916_E());
                stack = stack.getContainerItem();
            } else {
                this.addFuel(burnTime);
                if (stack.func_190916_E() > 1) {
                    stack.func_190918_g(1);
                } else {
                    stack = stack.getContainerItem();
                }
            }
            player.func_184611_a(hand, stack);
        }
        if (stack.func_77973_b() == Items.field_151131_as) {
            this.setFuel(0);
            player.func_184611_a(hand, stack.getContainerItem());
        }
    }
}

