/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.GolemBase;
import java.util.Collection;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;

public interface IRandomExploder {
    public static final String KEY_FUSE = "Fuse";
    public static final String KEY_FUSE_LIT = "FuseLit";

    public int getFuseLen();

    public int getFuse();

    public void setFuse(int var1);

    public void setFuseLit(boolean var1);

    public boolean isFuseLit();

    public GolemBase getGolemEntity();

    default public void resetFuse() {
        this.setFuse(this.getFuseLen());
    }

    default public void lightFuse() {
        if (!this.isFuseLit() && !this.getGolemEntity().func_203008_ap()) {
            this.resetFuse();
            this.setFuseLit(true);
            this.getGolemEntity().func_184185_a(SoundEvents.field_187572_ar, 0.9f, this.getGolemEntity().field_70170_p.func_201674_k().nextFloat());
        }
    }

    default public void saveFuse(CompoundNBT tag) {
        tag.func_74768_a(KEY_FUSE, this.getFuse());
        tag.func_74757_a(KEY_FUSE_LIT, this.isFuseLit());
    }

    default public void loadFuse(CompoundNBT tag) {
        this.setFuse(tag.func_74762_e(KEY_FUSE));
        this.setFuseLit(tag.func_74767_n(KEY_FUSE_LIT));
    }

    default public float getFusePercentage() {
        return (float)this.getFuse() / (float)this.getFuseLen();
    }

    default public void resetFuseLit() {
        this.setFuseLit(false);
        this.resetFuse();
    }

    default public void explode(float range) {
        GolemBase entity = this.getGolemEntity();
        if (!entity.field_70170_p.func_201670_d()) {
            boolean flag = entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
            Vector3d pos = entity.func_213303_ch();
            entity.field_70170_p.func_217385_a((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range, flag ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
            entity.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    default public void spawnLingeringCloud() {
        GolemBase entity = this.getGolemEntity();
        Collection collection = entity.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            entity.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }
}

