/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.event.AoeFunction;
import com.mcmoddev.golems.event.GolemModifyBlocksEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AoeBlocksGoal
extends Goal {
    protected final GolemBase entity;
    protected final int range;
    protected final int interval;
    protected final boolean sphere;
    protected final AoeFunction modifyFunction;
    protected int cooldown;

    public AoeBlocksGoal(GolemBase golemIn, int rangeIn, int intervalIn, boolean sphereIn, AoeFunction modifyIn) {
        this.entity = golemIn;
        this.range = rangeIn;
        this.interval = Math.max(1, intervalIn);
        this.sphere = sphereIn;
        this.modifyFunction = modifyIn;
    }

    public boolean func_75250_a() {
        return !this.entity.func_70631_g_() && this.range > 0 && this.entity.field_70170_p.func_201674_k().nextInt(this.interval) == 0;
    }

    public void func_75249_e() {
        BlockPos below = this.entity.getBlockBelow();
        GolemModifyBlocksEvent event = new GolemModifyBlocksEvent(this.entity, below, this.range, this.sphere, this.modifyFunction);
        if (!MinecraftForge.EVENT_BUS.post((Event)event) && event.getResult() != Event.Result.DENY) {
            event.getAffectedPositions().forEach(pos -> this.entity.field_70170_p.func_180501_a(pos, event.getFunction().map((LivingEntity)this.entity, (BlockPos)pos, this.entity.field_70170_p.func_180495_p(pos)), event.updateFlag));
        }
    }

    public boolean func_75253_b() {
        return false;
    }

    public static class GrowFunction
    implements AoeFunction {
        private final float growChance;

        public GrowFunction(float growChanceIn) {
            this.growChance = growChanceIn;
        }

        @Override
        public BlockState map(LivingEntity entity, BlockPos pos, BlockState input) {
            CropsBlock crop;
            if (input.func_177230_c() instanceof CropsBlock && !(crop = (CropsBlock)input.func_177230_c()).func_185525_y(input) && entity.field_70170_p.func_201674_k().nextFloat() < this.growChance) {
                int maxAge;
                int growAge = (Integer)input.func_177229_b((Property)crop.func_185524_e()) + MathHelper.func_76136_a((Random)entity.field_70170_p.func_201674_k(), (int)2, (int)5);
                if (growAge > (maxAge = crop.func_185526_g())) {
                    growAge = maxAge;
                }
                return crop.func_185528_e(growAge);
            }
            return input;
        }
    }

    public static class FreezeFunction
    implements AoeFunction {
        public final int iceChance = 52;
        public final int cobbleChance = 29;
        public final boolean frostedIce;

        public FreezeFunction(boolean useFrost) {
            this.frostedIce = useFrost;
        }

        @Override
        public BlockState map(LivingEntity entity, BlockPos pos, BlockState input) {
            BlockState cobbleState = Blocks.field_150347_e.func_176223_P();
            BlockState iceState = this.frostedIce ? Blocks.field_185778_de.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
            Material material = input.func_185904_a();
            if (material.func_76224_d()) {
                Block block = input.func_177230_c();
                if (block == Blocks.field_150355_j) {
                    boolean isNotPacked = this.frostedIce || entity.field_70170_p.func_201674_k().nextInt(100) < this.iceChance;
                    return isNotPacked ? iceState : Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_150353_l) {
                    boolean isNotObsidian = entity.field_70170_p.func_201674_k().nextInt(100) < this.cobbleChance;
                    return isNotObsidian ? cobbleState : Blocks.field_150343_Z.func_176223_P();
                }
            }
            return input;
        }
    }

    public static class DryFunction
    implements AoeFunction {
        @Override
        public BlockState map(LivingEntity entity, BlockPos pos, BlockState input) {
            if (input.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                return (BlockState)input.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
            }
            if (input.func_185904_a() == Material.field_151586_h || input.func_185904_a() == Material.field_203243_f) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return input;
        }
    }
}

