/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;

public class FollowGoal
extends Goal {
    protected final MobEntity entity;
    protected final Predicate<LivingEntity> followPredicate;
    protected LivingEntity followingEntity;
    protected final double speedModifier;
    protected final PathNavigator navigation;
    protected int timeToRecalcPath;
    protected final float stopDistance;
    protected float oldWaterCost;
    protected final float areaSize;

    public FollowGoal(MobEntity entityIn, double speed, float stopDistanceIn, float areaSizeIn, Predicate<LivingEntity> followPredicateIn) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entityIn;
        this.followPredicate = followPredicateIn;
        this.speedModifier = speed;
        this.navigation = entityIn.func_70661_as();
        this.stopDistance = stopDistanceIn;
        this.areaSize = areaSizeIn;
        if (!(entityIn.func_70661_as() instanceof GroundPathNavigator) && !(entityIn.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowGoal");
        }
    }

    public boolean func_75250_a() {
        List mobEntityList = this.entity.field_70170_p.func_175647_a(LivingEntity.class, this.entity.func_174813_aQ().func_186662_g((double)this.areaSize), this.followPredicate);
        if (!mobEntityList.isEmpty()) {
            for (LivingEntity mobEntity : mobEntityList) {
                if (mobEntity.func_82150_aj()) continue;
                this.followingEntity = mobEntity;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.followingEntity != null && !this.navigation.func_75500_f() && this.entity.func_70068_e((Entity)this.followingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.followingEntity = null;
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        double dZ;
        double dY;
        if (this.followingEntity == null || this.entity.func_110167_bD()) {
            return;
        }
        this.entity.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.entity.func_184649_cE());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        double dX = this.entity.func_226277_ct_() - this.followingEntity.func_226277_ct_();
        double distanceSq = dX * dX + (dY = this.entity.func_226278_cu_() - this.followingEntity.func_226278_cu_()) * dY + (dZ = this.entity.func_226281_cx_() - this.followingEntity.func_226281_cx_()) * dZ;
        if (distanceSq <= (double)(this.stopDistance * this.stopDistance)) {
            this.navigation.func_75499_g();
            return;
        }
        this.navigation.func_75497_a((Entity)this.followingEntity, this.speedModifier);
    }
}

