/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.goal;

import com.mcmoddev.golems.entity.GolemBase;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;

public class PlaceUtilityBlocksGoal
extends Goal {
    public final GolemBase golem;
    public final BlockState stateToPlace;
    public final int tickDelay;
    public final BiPredicate<GolemBase, BlockPos> predicate;
    public static final BiPredicate<GolemBase, BlockPos> ABOVE_AIR_PRED = (g, pos) -> g.field_70170_p.func_175623_d(pos.func_177977_b());
    public static final BiPredicate<GolemBase, BlockPos> ABOVE_WATER_PRED = (g, pos) -> g.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j;

    public PlaceUtilityBlocksGoal(GolemBase golemIn, BlockState stateIn, int interval, boolean onlyAboveEmpty, @Nullable BiPredicate<GolemBase, BlockPos> otherPredicate) {
        this.golem = golemIn;
        this.stateToPlace = stateIn;
        this.tickDelay = interval;
        BiPredicate<GolemBase, BlockPos> pred = PlaceUtilityBlocksGoal.makeBiPred(stateIn, onlyAboveEmpty);
        this.predicate = otherPredicate != null ? pred.and(otherPredicate) : pred;
    }

    public boolean func_75250_a() {
        return true;
    }

    public void func_75246_d() {
        if (this.golem.field_70173_aa % this.tickDelay == 0) {
            BlockPos blockPosIn = this.golem.getBlockBelow().func_177984_a();
            for (int i = 0; i < 4; ++i) {
                BlockPos pos = blockPosIn.func_177981_b(i);
                BlockState cur = this.golem.field_70170_p.func_180495_p(pos);
                if (cur.func_177230_c() == this.stateToPlace.func_177230_c()) {
                    return;
                }
                if (!this.predicate.test(this.golem, pos)) continue;
                this.golem.field_70170_p.func_180501_a(pos, this.getStateToPlace(cur), 6);
                return;
            }
        }
    }

    public void func_75249_e() {
        this.func_75246_d();
    }

    public static boolean canBeWaterlogged(BlockState stateIn) {
        return stateIn.func_235901_b_((Property)BlockStateProperties.field_208198_y);
    }

    public static BlockState getStateWaterlogged(BlockState stateIn) {
        return PlaceUtilityBlocksGoal.canBeWaterlogged(stateIn) ? (BlockState)stateIn.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)) : stateIn;
    }

    public static BiPredicate<GolemBase, BlockPos> makeBiPred(BlockState stateIn, boolean onlyAboveEmpty) {
        boolean canBeWaterlogged = PlaceUtilityBlocksGoal.canBeWaterlogged(stateIn);
        BiPredicate<GolemBase, BlockPos> pred = (golem, pos) -> golem.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j();
        if (canBeWaterlogged) {
            pred = pred.or((golem, pos) -> {
                BlockState toReplace = golem.field_70170_p.func_180495_p(pos);
                return toReplace.func_177230_c() == Blocks.field_150355_j && (Integer)toReplace.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            });
        }
        if (onlyAboveEmpty) {
            pred = canBeWaterlogged ? pred.and(ABOVE_WATER_PRED.or(ABOVE_AIR_PRED)) : pred.and(ABOVE_AIR_PRED);
        }
        return pred;
    }

    protected BlockState getStateToPlace(BlockState toReplace) {
        return toReplace.func_177230_c() == Blocks.field_150355_j ? PlaceUtilityBlocksGoal.getStateWaterlogged(this.stateToPlace) : this.stateToPlace;
    }
}

